/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.abel;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityGender;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.text.Guillemet;

public class EntityGenderUtils {
    public static EntityGender byEntityType(final LeafType type) {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test) {
                return test.getLeafType() == type;
            }
        };
    }

    public static EntityGender byEntityAlone(final Entity entity) {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test) {
                return test.getUid().equals(entity.getUid());
            }
        };
    }

    public static EntityGender byStereotype(final String stereotype) {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test) {
                if (test.getStereotype() == null) {
                    return false;
                }
                return stereotype.equals(test.getStereotype().getLabel(Guillemet.DOUBLE_COMPARATOR));
            }
        };
    }

    public static EntityGender byPackage(final Entity group) {
        if (group.isRoot()) {
            throw new IllegalArgumentException();
        }
        return new EntityGender(){

            @Override
            public boolean contains(Entity test) {
                if (test.getParentContainer().isRoot()) {
                    return false;
                }
                return group == test.getParentContainer();
            }
        };
    }

    public static EntityGender and(final EntityGender g1, final EntityGender g2) {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test) {
                return g1.contains(test) && g2.contains(test);
            }
        };
    }

    public static EntityGender all() {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test) {
                return true;
            }
        };
    }

    public static EntityGender emptyMethods() {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test) {
                return test.getBodier().getMethodsToDisplay().size() == 0;
            }
        };
    }

    public static EntityGender emptyFields() {
        return new EntityGender(){

            @Override
            public boolean contains(Entity test) {
                return test.getBodier().getFieldsToDisplay().size() == 0;
            }
        };
    }
}

