/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.plugin.IconTheme;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginIcon;
import com.jetbrains.plugin.structure.base.plugin.PluginManager;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.problems.InvalidDescriptorProblem;
import com.jetbrains.plugin.structure.base.problems.MultiplePluginDescriptors;
import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.UnableToExtractZip;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.problems.UnexpectedDescriptorElements;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.extractor.PluginExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.plugin.JarFilesResourceResolver;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.problems.PluginFileErrorsKt;
import com.jetbrains.plugin.structure.intellij.problems.PluginLibDirectoryIsEmpty;
import com.jetbrains.plugin.structure.intellij.resources.CompositeResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.DefaultResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom2.Document;
import org.jdom2.input.JDOMParseException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001/B\u0017\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\r\u001a\u00020\u000eJ(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J2\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0013H\u0002J2\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0013H\u0002J2\u0010#\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0013H\u0002J2\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0013H\u0002JD\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00132\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0,2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0013H\u0002J \u0010&\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginManager;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "myResourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "extractDirectory", "Ljava/nio/file/Path;", "(Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Ljava/nio/file/Path;)V", "createBundledPlugin", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "pluginFile", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "descriptorPath", "", "createPlugin", "validateDescriptor", "", "extractZipAndCreatePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "resourceResolver", "getIconsFromJarFile", "", "Lcom/jetbrains/plugin/structure/base/plugin/PluginIcon;", "jarFileSystem", "Ljava/nio/file/FileSystem;", "getInvalidPluginFileCreator", "pluginFileName", "getPluginCreatorWithResult", "loadIconsFromDir", "pluginDirectory", "loadPluginInfoFromDirectory", "parentPlugin", "loadPluginInfoFromJarFile", "jarFile", "loadPluginInfoFromJarOrDirectory", "loadPluginInfoFromLibDirectory", "root", "resolveOptionalDependencies", "", "currentPlugin", "visitedConfigurationFiles", "", "path", "Ljava/util/LinkedList;", "mainPlugin", "pluginCreator", "Companion", "structure-intellij"})
public final class IdePluginManager
implements PluginManager<IdePlugin> {
    private final ResourceResolver myResourceResolver;
    private final Path extractDirectory;
    private static final Logger LOG;
    @NotNull
    public static final String PLUGIN_XML = "plugin.xml";
    @NotNull
    public static final String META_INF = "META-INF";
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreator loadPluginInfoFromJarFile(Path jarFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin) {
        Closeable closeable;
        try {
            closeable = FileSystems.newFileSystem(jarFile, IdePluginManager.class.getClassLoader());
        }
        catch (Throwable e) {
            LOG.warn("Unable to extract " + jarFile + " (searching for " + descriptorPath + "): " + LanguageUtilsKt.getShortExceptionMessage((Throwable)e));
            return PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new UnableToExtractZip());
        }
        FileSystem zipFs = closeable;
        try {
            closeable = zipFs;
            boolean bl = false;
            Throwable throwable = null;
            try {
                PluginCreator pluginCreator;
                Closeable jarFileSystem = closeable;
                boolean bl2 = false;
                String entryName = "META-INF/" + descriptorPath;
                Path entry = ((FileSystem)jarFileSystem).getPath(IdePluginManager.Companion.toCanonicalPath(entryName), new String[0]);
                if (Files.exists(entry, new LinkOption[0])) {
                    PluginCreator pluginCreator2;
                    try {
                        Document document;
                        Closeable closeable2 = Files.newInputStream(entry, new OpenOption[0]);
                        boolean bl3 = false;
                        Throwable throwable2 = null;
                        try {
                            InputStream it = (InputStream)closeable2;
                            boolean bl4 = false;
                            Document document2 = JDOMUtil.loadDocument(it);
                            document = document2;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"Files.newInputStream(ent\u2026OMUtil.loadDocument(it) }");
                        Document document3 = document;
                        Closeable closeable3 = jarFileSystem;
                        Intrinsics.checkExpressionValueIsNotNull((Object)closeable3, (String)"jarFileSystem");
                        List<PluginIcon> icons = this.getIconsFromJarFile((FileSystem)closeable3);
                        Path path = entry;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"entry");
                        PluginCreator plugin = PluginCreator.Companion.createPlugin(jarFile, descriptorPath, parentPlugin, validateDescriptor, document3, path, resourceResolver);
                        plugin.setIcons(icons);
                        pluginCreator2 = plugin;
                    }
                    catch (Exception e) {
                        LOG.info("Unable to read file " + descriptorPath, (Throwable)e);
                        String message2 = e.getLocalizedMessage();
                        pluginCreator2 = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new UnableToReadDescriptor(descriptorPath, message2));
                    }
                    pluginCreator = pluginCreator2;
                } else {
                    pluginCreator = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath));
                }
                PluginCreator pluginCreator3 = pluginCreator;
                return pluginCreator3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to read " + jarFile + " in search of " + descriptorPath + ": " + e.getMessage());
            return PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new UnableToExtractZip());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginIcon> getIconsFromJarFile(FileSystem jarFileSystem) {
        void $this$mapNotNullTo$iv$iv;
        IconTheme[] $this$mapNotNull$iv = IconTheme.values();
        boolean $i$f$mapNotNull = false;
        IconTheme[] iconThemeArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_9 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_9).length;
        for (int i = 0; i < n; ++i) {
            PluginIcon pluginIcon;
            Path iconPath;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var9_9[i];
            boolean bl = false;
            void theme = element$iv$iv;
            boolean bl2 = false;
            String iconEntryName = "META-INF/" + IdePluginManager.Companion.getIconFileName((IconTheme)theme);
            Path path = iconPath = jarFileSystem.getPath(META_INF, IdePluginManager.Companion.getIconFileName((IconTheme)theme));
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"iconPath");
            if ((FileUtilKt.exists((Path)path) ? new PluginIcon((IconTheme)theme, FileUtilKt.readBytes((Path)iconPath), iconEntryName) : null) == null) continue;
            pluginIcon = pluginIcon;
            boolean bl3 = false;
            boolean bl4 = false;
            PluginIcon it$iv$iv = pluginIcon;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PluginCreator loadPluginInfoFromDirectory(Path pluginDirectory, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin) {
        PluginCreator pluginCreator;
        Path descriptorFile;
        Path path = descriptorFile = pluginDirectory.resolve(META_INF).resolve(FileUtilKt.withPathSeparatorOf((String)descriptorPath, (Path)pluginDirectory));
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"descriptorFile");
        if (!FileUtilKt.exists((Path)path)) {
            pluginCreator = this.loadPluginInfoFromLibDirectory(pluginDirectory, descriptorPath, validateDescriptor, resourceResolver, parentPlugin);
        } else {
            PluginCreator pluginCreator2;
            try {
                Document document = JDOMUtil.loadDocument(Files.newInputStream(descriptorFile, new OpenOption[0]));
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"JDOMUtil.loadDocument(Fi\u2026utStream(descriptorFile))");
                Document document2 = document;
                List<PluginIcon> icons = this.loadIconsFromDir(pluginDirectory);
                PluginCreator plugin = PluginCreator.Companion.createPlugin(pluginDirectory, descriptorPath, parentPlugin, validateDescriptor, document2, descriptorFile, resourceResolver);
                plugin.setIcons(icons);
                pluginCreator2 = plugin;
            }
            catch (JDOMParseException e) {
                int lineNumber = e.getLineNumber();
                String message2 = lineNumber != -1 ? "unexpected element on line " + lineNumber : "unexpected elements";
                LOG.info("Unable to parse plugin descriptor " + descriptorPath + " of plugin " + descriptorFile, (Throwable)e);
                pluginCreator2 = PluginCreator.Companion.createInvalidPlugin(pluginDirectory, descriptorPath, (PluginProblem)new UnexpectedDescriptorElements(message2, descriptorPath));
            }
            catch (Exception e) {
                LOG.info("Unable to read plugin descriptor " + descriptorPath + " of plugin " + descriptorFile, (Throwable)e);
                pluginCreator2 = PluginCreator.Companion.createInvalidPlugin(pluginDirectory, descriptorPath, (PluginProblem)new UnableToReadDescriptor(descriptorPath, descriptorPath));
            }
            pluginCreator = pluginCreator2;
        }
        return pluginCreator;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginIcon> loadIconsFromDir(Path pluginDirectory) throws IOException {
        void $this$mapNotNullTo$iv$iv;
        IconTheme[] $this$mapNotNull$iv = IconTheme.values();
        boolean $i$f$mapNotNull = false;
        IconTheme[] iconThemeArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_9 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_9).length;
        for (int i = 0; i < n; ++i) {
            PluginIcon pluginIcon;
            Path iconFile;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var9_9[i];
            boolean bl = false;
            void theme = element$iv$iv;
            boolean bl2 = false;
            Path path = iconFile = pluginDirectory.resolve(META_INF).resolve(IdePluginManager.Companion.getIconFileName((IconTheme)theme));
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"iconFile");
            if (FileUtilKt.exists((Path)path)) {
                byte[] byArray = Files.readAllBytes(iconFile);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.readAllBytes(iconFile)");
                pluginIcon = new PluginIcon((IconTheme)theme, byArray, FileUtilKt.getSimpleName((Path)iconFile));
            } else {
                pluginIcon = null;
            }
            if (pluginIcon == null) continue;
            PluginIcon pluginIcon2 = pluginIcon;
            boolean bl3 = false;
            boolean bl4 = false;
            PluginIcon it$iv$iv = pluginIcon2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final PluginCreator loadPluginInfoFromLibDirectory(Path root, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin) {
        PluginCreator pluginCreator;
        void $this$filterTo$iv$iv;
        Path libDir;
        Path path = libDir = root.resolve("lib");
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"libDir");
        if (!FileUtilKt.isDirectory((Path)path)) {
            return PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath));
        }
        List files = FileUtilKt.listFiles((Path)libDir);
        if (files.isEmpty()) {
            return PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, (PluginProblem)new PluginLibDirectoryIsEmpty());
        }
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!FileUtilKt.isJar((Path)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List jarFiles = (List)destination$iv$iv;
        ResourceResolver libResourceResolver = new JarFilesResourceResolver(jarFiles);
        ResourceResolver compositeResolver = new CompositeResourceResolver(CollectionsKt.listOf((Object[])new ResourceResolver[]{libResourceResolver, resourceResolver}));
        List results = new ArrayList();
        for (Path file : files) {
            PluginCreator pluginCreator2;
            if (FileUtilKt.isJar((Path)file) || FileUtilKt.isZip((Path)file)) {
                pluginCreator2 = this.loadPluginInfoFromJarFile(file, descriptorPath, validateDescriptor, compositeResolver, parentPlugin);
            } else {
                if (!FileUtilKt.isDirectory((Path)file)) continue;
                pluginCreator2 = this.loadPluginInfoFromDirectory(file, descriptorPath, validateDescriptor, resourceResolver, parentPlugin);
            }
            PluginCreator innerCreator = pluginCreator2;
            results.add(innerCreator);
        }
        List possibleResults2 = results.stream().filter(loadPluginInfoFromLibDirectory.possibleResults.1.INSTANCE).collect(Collectors.toList());
        if (possibleResults2.size() > 1) {
            PluginCreator first = (PluginCreator)possibleResults2.get(0);
            PluginCreator second = (PluginCreator)possibleResults2.get(1);
            PluginProblem multipleDescriptorsProblem = (PluginProblem)new MultiplePluginDescriptors(first.getDescriptorPath(), first.getPluginFileName(), second.getDescriptorPath(), second.getPluginFileName());
            return PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, multipleDescriptorsProblem);
        }
        if (possibleResults2.size() == 1) {
            Object t = possibleResults2.get(0);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"possibleResults[0]");
            pluginCreator = (PluginCreator)t;
        } else {
            pluginCreator = PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath));
        }
        return pluginCreator;
    }

    private final PluginCreator loadPluginInfoFromJarOrDirectory(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin) {
        PluginCreator pluginCreator;
        String systemIndependentDescriptorPath = FileUtilKt.toSystemIndependentName((String)descriptorPath);
        if (FileUtilKt.isDirectory((Path)pluginFile)) {
            pluginCreator = this.loadPluginInfoFromDirectory(pluginFile, systemIndependentDescriptorPath, validateDescriptor, resourceResolver, parentPlugin);
        } else if (FileUtilKt.isJar((Path)pluginFile)) {
            pluginCreator = this.loadPluginInfoFromJarFile(pluginFile, systemIndependentDescriptorPath, validateDescriptor, resourceResolver, parentPlugin);
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        return pluginCreator;
    }

    private final void resolveOptionalDependencies(Path pluginFile, PluginCreator pluginCreator, ResourceResolver resourceResolver) {
        if (pluginCreator.isSuccess()) {
            this.resolveOptionalDependencies(pluginCreator, new HashSet(), new LinkedList<String>(), pluginFile, resourceResolver, pluginCreator);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveOptionalDependencies(PluginCreator currentPlugin, Set<String> visitedConfigurationFiles, LinkedList<String> path, Path pluginFile, ResourceResolver resourceResolver, PluginCreator mainPlugin) {
        if (!visitedConfigurationFiles.add(currentPlugin.getDescriptorPath())) {
            return;
        }
        path.addLast(currentPlugin.getDescriptorPath());
        Map<PluginDependency, String> optionalDependenciesConfigFiles = currentPlugin.getOptionalDependenciesConfigFiles();
        Object object = optionalDependenciesConfigFiles;
        boolean bl = false;
        Iterator<Map.Entry<PluginDependency, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void pluginDependency;
            Map.Entry<PluginDependency, String> entry;
            Map.Entry<PluginDependency, String> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            String configurationFile = entry2.getValue();
            if (path.contains(configurationFile)) {
                List configurationFilesCycle = new ArrayList(path);
                configurationFilesCycle.add(configurationFile);
                mainPlugin.registerOptionalDependenciesConfigurationFilesCycleProblem(configurationFilesCycle);
                return;
            }
            PluginCreator optionalDependencyCreator = this.loadPluginInfoFromJarOrDirectory(pluginFile, configurationFile, false, resourceResolver, currentPlugin);
            currentPlugin.addOptionalDescriptor((PluginDependency)pluginDependency, configurationFile, optionalDependencyCreator);
            this.resolveOptionalDependencies(optionalDependencyCreator, visitedConfigurationFiles, path, pluginFile, resourceResolver, mainPlugin);
        }
        path.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreator extractZipAndCreatePlugin(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver) {
        PluginCreator pluginCreator;
        ExtractorResult extractorResult;
        ExtractorResult extractorResult2;
        try {
            extractorResult2 = PluginExtractor.INSTANCE.extractPlugin(pluginFile, this.extractDirectory);
        }
        catch (Exception e) {
            LOG.info("Unable to extract plugin zip " + FileUtilKt.getSimpleName((Path)pluginFile), (Throwable)e);
            return PluginCreator.Companion.createInvalidPlugin(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath, (PluginProblem)new UnableToExtractZip());
        }
        extractorResult2 = extractorResult = extractorResult2;
        if (extractorResult2 instanceof ExtractorResult.Success) {
            Closeable closeable = ((ExtractorResult.Success)extractorResult).getExtractedPlugin();
            boolean bl = false;
            Throwable throwable = null;
            try {
                PluginCreator pluginCreator2;
                ExtractedPlugin $dstr$extractedFile = (ExtractedPlugin)closeable;
                boolean bl2 = false;
                Path extractedFile = $dstr$extractedFile.component1();
                if (FileUtilKt.isJar((Path)extractedFile) || FileUtilKt.isDirectory((Path)extractedFile)) {
                    PluginCreator pluginCreator3 = this.loadPluginInfoFromJarOrDirectory(extractedFile, descriptorPath, validateDescriptor, resourceResolver, null);
                    this.resolveOptionalDependencies(extractedFile, pluginCreator3, this.myResourceResolver);
                    pluginCreator2 = pluginCreator3;
                } else {
                    pluginCreator2 = this.getInvalidPluginFileCreator(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath);
                }
                PluginCreator pluginCreator4 = pluginCreator2;
                pluginCreator = pluginCreator4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else if (extractorResult2 instanceof ExtractorResult.Fail) {
            pluginCreator = PluginCreator.Companion.createInvalidPlugin(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath, ((ExtractorResult.Fail)extractorResult).getPluginProblem());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginCreator;
    }

    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull Path pluginFile) {
        Intrinsics.checkParameterIsNotNull((Object)pluginFile, (String)"pluginFile");
        return IdePluginManager.createPlugin$default(this, pluginFile, true, null, 4, null);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createPlugin(@NotNull Path pluginFile, boolean validateDescriptor, @NotNull String descriptorPath) {
        Intrinsics.checkParameterIsNotNull((Object)pluginFile, (String)"pluginFile");
        Intrinsics.checkParameterIsNotNull((Object)descriptorPath, (String)"descriptorPath");
        PluginCreator pluginCreator = this.getPluginCreatorWithResult(pluginFile, validateDescriptor, descriptorPath);
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createPlugin$default(IdePluginManager idePluginManager, Path path, boolean bl, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = PLUGIN_XML;
        }
        return idePluginManager.createPlugin(path, bl, string);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createBundledPlugin(@NotNull Path pluginFile, @NotNull IdeVersion ideVersion, @NotNull String descriptorPath) {
        Intrinsics.checkParameterIsNotNull((Object)pluginFile, (String)"pluginFile");
        Intrinsics.checkParameterIsNotNull((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkParameterIsNotNull((Object)descriptorPath, (String)"descriptorPath");
        PluginCreator pluginCreator = this.getPluginCreatorWithResult(pluginFile, false, descriptorPath);
        String string = ideVersion.asStringWithoutProductCode();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ideVersion.asStringWithoutProductCode()");
        pluginCreator.setPluginVersion(string);
        return pluginCreator.getPluginCreationResult();
    }

    private final PluginCreator getPluginCreatorWithResult(Path pluginFile, boolean validateDescriptor, String descriptorPath) {
        boolean bl = FileUtilKt.exists((Path)pluginFile);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Plugin file " + pluginFile + " does not exist";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        PluginCreator pluginCreator = null;
        if (FileUtilKt.isZip((Path)pluginFile)) {
            pluginCreator = this.extractZipAndCreatePlugin(pluginFile, descriptorPath, validateDescriptor, this.myResourceResolver);
        } else if (FileUtilKt.isJar((Path)pluginFile) || FileUtilKt.isDirectory((Path)pluginFile)) {
            pluginCreator = this.loadPluginInfoFromJarOrDirectory(pluginFile, descriptorPath, validateDescriptor, this.myResourceResolver, null);
            this.resolveOptionalDependencies(pluginFile, pluginCreator, this.myResourceResolver);
        } else {
            pluginCreator = this.getInvalidPluginFileCreator(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath);
        }
        pluginCreator.setOriginalFile(pluginFile);
        return pluginCreator;
    }

    private final PluginCreator getInvalidPluginFileCreator(String pluginFileName, String descriptorPath) {
        return PluginCreator.Companion.createInvalidPlugin(pluginFileName, descriptorPath, (PluginProblem)PluginFileErrorsKt.createIncorrectIntellijFileProblem(pluginFileName));
    }

    private IdePluginManager(ResourceResolver myResourceResolver, Path extractDirectory) {
        this.myResourceResolver = myResourceResolver;
        this.extractDirectory = extractDirectory;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(IdePluginManager.class);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="createPlugin(pluginFile.toPath())"), message="Use method with java.nio.Path instead of java.io.File")
    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull File pluginFile) {
        Intrinsics.checkParameterIsNotNull((Object)pluginFile, (String)"pluginFile");
        return PluginManager.DefaultImpls.createPlugin((PluginManager)this, (File)pluginFile);
    }

    public /* synthetic */ IdePluginManager(ResourceResolver myResourceResolver, Path extractDirectory, DefaultConstructorMarker $constructor_marker) {
        this(myResourceResolver, extractDirectory);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager() {
        return Companion.createManager();
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver) {
        return Companion.createManager(resourceResolver);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull Path extractDirectory) {
        return Companion.createManager(extractDirectory);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory) {
        return Companion.createManager(resourceResolver, extractDirectory);
    }

    @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(extractDirectory.toPath())"))
    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull File extractDirectory) {
        return Companion.createManager(extractDirectory);
    }

    @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(resourceResolver, extractDirectory.toPath())"))
    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull File extractDirectory) {
        return Companion.createManager(resourceResolver, extractDirectory);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "META_INF", "", "PLUGIN_XML", "createManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "extractDirectory", "Ljava/io/File;", "Ljava/nio/file/Path;", "getIconFileName", "iconTheme", "Lcom/jetbrains/plugin/structure/base/plugin/IconTheme;", "hasOnlyInvalidDescriptorErrors", "", "creator", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "toCanonicalPath", "descriptorPath", "structure-intellij"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager() {
            return this.createManager((ResourceResolver)DefaultResourceResolver.INSTANCE, Settings.EXTRACT_DIRECTORY.getAsPath());
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver) {
            Intrinsics.checkParameterIsNotNull((Object)resourceResolver, (String)"resourceResolver");
            return this.createManager(resourceResolver, Settings.EXTRACT_DIRECTORY.getAsPath());
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull Path extractDirectory) {
            Intrinsics.checkParameterIsNotNull((Object)extractDirectory, (String)"extractDirectory");
            return this.createManager((ResourceResolver)DefaultResourceResolver.INSTANCE, extractDirectory);
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory) {
            Intrinsics.checkParameterIsNotNull((Object)resourceResolver, (String)"resourceResolver");
            Intrinsics.checkParameterIsNotNull((Object)extractDirectory, (String)"extractDirectory");
            return new IdePluginManager(resourceResolver, extractDirectory, null);
        }

        @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(extractDirectory.toPath())"))
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull File extractDirectory) {
            Intrinsics.checkParameterIsNotNull((Object)extractDirectory, (String)"extractDirectory");
            ResourceResolver resourceResolver = DefaultResourceResolver.INSTANCE;
            Path path = extractDirectory.toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"extractDirectory.toPath()");
            return this.createManager(resourceResolver, path);
        }

        @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(resourceResolver, extractDirectory.toPath())"))
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull File extractDirectory) {
            Intrinsics.checkParameterIsNotNull((Object)resourceResolver, (String)"resourceResolver");
            Intrinsics.checkParameterIsNotNull((Object)extractDirectory, (String)"extractDirectory");
            Path path = extractDirectory.toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"extractDirectory.toPath()");
            return this.createManager(resourceResolver, path);
        }

        private final boolean hasOnlyInvalidDescriptorErrors(PluginCreator creator) {
            boolean bl;
            block7: {
                PluginCreationResult<IdePlugin> pluginCreationResult = creator.getPluginCreationResult();
                if (pluginCreationResult instanceof PluginCreationSuccess) {
                    bl = false;
                } else if (pluginCreationResult instanceof PluginCreationFail) {
                    List errorsAndWarnings = ((PluginCreationFail)pluginCreationResult).getErrorsAndWarnings();
                    Iterable $this$all$iv = errorsAndWarnings;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PluginProblem it = (PluginProblem)element$iv;
                            boolean bl2 = false;
                            if (it.getLevel() != PluginProblem.Level.ERROR || it instanceof InvalidDescriptorProblem) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bl;
        }

        private final String toCanonicalPath(String descriptorPath) {
            return ((Object)Paths.get(FileUtilKt.toSystemIndependentName((String)descriptorPath), new String[0]).normalize()).toString();
        }

        private final String getIconFileName(IconTheme iconTheme) {
            return "pluginIcon" + iconTheme.getSuffix() + ".svg";
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$hasOnlyInvalidDescriptorErrors(Companion $this, PluginCreator creator) {
            return $this.hasOnlyInvalidDescriptorErrors(creator);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

