/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.resources.DefaultResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/JarFilesResourceResolver;", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "jarFiles", "", "Ljava/nio/file/Path;", "(Ljava/util/List;)V", "resolveResource", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver$Result;", "relativePath", "", "basePath", "structure-intellij"})
public final class JarFilesResourceResolver
implements ResourceResolver {
    private final List<Path> jarFiles;

    @Override
    @NotNull
    public ResourceResolver.Result resolveResource(@NotNull String relativePath, @NotNull Path basePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)basePath, (String)"basePath");
        ResourceResolver.Result resourceResult = DefaultResourceResolver.INSTANCE.resolveResource(relativePath, basePath);
        if (!(resourceResult instanceof ResourceResolver.Result.NotFound)) {
            return resourceResult;
        }
        String finalPath = ((Object)basePath.resolveSibling(relativePath)).toString();
        for (Path jarFile : this.jarFiles) {
            ResourceResolver.Result.Found found;
            FileSystem jarFs = FileSystems.newFileSystem(jarFile, JarFilesResourceResolver.class.getClassLoader());
            try {
                ResourceResolver.Result.Found found2;
                Path path;
                Path path2 = path = jarFs.getPath(FileUtilKt.withZipFsSeparator((String)finalPath), new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
                if (FileUtilKt.exists((Path)path2)) {
                    InputStream inputStream = FileUtilKt.inputStream((Path)path);
                    FileSystem fileSystem = jarFs;
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem, (String)"jarFs");
                    found2 = new ResourceResolver.Result.Found(path, inputStream, fileSystem);
                } else {
                    found2 = null;
                }
                found = found2;
            }
            catch (Throwable e) {
                jarFs.close();
                throw e;
            }
            ResourceResolver.Result.Found foundResult = found;
            if (foundResult != null) {
                return foundResult;
            }
            jarFs.close();
        }
        return ResourceResolver.Result.NotFound.INSTANCE;
    }

    public JarFilesResourceResolver(@NotNull List<? extends Path> jarFiles) {
        Intrinsics.checkParameterIsNotNull(jarFiles, (String)"jarFiles");
        this.jarFiles = jarFiles;
    }
}

