/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.xinclude;

import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncludeEntry;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncluder;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncluderException;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncluderKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom2.Attribute;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u001e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J4\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J4\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\f\u0010 \u001a\u00020\u0019*\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/plugin/structure/intellij/xinclude/XIncluder;", "", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "(Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;)V", "checkCyclicReference", "", "xincludeEntry", "Lcom/jetbrains/plugin/structure/intellij/xinclude/XIncludeEntry;", "bases", "Ljava/util/Stack;", "isIncludeElement", "", "element", "Lorg/jdom2/Element;", "resolveIncludeOrNonInclude", "", "Lorg/jdom2/Content;", "resolveNonXIncludeElement", "resolveXIncludeElements", "xincludeElement", "resolveXIncludes", "Lorg/jdom2/Document;", "document", "presentablePath", "", "documentPath", "Ljava/nio/file/Path;", "resolveXIncludesOfRemoteDocument", "remoteDocument", "selectContents", "remoteRootElement", "getElementNameAndAttributes", "Companion", "structure-intellij"})
public final class XIncluder {
    private final ResourceResolver resourceResolver;
    public static final Companion Companion = new Companion(null);

    private final Document resolveXIncludes(Document document, String presentablePath, Path documentPath) {
        XIncludeEntry startEntry = new XIncludeEntry(presentablePath, documentPath);
        Element element = document.getRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"document.rootElement");
        if (this.isIncludeElement(element)) {
            List list = CollectionsKt.listOf((Object)startEntry);
            StringBuilder stringBuilder = new StringBuilder().append("Invalid root element ");
            Element element2 = document.getRootElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"document.rootElement");
            throw (Throwable)new XIncluderException(list, stringBuilder.append(this.getElementNameAndAttributes(element2)).toString());
        }
        Stack<XIncludeEntry> bases = new Stack<XIncludeEntry>();
        bases.push(startEntry);
        Element element3 = document.getRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"document.rootElement");
        Element rootElement = this.resolveNonXIncludeElement(element3, bases);
        return new Document(rootElement);
    }

    private final List<Content> resolveIncludeOrNonInclude(Element element, Stack<XIncludeEntry> bases) {
        return this.isIncludeElement(element) ? this.resolveXIncludeElements(element, bases) : CollectionsKt.listOf((Object)this.resolveNonXIncludeElement(element, bases));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Content> resolveXIncludeElements(Element xincludeElement, Stack<XIncludeEntry> bases) {
        Path basePath;
        ResourceResolver.Result resourceResult;
        String href = xincludeElement.getAttributeValue("href");
        String presentableXInclude = this.getElementNameAndAttributes(xincludeElement);
        CharSequence charSequence = href;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "Missing or empty 'href' attribute in " + presentableXInclude);
        }
        String parseAttribute = xincludeElement.getAttributeValue("parse");
        if (parseAttribute != null && Intrinsics.areEqual((Object)parseAttribute, (Object)"xml") ^ true) {
            throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "Attribute 'parse' must be 'xml' but was '" + parseAttribute + "' in " + presentableXInclude);
        }
        String baseAttribute = xincludeElement.getAttributeValue("base", Namespace.XML_NAMESPACE);
        if (baseAttribute != null) {
            throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "'base' attribute of xi:include is not supported!");
        }
        XIncludeEntry xIncludeEntry = bases.peek();
        if (xIncludeEntry == null) {
            Intrinsics.throwNpe();
        }
        if ((resourceResult = this.resourceResolver.resolveResource(href, basePath = xIncludeEntry.getDocumentPath())) instanceof ResourceResolver.Result.Found) {
            Closeable closeable = (Closeable)((Object)resourceResult);
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                InputStream inputStream;
                ResourceResolver.Result.Found it = (ResourceResolver.Result.Found)closeable;
                boolean bl4 = false;
                try {
                    inputStream = it.getResourceStream();
                    int n = 8192;
                    boolean bl5 = false;
                    inputStream = JDOMUtil.loadDocument(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n));
                }
                catch (Exception e) {
                    throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "Invalid document '" + href + "' referenced in " + presentableXInclude, e);
                }
                InputStream inputStream2 = inputStream;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"try {\n          JDOMUtil\u2026leXInclude\", e)\n        }");
                InputStream remoteDocument = inputStream2;
                XIncludeEntry xincludeEntry = new XIncludeEntry(href, ((ResourceResolver.Result.Found)resourceResult).getPath());
                List<Content> xIncludeElements = this.resolveXIncludesOfRemoteDocument((Document)remoteDocument, xincludeElement, xincludeEntry, bases);
                Comment startComment = new Comment("Start " + presentableXInclude);
                Comment endComment = new Comment("End " + presentableXInclude);
                List list = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)startComment), (Iterable)xIncludeElements), (Iterable)CollectionsKt.listOf((Object)endComment));
                return list;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        if (resourceResult instanceof ResourceResolver.Result.NotFound) {
            Element fallbackElement = xincludeElement.getChild("fallback", xincludeElement.getNamespace());
            if (fallbackElement != null) {
                return CollectionsKt.emptyList();
            }
            throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "Not found document '" + href + "' referenced in " + presentableXInclude + ". <xi:fallback> element is not provided.");
        }
        if (resourceResult instanceof ResourceResolver.Result.Failed) {
            throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "Failed to load document referenced in " + presentableXInclude, ((ResourceResolver.Result.Failed)resourceResult).getException());
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Content> resolveXIncludesOfRemoteDocument(Document remoteDocument, Element xincludeElement, XIncludeEntry xincludeEntry, Stack<XIncludeEntry> bases) {
        List<Content> $i$f$count2;
        int n;
        String presentableXInclude = this.getElementNameAndAttributes(xincludeElement);
        this.checkCyclicReference(xincludeEntry, bases);
        if (!remoteDocument.hasRootElement()) {
            throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "Remote root element is not set for document referenced in " + presentableXInclude);
        }
        List list = remoteDocument.getContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"remoteDocument.content");
        Iterable $this$count$iv = list;
        boolean $i$f$count2 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Content it = (Content)element$iv;
                boolean bl = false;
                if (!(it instanceof Element)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n > 1) {
            throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "Multiple root elements in document referenced in " + presentableXInclude);
        }
        bases.push(xincludeEntry);
        try {
            Element element = remoteDocument.getRootElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"remoteDocument.rootElement");
            $i$f$count2 = this.resolveIncludeOrNonInclude(element, bases);
        }
        finally {
            bases.pop();
        }
        List<Content> remoteContents = $i$f$count2;
        if (remoteContents.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (remoteContents.size() > 1) {
            throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "Multiple elements referenced in " + presentableXInclude);
        }
        Object object = CollectionsKt.single(remoteContents);
        if (!(object instanceof Element)) {
            object = null;
        }
        Element element = (Element)object;
        if (element == null) {
            throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "Root element, not '" + ((Content)CollectionsKt.single(remoteContents)).getCType() + "', must have been resolved in " + presentableXInclude);
        }
        Element remoteRootElement = element;
        return this.selectContents(xincludeElement, xincludeEntry, remoteRootElement, bases);
    }

    private final void checkCyclicReference(XIncludeEntry xincludeEntry, Stack<XIncludeEntry> bases) {
        int index = bases.indexOf(xincludeEntry);
        if (index >= 0) {
            List cycle = CollectionsKt.plus((Collection)CollectionsKt.drop((Iterable)bases, (int)index), (Iterable)CollectionsKt.listOf((Object)xincludeEntry));
            List prefix = CollectionsKt.take((Iterable)bases, (int)(index + 1));
            throw (Throwable)new XIncluderException(prefix, "Circular includes: " + CollectionsKt.joinToString$default((Iterable)cycle, (CharSequence)" -> ", null, null, (int)0, null, (Function1)checkCyclicReference.1.INSTANCE, (int)30, null));
        }
    }

    private final Element resolveNonXIncludeElement(Element element, Stack<XIncludeEntry> bases) {
        Element result = new Element(element.getName(), element.getNamespace());
        if (element.hasAttributes()) {
            for (Attribute attribute : element.getAttributes()) {
                result.setAttribute(attribute.clone());
            }
        }
        if (element.hasAdditionalNamespaces()) {
            for (Namespace additionalNamespace : element.getAdditionalNamespaces()) {
                result.addNamespaceDeclaration(additionalNamespace);
            }
        }
        for (Content content : element.getContent()) {
            if (content instanceof Element) {
                result.addContent((Collection)this.resolveIncludeOrNonInclude((Element)content, bases));
                continue;
            }
            result.addContent(content.clone());
        }
        return result;
    }

    private final List<Content> selectContents(Element xincludeElement, XIncludeEntry xincludeEntry, Element remoteRootElement, Stack<XIncludeEntry> bases) {
        List list;
        String subTagName;
        String string = xincludeElement.getAttributeValue("xpointer");
        if (string == null) {
            return CollectionsKt.listOf((Object)remoteRootElement);
        }
        String xPointer = string;
        Matcher pointerMatcher = XIncluderKt.access$getXPOINTER_PATTERN$p().matcher(xPointer);
        if (!pointerMatcher.matches()) {
            throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "Invalid xpointer value in " + this.getElementNameAndAttributes(xincludeElement));
        }
        String pointerSelector = pointerMatcher.group(1);
        Matcher selectorMatcher = XIncluderKt.access$getXPOINTER_SELECTOR_PATTERN$p().matcher(pointerSelector);
        if (!selectorMatcher.matches()) {
            throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "Invalid xpointer selector value in " + this.getElementNameAndAttributes(xincludeElement));
        }
        String rootTagName = selectorMatcher.group(1);
        if (Intrinsics.areEqual((Object)remoteRootElement.getName(), (Object)rootTagName) ^ true) {
            return CollectionsKt.emptyList();
        }
        String string2 = selectorMatcher.group(2);
        String string3 = subTagName = string2 != null ? StringsKt.drop((String)string2, (int)1) : null;
        if (subTagName != null) {
            Element element = remoteRootElement.getChild(subTagName);
            if (element == null) {
                throw (Throwable)new XIncluderException((List<XIncludeEntry>)bases, "No elements are selected in document '" + xincludeEntry.getPresentablePath() + "' referenced in " + this.getElementNameAndAttributes(xincludeElement));
            }
            Element child = element;
            list = child.getContent();
        } else {
            list = remoteRootElement.getContent();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"if (subTagName != null) \u2026RootElement.content\n    }");
        List selectedChildren = CollectionsKt.toList((Iterable)list);
        Iterable $this$forEach$iv = selectedChildren;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Content it = (Content)element$iv;
            boolean bl = false;
            it.detach();
        }
        return selectedChildren;
    }

    private final String getElementNameAndAttributes(@NotNull Element $this$getElementNameAndAttributes) {
        StringBuilder stringBuilder = new StringBuilder().append('<').append($this$getElementNameAndAttributes.getQualifiedName()).append(' ');
        List list = $this$getElementNameAndAttributes.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"attributes");
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)getElementNameAndAttributes.1.INSTANCE, (int)31, null)).append("/>").toString();
    }

    private final boolean isIncludeElement(Element element) {
        return Intrinsics.areEqual((Object)element.getName(), (Object)"include") && Intrinsics.areEqual((Object)element.getNamespace(), (Object)XIncluderKt.access$getHTTP_XINCLUDE_NAMESPACE$p());
    }

    private XIncluder(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public /* synthetic */ XIncluder(ResourceResolver resourceResolver, DefaultConstructorMarker $constructor_marker) {
        this(resourceResolver);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/plugin/structure/intellij/xinclude/XIncluder$Companion;", "", "()V", "resolveXIncludes", "Lorg/jdom2/Document;", "document", "presentablePath", "", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "documentPath", "Ljava/nio/file/Path;", "structure-intellij"})
    public static final class Companion {
        @NotNull
        public final Document resolveXIncludes(@NotNull Document document, @NotNull String presentablePath, @NotNull ResourceResolver resourceResolver, @NotNull Path documentPath) throws XIncluderException {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)presentablePath, (String)"presentablePath");
            Intrinsics.checkParameterIsNotNull((Object)resourceResolver, (String)"resourceResolver");
            Intrinsics.checkParameterIsNotNull((Object)documentPath, (String)"documentPath");
            return new XIncluder(resourceResolver, null).resolveXIncludes(document, presentablePath, documentPath);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

