/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.action;

import com.alibabacloud.intellij.qoder.chat.action.BaseCosySelectGenerationAction;
import com.alibabacloud.intellij.qoder.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.qoder.chat.enums.TaskDefinitionTypeEnum;
import com.alibabacloud.intellij.qoder.chat.model.ChatAskInput;
import com.alibabacloud.intellij.qoder.chat.model.ChatContext;
import com.alibabacloud.intellij.qoder.constants.InputConstants;
import com.alibabacloud.intellij.qoder.core.lsp.model.CustomCommandRequiredContextProvider;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.CustomCommandCheckContextItemsParams;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.qoder.ui.search.model.inputextra.ChatTaskExtra;
import com.alibabacloud.intellij.qoder.ui.search.model.inputextra.ExtraCommand;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class CosyCustomCommandAction
extends BaseCosySelectGenerationAction {
    private static final String CHECK_CONTEXT_ITEM_KEY_USER_INPUT = "userInput";
    private static final String CHECK_CONTEXT_ITEM_KEY_SELECT_CODE = "selectedCode";
    private static final String CHECK_CONTEXT_ITEM_KEY_FILE = "file";
    private static final String EXTRA_KEY_COMMAND = "command";
    private static final String EXTRA_COMMAND_KEY_ID = "identifier";

    @Override
    protected ChatTaskEnum getChatTaskEnum() {
        return null;
    }

    @Override
    protected boolean needCheckCode() {
        return false;
    }

    @Override
    protected Boolean checkCommandContext(Project project, ChatContext chatContext, ChatAskInput chatAskInput, String chatTask) {
        CustomCommandCheckContextItemsParams params = new CustomCommandCheckContextItemsParams();
        List taskTags = chatAskInput.getTags().stream().filter(tag -> tag.getType().equals("task")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(taskTags)) {
            return true;
        }
        SuggestPrompt targetCommand = this.getCustomCommand(chatTask);
        if (targetCommand == null) {
            return true;
        }
        List<CustomCommandRequiredContextProvider> requiredContextItems = targetCommand.getRequiredContextProviders();
        if (CollectionUtils.isEmpty(requiredContextItems)) {
            return true;
        }
        requiredContextItems = requiredContextItems.stream().filter(contextProvider -> BooleanUtils.isTrue((Boolean)contextProvider.getRequired())).collect(Collectors.toList());
        List<ChatContextTag> contextTags = chatAskInput.getContextTags();
        List<Object> userInputElements = new ArrayList();
        if (CollectionUtils.isNotEmpty(chatAskInput.getChatInputElements())) {
            userInputElements = chatAskInput.getChatInputElements().stream().filter(chatInputElement -> {
                if ("text".equals(chatInputElement.getType())) {
                    return true;
                }
                if (chatInputElement.getTag() != null) {
                    String tagType = chatInputElement.getTag().getType();
                    return "context".equals(tagType);
                }
                return true;
            }).collect(Collectors.toList());
        }
        ArrayList<String> contextTagTextList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(contextTags)) {
            for (ChatContextTag contextTag : contextTags) {
                if (contextTag.getContextProvider() != null && contextTag.getContextProvider().getText() != null) {
                    contextTagTextList.add(contextTag.getContextProvider().getText().substring(1));
                    continue;
                }
                if (contextTag.getText() == null) continue;
                contextTagTextList.add(contextTag.getText().substring(1));
            }
        }
        for (CustomCommandRequiredContextProvider requiredContextItem : requiredContextItems) {
            if (contextTagTextList.contains(requiredContextItem.getName())) continue;
            if (CHECK_CONTEXT_ITEM_KEY_SELECT_CODE.equals(requiredContextItem.getName())) {
                NotificationFactory.showInfoNotification(project, I18NConstant.CHAT_NOTIFY_SELECT_CODE);
                return false;
            }
            if (CHECK_CONTEXT_ITEM_KEY_USER_INPUT.equals(requiredContextItem.getName())) {
                if (!CollectionUtils.isEmpty(userInputElements)) continue;
                NotificationFactory.showInfoNotification(project, CosyBundle.message("chat.warn.user.input.empty", new Object[0]));
                return false;
            }
            if (CHECK_CONTEXT_ITEM_KEY_FILE.equals(requiredContextItem.getName())) {
                NotificationFactory.showInfoNotification(project, CosyBundle.message("chat.warn.context.required.file", new Object[0]));
                return false;
            }
            String message = String.format(CosyBundle.message("chat.warn.context.required", new Object[0]), requiredContextItem.getName());
            NotificationFactory.showInfoNotification(project, message);
            return false;
        }
        return true;
    }

    private String getSelectedCode(Project project) {
        Editor editor = EditorUtil.getSelectedEditorSafely(project);
        String code = null;
        if (editor != null && editor.getSelectionModel().getSelectedText() != null) {
            SelectionModel selectionModel = editor.getSelectionModel();
            code = selectionModel.getSelectedText();
        }
        return code;
    }

    @Override
    protected String getQuestion(ChatAskInput chatAskInput) {
        List taskTags = chatAskInput.getTags().stream().filter(tag -> tag.getType().equals("task")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(taskTags)) {
            return null;
        }
        return ((ChatAskTag)taskTags.get(0)).getText();
    }

    @Override
    protected String getChatTask(ChatAskInput chatAskInput) {
        List taskTags = chatAskInput.getTags().stream().filter(tag -> tag.getType().equals("task")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(taskTags)) {
            return null;
        }
        return ((ChatAskTag)taskTags.get(0)).getId();
    }

    @Override
    protected String getTaskDefinitionType() {
        return TaskDefinitionTypeEnum.CUSTOM_COMMAND.getType();
    }

    @Override
    protected ChatTaskExtra getExtra(ChatAskInput chatAskInput) {
        ChatTaskExtra chatTaskExtra = new ChatTaskExtra();
        List taskTags = chatAskInput.getTags().stream().filter(tag -> tag.getType().equals("task")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(taskTags)) {
            return chatTaskExtra;
        }
        ChatAskTag chatAskTag = (ChatAskTag)taskTags.get(0);
        String text = StringUtils.isEmpty((CharSequence)chatAskTag.getText()) ? "" : chatAskTag.getText().replace("/", "");
        ExtraCommand command = new ExtraCommand(chatAskTag.getId(), text, text);
        chatTaskExtra.setCommand(command);
        return chatTaskExtra;
    }

    @Override
    protected Boolean needClearContext(String chatTask) {
        SuggestPrompt targetCommand = this.getCustomCommand(chatTask);
        if (targetCommand == null) {
            return true;
        }
        return targetCommand.getNeedClearContext();
    }

    private SuggestPrompt getCustomCommand(String chatTask) {
        Collection<SuggestPrompt> suggestPrompts = InputConstants.CUSTOM_SUGGEST_PROMPT_MAP.values();
        if (CollectionUtils.isEmpty(suggestPrompts)) {
            return null;
        }
        List targetCommand = suggestPrompts.stream().filter(item -> item.getId() != null && item.getId().equals(chatTask)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(targetCommand)) {
            return null;
        }
        return (SuggestPrompt)targetCommand.get(0);
    }
}

