/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.context;

import com.alibabacloud.intellij.qoder.chat.context.AgentProvider;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.constants.InputConstants;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.qoder.util.SuggestPromptUtil;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public abstract class BaseAgentProvider
implements AgentProvider {
    private static final Collection<String> COMMON_FILTERS = Set.of(ChatContextTypeEnum.DOM_ELEMENT.getType());

    protected List<SuggestPrompt> doListAllPromptsExceptScope(Project project, String query, boolean historyEmpty, SessionTypeEnum sessionTypeEnum) {
        List<SuggestPrompt> allPrompts = new ArrayList<SuggestPrompt>();
        String customCommandPosition = InputConstants.CUSTOM_SUGGEST_POSITION.get("RELATIVE_TO_SYSTEM");
        if ("top".equals(customCommandPosition)) {
            allPrompts.addAll(InputConstants.CUSTOM_SUGGEST_PROMPT_MAP.values());
        }
        if (!CosyConfig.isQoderEnabled()) {
            allPrompts.addAll(InputConstants.WELCOMING_SUGGEST_PROMPT_MAP.values());
        }
        if ("bottom".equals(customCommandPosition)) {
            allPrompts.addAll(InputConstants.CUSTOM_SUGGEST_PROMPT_MAP.values());
        }
        allPrompts.addAll(SuggestPromptUtil.getAgentSuggestPrompt(project, sessionTypeEnum.getType()).values());
        allPrompts.addAll(this.getSuggestPromptForHistory(historyEmpty));
        if (query != null && !query.isEmpty()) {
            allPrompts = allPrompts.stream().filter(suggestPrompt -> suggestPrompt.getText() != null && suggestPrompt.getText().contains(query)).collect(Collectors.toList());
        }
        return allPrompts;
    }

    protected Collection<SuggestPrompt> getSuggestPromptForHistory(boolean historyEmpty) {
        return historyEmpty ? InputConstants.WELCOMING_HELP_MAP.values() : InputConstants.CONTEXT_SUGGEST_PROMPT_MAP.values();
    }

    protected List<SuggestPrompt> doListScopePrompts(Project project, String query, Collection<String> filters) {
        List<SuggestPrompt> allSuggestPrompt = SuggestPromptUtil.getScopeSuggestPrompt(project).values().stream().filter(e -> !COMMON_FILTERS.contains(e.getContextName())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filters)) {
            allSuggestPrompt = allSuggestPrompt.stream().filter(suggestPrompt -> !filters.contains(suggestPrompt.getContextName())).collect(Collectors.toList());
        }
        if (query != null && !query.isEmpty()) {
            allSuggestPrompt = allSuggestPrompt.stream().filter(suggestPrompt -> suggestPrompt.getText() != null && suggestPrompt.getText().toLowerCase().contains(query)).collect(Collectors.toList());
        }
        return allSuggestPrompt;
    }
}

