/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.context;

import com.alibabacloud.intellij.qoder.chat.context.ChatContextRefProvider;
import com.alibabacloud.intellij.qoder.constants.InputConstants;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ComponentTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class FoldersChatContextRefProvider
implements ChatContextRefProvider {
    private static final Logger log = Logger.getInstance(FoldersChatContextRefProvider.class);
    private Queue<VirtualFile> queue = new LinkedList<VirtualFile>();

    @Override
    public void setup(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        tagComponent.setIcon(PlatformIcons.FOLDER_ICON);
    }

    @Override
    public void click(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
    }

    @Override
    public List<SuggestPrompt> listSuggestPrompts(Project project, String query) {
        this.queue = new LinkedList<VirtualFile>();
        return this.traverseDirectories(project, query).stream().map(FoldersChatContextRefProvider::getSuggestPrompt).collect(Collectors.toList());
    }

    @Override
    public Icon getIconOfSuggestPrompt(Project project, SuggestPrompt suggestPrompt) {
        return PlatformIcons.FOLDER_ICON;
    }

    @Override
    public void clickFromMarkdownPanel(Project project, ChatContextTag tag, JComponent component) {
    }

    public List<VirtualFile> traverseDirectories(Project project, String keyword) {
        VirtualFile baseDir = ProjectUtil.guessProjectDir((Project)project);
        if (baseDir != null) {
            return this.traverseVirtualDirectories(baseDir, keyword);
        }
        log.warn("Project base directory is null. Path: " + project.getBasePath());
        return Collections.emptyList();
    }

    private List<VirtualFile> traverseVirtualDirectories(VirtualFile rootDir, String keyword) {
        ArrayList<VirtualFile> folders = new ArrayList<VirtualFile>(30);
        if (null != rootDir) {
            this.queue.offer(rootDir);
        }
        int counter = 0;
        while (!this.queue.isEmpty() && (long)counter < 30L) {
            VirtualFile currentDir = this.queue.poll();
            if (null == currentDir || !currentDir.isDirectory() || FileElement.isFileHidden((VirtualFile)currentDir)) continue;
            if (!currentDir.equals(rootDir) && (StringUtils.isEmpty((CharSequence)keyword) || currentDir.getName().contains(keyword))) {
                folders.add(currentDir);
                ++counter;
            }
            for (VirtualFile child : currentDir.getChildren()) {
                if (!child.isDirectory() || FileElement.isFileHidden((VirtualFile)child)) continue;
                this.queue.offer(child);
            }
        }
        return folders;
    }

    @NotNull
    public static SuggestPrompt getSuggestPrompt(VirtualFile file) {
        SuggestPrompt suggestPrompt = new SuggestPrompt(file.getPath(), file.getName(), file.getPresentableUrl(), ChatContextTypeEnum.FOLDER.getType(), null, "context", false);
        suggestPrompt.setComponentType(ComponentTypeEnum.COMBOBOX.getType());
        suggestPrompt.setContextProvider(InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.FOLDER.getType()));
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("contextType", ChatContextTypeEnum.FOLDER.getType());
        suggestPrompt.setExtra(extra);
        SuggestPrompt suggestPrompt2 = suggestPrompt;
        if (suggestPrompt2 == null) {
            FoldersChatContextRefProvider.$$$reportNull$$$0(0);
        }
        return suggestPrompt2;
    }

    @Override
    public List<SuggestPrompt> getRollingUpdateSuggestPrompts(Project project, String query) {
        return this.traverseVirtualDirectories(null, query).stream().map(FoldersChatContextRefProvider::getSuggestPrompt).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/qoder/chat/context/FoldersChatContextRefProvider", "getSuggestPrompt"));
    }
}

