/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.context;

import com.alibabacloud.intellij.qoder.chat.context.ChatContextRefProvider;
import com.alibabacloud.intellij.qoder.constants.InputConstants;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ComboBoxItem;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetComboBoxItemParams;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ComponentTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GitCommitContextRefProvider
implements ChatContextRefProvider {
    private static final Logger LOG = Logger.getInstance(GitCommitContextRefProvider.class);
    private long page = 1L;

    @Override
    public void setup(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        tagComponent.setIcon(QoderIcons.CommitIcon);
    }

    @Override
    public void click(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
    }

    @Override
    public List<SuggestPrompt> listSuggestPrompts(Project project, String query) {
        this.page = 1L;
        return this.doListSuggestPrompts(project, query);
    }

    @NotNull
    private List<SuggestPrompt> doListSuggestPrompts(Project project, String query) {
        SuggestPrompt contextProvider = InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.GIT_COMMIT.getType());
        List<SuggestPrompt> list = this.getComboBoxItems(project, query, contextProvider).stream().map(comboBoxItem -> this.getSuggestPrompt((ComboBoxItem)comboBoxItem, contextProvider)).collect(Collectors.toList());
        if (list == null) {
            GitCommitContextRefProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    private List<ComboBoxItem> getComboBoxItems(Project project, String query, SuggestPrompt contextProvider) {
        if (contextProvider == null) {
            return Collections.emptyList();
        }
        GetComboBoxItemParams comboBoxItemParams = new GetComboBoxItemParams();
        comboBoxItemParams.setIdentifier(contextProvider.getId());
        comboBoxItemParams.setRequestId(UUID.randomUUID().toString());
        comboBoxItemParams.setQuery(query);
        comboBoxItemParams.setPage(this.page++);
        comboBoxItemParams.setPageSize(30L);
        return Cosy.INSTANCE.getLanguageService(project).loadComboBoxItems(comboBoxItemParams, 10000);
    }

    private SuggestPrompt getSuggestPrompt(ComboBoxItem comboBoxItem, SuggestPrompt gitCommitContextProvider) {
        SuggestPrompt suggestPrompt = new SuggestPrompt(comboBoxItem.getIdentifier(), comboBoxItem.getName(), comboBoxItem.getDisplayName(), ChatContextTypeEnum.GIT_COMMIT.getType(), null, "context", false);
        suggestPrompt.setType("context");
        suggestPrompt.setComponentType(ComponentTypeEnum.COMBOBOX.getType());
        suggestPrompt.setContextProvider(gitCommitContextProvider);
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("contextType", ChatContextTypeEnum.GIT_COMMIT.getType());
        suggestPrompt.setExtra(extra);
        return suggestPrompt;
    }

    @Override
    public Icon getIconOfSuggestPrompt(Project project, SuggestPrompt suggestPrompt) {
        return QoderIcons.CommitIcon;
    }

    @Override
    public void clickFromMarkdownPanel(Project project, ChatContextTag tag, JComponent component) {
    }

    @Override
    public List<SuggestPrompt> getRollingUpdateSuggestPrompts(Project project, String query) {
        return this.doListSuggestPrompts(project, query);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/qoder/chat/context/GitCommitContextRefProvider", "doListSuggestPrompts"));
    }
}

