/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.context;

import com.alibabacloud.intellij.qoder.chat.context.FileChatContextRefProvider;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.UploadImageCallBackResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.UploadImageParams;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.ImageUploadUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.internal.StringUtil;

public class ImageChatContextRefProvider
extends FileChatContextRefProvider {
    private static final Logger log = Logger.getInstance(ImageChatContextRefProvider.class);

    @Override
    public void setup(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        super.setup(project, tag, tagComponent);
        tagComponent.setLoading(true);
        tag.getLoading().getAndSet(true);
        CompletableFuture.runAsync(() -> this.updateImage(project, tag, tagComponent));
        log.debug("image setup finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateImage(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        String requestId = UUID.randomUUID().toString();
        try {
            ImageUploadUtil.init(requestId);
            boolean uploadSuccess = this.doUploadImage(project, tag, tagComponent, requestId);
            if (!uploadSuccess) {
                this.updateTagAndImageUI(tag, null, tagComponent, false, QoderIcons.ImageFailRedIcon);
            } else {
                this.checkAndUpdateImageUploadResult(project, tag, tagComponent, requestId);
            }
        }
        catch (Exception e) {
            log.warn("uploadImage error", (Throwable)e);
            this.updateTagAndImageUI(tag, null, tagComponent, false, QoderIcons.ImageFailRedIcon);
        }
        finally {
            ImageUploadUtil.destroy(requestId);
        }
    }

    boolean doUploadImage(Project project, ChatContextTag tag, ChatContextTagButton tagComponent, String requestId) {
        if (null == tag.getPayload()) {
            log.warn("tag payload is null");
            return false;
        }
        if (!(tag.getPayload() instanceof String)) {
            log.warn("tag payload is not string");
            return false;
        }
        String imageUrl = (String)tag.getPayload();
        if (StringUtil.isBlank((String)imageUrl)) {
            log.warn("uploadImage imageUrl is blank");
            return false;
        }
        UploadImageParams params = new UploadImageParams();
        params.setImageUri(imageUrl);
        params.setRequestId(requestId);
        if (Cosy.INSTANCE.getLanguageService(project) != null) {
            return Cosy.INSTANCE.getLanguageService(project).uploadImage(params);
        }
        return false;
    }

    void checkAndUpdateImageUploadResult(Project project, ChatContextTag tag, ChatContextTagButton tagComponent, String requestId) throws Exception {
        UploadImageCallBackResult uploadResult;
        long maxTime = TimeUnit.SECONDS.toMillis(10L);
        long startTime = System.currentTimeMillis();
        while (!ImageUploadUtil.waitImageUpload(requestId, 1L, TimeUnit.SECONDS)) {
            if (System.currentTimeMillis() - startTime <= maxTime) continue;
            log.warn("getImageUploadResult timeout");
            break;
        }
        if (!UploadImageCallBackResult.checkSuccess(uploadResult = ImageUploadUtil.getImageUploadResult(requestId)).booleanValue()) {
            this.updateTagAndImageUI(tag, null, tagComponent, false, QoderIcons.ImageFailRedIcon);
            return;
        }
        String imageUrl = UploadImageCallBackResult.getImageUrl(uploadResult);
        log.debug("getImageUploadResult imageUrl" + imageUrl);
        if (StringUtils.isNotBlank((CharSequence)imageUrl)) {
            this.updateTagAndImageUI(tag, imageUrl, tagComponent, true, QoderIcons.ImageGreyIcon);
        } else {
            this.updateTagAndImageUI(tag, null, tagComponent, false, QoderIcons.ImageFailRedIcon);
        }
    }

    void updateTagAndImageUI(ChatContextTag tag, String imageUrl, ChatContextTagButton tagComponent, boolean validate, Icon icon) {
        if (StringUtils.isNotBlank((CharSequence)imageUrl)) {
            tag.getExtra().put("imgUrl", imageUrl);
        }
        tag.getLoading().getAndSet(false);
        SwingUtilities.invokeLater(() -> {
            tagComponent.setLoading(false);
            if (icon != null) {
                tagComponent.setIcon(icon);
            }
            if (!validate) {
                tagComponent.setValid(false);
            }
        });
    }

    @Override
    public void click(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        String fileUrl;
        File file;
        String filePath = tag.getLocalFilePath();
        if ((StringUtils.isBlank((CharSequence)filePath) || !new File(filePath).exists()) && StringUtils.isNotBlank((CharSequence)tag.getRemoteFileUrl()) && !(file = new File(filePath = FileUtil.getTempPath(fileUrl = tag.getRemoteFileUrl().substring("image://".length()), filePath))).exists()) {
            FileUtil.downloadFile(fileUrl, filePath);
        }
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            EditorUtil.openEditorFile(project, filePath, null, tagComponent);
        }
    }
}

