/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.context;

import com.alibabacloud.intellij.qoder.chat.context.BaseAgentProvider;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.qoder.util.SuggestPromptUtil;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class InlineChatProvider
extends BaseAgentProvider {
    private static final Set<String> FILTERS = Set.of(ChatContextTypeEnum.CODE_CHANGES.getType(), ChatContextTypeEnum.GIT_COMMIT.getType(), ChatContextTypeEnum.CODEBASE.getType(), ChatContextTypeEnum.FOLDER.getType(), ChatContextTypeEnum.SELECTED_CODE.getType(), ChatContextTypeEnum.TEAM_DOCS.getType(), ChatContextTypeEnum.IMAGE.getType(), ChatContextTypeEnum.TERMINAL.getType(), ChatContextTypeEnum.ATTACHMENT.getType());

    @Override
    public List<SuggestPrompt> listAllPromptsExceptScope(Project project, String query, boolean historyEmpty) {
        return this.doListAllPromptsExceptScope(project, query, historyEmpty, SessionTypeEnum.INLINE);
    }

    @Override
    public List<SuggestPrompt> listScopePrompts(Project project, String query) {
        return this.doListScopePrompts(project, query, FILTERS);
    }

    @Override
    public List<SuggestPrompt> listAgentPrompts(Project project, String query) {
        return List.of();
    }

    @Override
    protected List<SuggestPrompt> doListAllPromptsExceptScope(Project project, String query, boolean historyEmpty, SessionTypeEnum sessionTypeEnum) {
        List<SuggestPrompt> allPrompts = new ArrayList<SuggestPrompt>(SuggestPromptUtil.getAgentSuggestPrompt(project, sessionTypeEnum.getType()).values());
        if (query != null && !query.isEmpty()) {
            allPrompts = allPrompts.stream().filter(suggestPrompt -> suggestPrompt.getText() != null && suggestPrompt.getText().contains(query)).collect(Collectors.toList());
        }
        return allPrompts;
    }
}

