/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.context.aidev;

import com.alibabacloud.intellij.qoder.chat.context.aidev.BaseAIDevFileContextProvider;
import com.alibabacloud.intellij.qoder.chat.enums.aidev.AIDevFileStatusEnum;
import com.alibabacloud.intellij.qoder.chat.enums.aidev.AIDevFileUsageEnum;
import com.alibabacloud.intellij.qoder.ui.chat.AIDevFilePanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.SnapshotStatusEnum;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import java.awt.Color;
import javax.swing.JPanel;

public class DeletedFileContextProvider
extends BaseAIDevFileContextProvider {
    @Override
    public AIDevFileStatusEnum getStatus() {
        return AIDevFileStatusEnum.DELETED;
    }

    @Override
    public void handleFileClicking(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
    }

    @Override
    public void handleDefaultStatus(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        AIDevFilePanel.FileItem item = itemPanel.getFileItem();
        if (AIDevFileUsageEnum.CHAT_CARD == itemPanel.getUsage() || AIDevFileUsageEnum.TOOL_PANEL == itemPanel.getUsage()) {
            super.handleDefaultStatus(listPanel, itemPanel);
        } else {
            itemPanel.getRightPanel().removeAll();
            itemPanel.setBackground(this.getBackgroundColor(listPanel, itemPanel));
            itemPanel.getFileChangedTypeLabel().setText(item.getChangedType().getName());
            itemPanel.getFileChangedTypeLabel().setForeground(item.getChangedType().getColor());
            itemPanel.getFileChangedTypeLabel().setVisible(true);
            itemPanel.getRightPanel().add(itemPanel.getFileChangedTypeLabel());
            itemPanel.getRightPanel().setBackground(ColorUtil.getEditorBackgroundColor());
            itemPanel.getRightPanel().setVisible(AIDevFileUsageEnum.WORKING_SPACE != itemPanel.getUsage() || item.getSnapshot() == null || !SnapshotStatusEnum.OUTDATED.getId().equals(item.getSnapshot().getStatus()));
        }
        this.processFileNameLabel(itemPanel);
    }

    @Override
    public void handleFileHovering(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        SwingUtil.foreachChildComponent(itemPanel, cp -> {
            cp.setBackground(AIDevFileUsageEnum.TOOL_PANEL == itemPanel.getUsage() ? ColorUtil.getEditorBackgroundColor() : this.getBackgroundColorForSelection(listPanel, itemPanel));
            cp.setForeground(ColorUtil.getTextForegroundColor());
        });
        AIDevFilePanel.FileItem item = itemPanel.getFileItem();
        if (AIDevFileUsageEnum.WORKING_SPACE == itemPanel.getUsage() && null != item.getSnapshot() && item.getSnapshot().isCurrent()) {
            itemPanel.getRightPanel().removeAll();
            this.addOperationLabel(itemPanel);
        }
    }

    @Override
    public Color getBackgroundColorForSelection(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        return AIDevFileUsageEnum.CHAT_CARD == itemPanel.getUsage() || AIDevFileUsageEnum.TOOL_PANEL == itemPanel.getUsage() ? super.getBackgroundColorForSelection(listPanel, itemPanel) : ColorUtil.getToolWindowBackgroundColor();
    }
}

