/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.context.tool;

import com.alibabacloud.intellij.qoder.chat.context.tool.BaseToolContextProvider;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ToolAutoRunModeItem;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.approval.ToolApprovalPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.approval.WebToolApprovalPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolCountStyleEnum;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.scale.JBUIScale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang.StringUtils;

public class FetchContentToolContextProvider
extends BaseToolContextProvider {
    @Override
    public String getToolNameAndStatus(ToolCallStatusEnum status, String toolName) {
        switch (status) {
            case INIT: 
            case PENDING: {
                return CosyBundle.message("tool.fetch.content", new Object[0]);
            }
            case RUNNING: {
                return CosyBundle.message("tool.fetching.content", new Object[0]);
            }
            case FINISHED: {
                return CosyBundle.message("tool.fetched.content", new Object[0]);
            }
            case CANCELLED: {
                return CosyBundle.message("tool.fetch.content.canceled", new Object[0]);
            }
            case ERROR: {
                return CosyBundle.message("tool.fetch.content.failed", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public String getParamValue(ToolCallInfo toolCallInfo, String paramName) {
        if (toolCallInfo == null || StringUtils.isBlank((String)paramName)) {
            return null;
        }
        if (toolCallInfo.getParameters() == null) {
            return null;
        }
        Map<String, Object> params = toolCallInfo.getParameters();
        if (!params.containsKey(paramName)) {
            return null;
        }
        return (String)params.get(paramName);
    }

    @Override
    public JComponent getScopeLabel(Project project, ToolCallInfo toolCallInfo, int maxWidth) {
        if (toolCallInfo.getParameters() == null || !toolCallInfo.getParameters().containsKey("url")) {
            return null;
        }
        String url = (String)toolCallInfo.getParameters().get("url");
        if (StringUtils.isNotBlank((String)url)) {
            JLabel urlLabel = new JLabel();
            urlLabel.setText(FontUtil.getStringAdaptiveWidth(urlLabel, url, maxWidth, true));
            urlLabel.setFont(urlLabel.getFont().deriveFont(JBUIScale.scale((float)12.0f)));
            urlLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            return urlLabel;
        }
        return null;
    }

    @Override
    public String getScopeContent(Project project, ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getParameters() == null || !toolCallInfo.getParameters().containsKey("url")) {
            return null;
        }
        return (String)toolCallInfo.getParameters().get("url");
    }

    @Override
    public ToolCountStyleEnum needRenderResultCount() {
        return ToolCountStyleEnum.NONE;
    }

    @Override
    public ToolApprovalPanel initToolApprovalPanel(Project project, ToolPanel toolPanel) {
        this.addToolAutoRunChooser(project, toolPanel, item -> this.updateWebToolsAutoRun(project, (ToolAutoRunModeItem)item));
        return new WebToolApprovalPanel(project, toolPanel);
    }

    @Override
    public ToolDetailPanel initToolDetailPanel(Project project, ToolPanel toolPanel) {
        return null;
    }
}

