/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.context.tool;

import com.alibabacloud.intellij.qoder.chat.context.tool.BaseToolContextProvider;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.GlobalMcpAutoRunConfig;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ToolAutoRunModeItem;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.search.enums.McpAutoRunEnum;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.chooser.ToolAutoRunChooser;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.approval.MCPToolApprovalPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.approval.ToolApprovalPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.MCPToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolCountStyleEnum;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.scale.JBUIScale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang.StringUtils;

public class MCPToolContextProvider
extends BaseToolContextProvider {
    @Override
    public String getToolNameAndStatus(ToolCallStatusEnum status, String toolName) {
        switch (status) {
            case INIT: 
            case PENDING: {
                return CosyBundle.message("tool.mcp.execute", new Object[0]);
            }
            case RUNNING: {
                return CosyBundle.message("tool.mcp.executing", new Object[0]);
            }
            case FINISHED: {
                return CosyBundle.message("tool.mcp.executed", new Object[0]);
            }
            case CANCELLED: {
                return CosyBundle.message("tool.mcp.execute.canceled", new Object[0]);
            }
            case ERROR: {
                return CosyBundle.message("tool.mcp.execute.failed", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public Icon getIcon(ToolCallStatusEnum status) {
        switch (status) {
            case INIT: 
            case PENDING: {
                return QoderIcons.PendingGreyIcon;
            }
            case RUNNING: {
                return QoderIcons.StatusBarLoadingIcon;
            }
            case CANCELLED: {
                return QoderIcons.ErrorRed16Icon;
            }
            case FINISHED: {
                return QoderIcons.AcceptGreen16Icon;
            }
            case ERROR: {
                return QoderIcons.Warning16YellowIcon;
            }
        }
        return null;
    }

    @Override
    public JComponent getScopeLabel(Project project, ToolCallInfo toolCallInfo, int maxWidth) {
        if (StringUtils.isBlank((String)toolCallInfo.getToolName())) {
            return null;
        }
        String[] serverAndToolNameArr = toolCallInfo.getToolName().split("#");
        if (serverAndToolNameArr.length < 3) {
            return null;
        }
        String displayName = serverAndToolNameArr[1] + "/" + serverAndToolNameArr[2];
        JLabel fileLabel = new JLabel();
        fileLabel.setText(FontUtil.getStringAdaptiveWidth(fileLabel, displayName, maxWidth, false));
        fileLabel.setFont(fileLabel.getFont().deriveFont(JBUIScale.scale((float)12.0f)));
        fileLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        return fileLabel;
    }

    @Override
    public String getScopeContent(Project project, ToolCallInfo toolCallInfo) {
        if (StringUtils.isBlank((String)toolCallInfo.getToolName())) {
            return null;
        }
        String[] serverAndToolNameArr = toolCallInfo.getToolName().split("#");
        if (serverAndToolNameArr.length < 3) {
            return null;
        }
        return serverAndToolNameArr[1] + "/" + serverAndToolNameArr[2];
    }

    @Override
    public ToolCountStyleEnum needRenderResultCount() {
        return ToolCountStyleEnum.DOWN_ARROW;
    }

    @Override
    public ToolApprovalPanel initToolApprovalPanel(Project project, ToolPanel toolPanel) {
        this.addToolAutoRunChooser(project, toolPanel, item -> this.setMcpToolAutoRun(project, (ToolAutoRunModeItem)item));
        return new MCPToolApprovalPanel(project, toolPanel);
    }

    @Override
    public ToolDetailPanel initToolDetailPanel(Project project, ToolPanel toolPanel) {
        return new MCPToolDetailPanel(project, toolPanel);
    }

    private boolean setMcpToolAutoRun(Project project, ToolAutoRunModeItem item) {
        if (Cosy.INSTANCE.checkCosy(project)) {
            GlobalMcpAutoRunConfig config = new GlobalMcpAutoRunConfig();
            config.setMcpAutoRun(ToolAutoRunChooser.ITEM_ENABLE_AUTO_RUN == item ? McpAutoRunEnum.ENABLE.getType() : McpAutoRunEnum.DISABLE.getType());
            Cosy.INSTANCE.getLanguageService(project).updateGlobalMcpAutoRun(config, 2000L);
            return true;
        }
        return false;
    }
}

