/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.context.tool;

import com.alibabacloud.intellij.qoder.chat.context.tool.BaseToolContextProvider;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.GlobalConfig;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ToolAutoRunEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ToolAutoRunModeItem;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.chooser.ToolAutoRunChooser;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.approval.TerminalToolApprovalPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.approval.ToolApprovalPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.RunInTerminalToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolCountStyleEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.TerminalAutoRunDialog;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.Point;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class RunInTerminalToolContextProvider
extends BaseToolContextProvider {
    private static final Logger log = Logger.getInstance(RunInTerminalToolContextProvider.class);
    private boolean hasRisk = false;

    @Override
    public String getToolNameAndStatus(ToolCallStatusEnum status, String toolName) {
        switch (status) {
            case INIT: 
            case PENDING: {
                return CosyBundle.message("tool.run.terminal", new Object[0]);
            }
            case RUNNING: {
                return CosyBundle.message("tool.running.terminal", new Object[0]);
            }
            case CANCELLED: {
                return CosyBundle.message("tool.run.terminal.canceled", new Object[0]);
            }
            case FINISHED: {
                return CosyBundle.message("tool.finish.run.terminal", new Object[0]);
            }
            case ERROR: {
                return CosyBundle.message("tool.run.terminal.failed", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public Icon getIcon(ToolCallStatusEnum status) {
        switch (status) {
            case INIT: 
            case PENDING: 
            case FINISHED: {
                return QoderIcons.TerminalIcon;
            }
            case RUNNING: {
                return QoderIcons.StatusBarLoadingIcon;
            }
            case CANCELLED: {
                return QoderIcons.ErrorRed16Icon;
            }
            case ERROR: {
                return QoderIcons.Warning16YellowIcon;
            }
        }
        return null;
    }

    @Override
    public ToolCountStyleEnum needRenderResultCount() {
        return ToolCountStyleEnum.NONE;
    }

    @Override
    public ToolApprovalPanel initToolApprovalPanel(Project project, ToolPanel toolPanel) {
        ToolCallInfo info = toolPanel.getToolCallInfo().get();
        if (null != info) {
            Object runMode = info.getParameters().get("run_mode");
            if (null == runMode) {
                log.warn("run_mode is null");
                this.addToolAutoRunChooser(project, toolPanel, this.getSelectChecker(project, toolPanel));
            } else if (ToolAutoRunEnum.ASK_EVERYTIME.getId().equals(runMode)) {
                this.addToolAutoRunChooser(project, toolPanel, this.getSelectChecker(project, toolPanel));
            } else {
                if (Boolean.TRUE.equals(info.getParameters().get("has_risk")) || Boolean.TRUE.equals(info.getParameters().get("potential_risk"))) {
                    this.hasRisk = true;
                    this.addToolRunTips(toolPanel, CosyBundle.message("tool.terminal.has.risk", new Object[0]));
                } else {
                    this.hasRisk = false;
                    this.addToolRunTips(toolPanel, CosyBundle.message("tool.terminal.command.on.deny.list", new Object[0]));
                }
                toolPanel.setHasRiskOrInDenyList(true);
            }
        }
        return new TerminalToolApprovalPanel(project, toolPanel);
    }

    @NotNull
    private Function<ToolAutoRunModeItem, Boolean> getSelectChecker(final Project project, ToolPanel toolPanel) {
        Function<ToolAutoRunModeItem, Boolean> function = item -> {
            if (item.getMode() == ToolAutoRunEnum.ASK_EVERYTIME) {
                this.updateGlobalTerminalRunMode(project, (ToolAutoRunModeItem)item);
                return true;
            }
            new TerminalAutoRunDialog(project, new Point(toolPanel.getLocationOnScreen().x, toolPanel.getLocationOnScreen().y - toolPanel.getHeight() - 10), (ToolAutoRunModeItem)item, toolPanel){
                final /* synthetic */ ToolAutoRunModeItem val$item;
                final /* synthetic */ ToolPanel val$toolPanel;
                {
                    this.val$item = toolAutoRunModeItem;
                    this.val$toolPanel = toolPanel;
                    super(project3, location);
                }

                protected void doOKAction() {
                    super.doOKAction();
                    RunInTerminalToolContextProvider.this.updateGlobalTerminalRunMode(project, this.val$item);
                    Component[] components = this.val$toolPanel.getToolAutoRunChooser().getComponents();
                    if (components.length > 0 && components[components.length - 1] instanceof ToolAutoRunChooser.ModeSelectedLabel) {
                        ((ToolAutoRunChooser.ModeSelectedLabel)components[components.length - 1]).selectMode(this.val$item);
                    }
                }

                public void doCancelAction() {
                    super.doCancelAction();
                }
            }.show();
            return false;
        };
        if (function == null) {
            RunInTerminalToolContextProvider.$$$reportNull$$$0(0);
        }
        return function;
    }

    @Override
    public ToolDetailPanel initToolDetailPanel(Project project, ToolPanel toolPanel) {
        return new RunInTerminalToolDetailPanel(project, toolPanel);
    }

    private void updateGlobalTerminalRunMode(Project project, ToolAutoRunModeItem item) {
        if (Cosy.INSTANCE.checkCosy(project)) {
            GlobalConfig config = new GlobalConfig();
            config.setTerminalRunMode(ToolAutoRunChooser.ITEM_ENABLE_AUTO_RUN == item ? ToolAutoRunEnum.ENABLE_AUTO_RUN.getId() : ToolAutoRunEnum.ASK_EVERYTIME.getId());
            Cosy.INSTANCE.getLanguageService(project).updateGlobalTerminalRunMode(config, 2000L);
        }
    }

    @Override
    public void updateToolRunTipText(JLabel label) {
        label.setText(this.hasRisk ? CosyBundle.message("tool.terminal.has.risk", new Object[0]) : CosyBundle.message("tool.terminal.command.on.deny.list", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/qoder/chat/context/tool/RunInTerminalToolContextProvider", "getSelectChecker"));
    }
}

