/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.context.tool;

import com.alibabacloud.intellij.qoder.chat.context.tool.BaseToolContextProvider;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.SearchFileToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.scale.JBUIScale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang.StringUtils;

public class SearchFileToolContextProvider
extends BaseToolContextProvider {
    @Override
    public Icon getIcon(ToolCallStatusEnum status) {
        return null;
    }

    @Override
    public String getToolNameAndStatus(ToolCallStatusEnum status, String toolName) {
        switch (status) {
            case INIT: {
                return CosyBundle.message("tool.search.file", new Object[0]);
            }
            case RUNNING: {
                return CosyBundle.message("tool.searching.file", new Object[0]);
            }
            case FINISHED: {
                return CosyBundle.message("tool.searched.file", new Object[0]);
            }
            case ERROR: 
            case CANCELLED: {
                return CosyBundle.message("tool.search.file.failed", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public JComponent getScopeLabel(Project project, ToolCallInfo toolCallInfo, int maxWidth) {
        if (toolCallInfo.getParameters() == null || !toolCallInfo.getParameters().containsKey("query")) {
            return null;
        }
        String query = (String)toolCallInfo.getParameters().get("query");
        if (StringUtils.isNotBlank((String)query)) {
            JLabel queryLabel = new JLabel();
            queryLabel.setText(FontUtil.getStringAdaptiveWidth(queryLabel, query, maxWidth, false));
            queryLabel.setFont(queryLabel.getFont().deriveFont(JBUIScale.scale((float)12.0f)));
            queryLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            return queryLabel;
        }
        return null;
    }

    @Override
    public String getScopeContent(Project project, ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getParameters() == null || !toolCallInfo.getParameters().containsKey("query")) {
            return null;
        }
        Object query = (String)toolCallInfo.getParameters().get("query");
        if (((String)query).contains("*")) {
            query = "`" + (String)query + "`";
        }
        return query;
    }

    @Override
    public ToolDetailPanel initToolDetailPanel(Project project, ToolPanel toolPanel) {
        return new SearchFileToolDetailPanel(project, toolPanel);
    }
}

