/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.processor;

import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChatAnswerParams;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.topic.ChatFilteredNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.GenerateStreamPushNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.InlineChatStreamPushNotifier;
import com.alibabacloud.intellij.qoder.util.ChatSessionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.BooleanUtils;

public class ChatAnswerProcessor {
    private static final Logger log = Logger.getInstance(ChatAnswerProcessor.class);
    private final ChatAnswerParams chatAnswerParams;

    public ChatAnswerProcessor(ChatAnswerParams chatAnswerParams) {
        this.chatAnswerParams = chatAnswerParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean updateAnswer() {
        if (this.chatAnswerParams == null || this.chatAnswerParams.getText() == null || this.chatAnswerParams.getOverwrite() == null) {
            log.error("Chat answer params contain null.");
            return false;
        }
        Project project = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(this.chatAnswerParams.getRequestId());
        if (project == null) {
            log.debug("Cannot find project in chat answer processor by request_id " + this.chatAnswerParams.getRequestId());
            return false;
        }
        if (!Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).containsKey(this.chatAnswerParams.getRequestId())) {
            log.warn("request " + this.chatAnswerParams.getRequestId() + " is finished, ignore the answer");
            return false;
        }
        if (BooleanUtils.isTrue((Boolean)this.chatAnswerParams.getIsFiltered())) {
            ((ChatFilteredNotifier)project.getMessageBus().syncPublisher(ChatFilteredNotifier.CHAT_FILTERED_NOTIFICATION)).showChatFilteredMessage(this.chatAnswerParams.getRequestId());
        }
        ChatSessionUtil.updateAnsweringStatus(this.chatAnswerParams.getRequestId());
        String sessionType = (String)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_SESSION_TYPE)).get(this.chatAnswerParams.getRequestId());
        try {
            if (SessionTypeEnum.INLINE.getType().equals(sessionType)) {
                SwingUtilities.invokeAndWait(() -> ((InlineChatStreamPushNotifier)project.getMessageBus().syncPublisher(InlineChatStreamPushNotifier.INLINE_CHAT_GENERATE_STREAM_PUSH_NOTIFICATION)).push(this.chatAnswerParams.getRequestId(), this.chatAnswerParams.getSessionId(), this.chatAnswerParams.getText(), this.chatAnswerParams.getOverwrite(), false, this.chatAnswerParams.getIntentionType(), this.chatAnswerParams.getSessionType()));
            } else {
                SwingUtilities.invokeAndWait(() -> ((GenerateStreamPushNotifier)project.getMessageBus().syncPublisher(GenerateStreamPushNotifier.GENERATE_STREAM_PUSH_NOTIFICATION)).push(this.chatAnswerParams.getRequestId(), this.chatAnswerParams.getSessionId(), this.chatAnswerParams.getText(), this.chatAnswerParams.getOverwrite(), false, this.chatAnswerParams.getIntentionType(), this.chatAnswerParams.getSessionType()));
            }
        }
        catch (Exception e) {
            log.warn("send message for updating answer error", (Throwable)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(this.chatAnswerParams.getRequestId());
        }
        return true;
    }
}

