/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.processor;

import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChatFilterTimeoutParams;
import com.alibabacloud.intellij.qoder.ui.search.topic.SecurityFilterTimeoutNotifier;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;

public class ChatFilterTimeoutProcessor {
    private static final Logger log = Logger.getInstance(ChatFilterTimeoutProcessor.class);
    private ChatFilterTimeoutParams chatFilterTimeoutParams;

    public ChatFilterTimeoutProcessor(ChatFilterTimeoutParams chatFilterTimeoutParams) {
        this.chatFilterTimeoutParams = chatFilterTimeoutParams;
    }

    public Boolean timeout() {
        log.info("received filter timeout");
        if (this.chatFilterTimeoutParams == null || this.chatFilterTimeoutParams.getRequestId() == null || this.chatFilterTimeoutParams.getSessionId() == null) {
            log.error("Chat filter timeout params contain null.");
            return false;
        }
        Project project = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(this.chatFilterTimeoutParams.getRequestId());
        if (project == null) {
            Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(this.chatFilterTimeoutParams.getRequestId());
            Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(this.chatFilterTimeoutParams.getRequestId());
            log.warn("Cannot find project in chat filter timeout processor by request_id " + this.chatFilterTimeoutParams.getRequestId());
            return false;
        }
        try {
            SwingUtilities.invokeAndWait(() -> ((SecurityFilterTimeoutNotifier)project.getMessageBus().syncPublisher(SecurityFilterTimeoutNotifier.SECURITY_FILTER_TIMEOUT_NOTIFICATION)).securityFilterTimeout(this.chatFilterTimeoutParams.getRequestId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

