/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.processor;

import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChatFinishParams;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.topic.AiAssistantGenerateStreamStopNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AiDeveloperGenerateStreamStopNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.GenerateStreamStopNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.InlineChatStreamStopNotifier;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;

public class ChatFinishProcessor {
    private static final Logger log = Logger.getInstance(ChatFinishProcessor.class);
    private ChatFinishParams chatFinishParams;

    public ChatFinishProcessor(ChatFinishParams chatFinishParams) {
        this.chatFinishParams = chatFinishParams;
    }

    public Boolean finish() {
        if (this.chatFinishParams == null || this.chatFinishParams.getRequestId() == null || this.chatFinishParams.getSessionId() == null) {
            log.error("Chat answer params contain null.");
            return false;
        }
        Project project = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(this.chatFinishParams.getRequestId());
        if (project == null) {
            Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(this.chatFinishParams.getRequestId());
            Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(this.chatFinishParams.getRequestId());
            log.warn("Cannot find project in chat finish processor by request_id " + this.chatFinishParams.getRequestId());
            return false;
        }
        try {
            String sessionType = (String)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_SESSION_TYPE)).get(this.chatFinishParams.getRequestId());
            if (SessionTypeEnum.DEVELOPER.getType().equals(sessionType)) {
                SwingUtilities.invokeAndWait(() -> ((AiDeveloperGenerateStreamStopNotifier)project.getMessageBus().syncPublisher(AiDeveloperGenerateStreamStopNotifier.AI_DEVELOPER_GENERATE_STREAM_STOP_NOTIFICATION)).stop(this.chatFinishParams.getRequestId(), this.chatFinishParams.getSessionId(), this.chatFinishParams.getStatusCode(), this.chatFinishParams.getReason(), this.chatFinishParams.getExtra()));
            } else if (SessionTypeEnum.ASSISTANT.getType().equals(sessionType)) {
                SwingUtilities.invokeAndWait(() -> ((AiAssistantGenerateStreamStopNotifier)project.getMessageBus().syncPublisher(AiAssistantGenerateStreamStopNotifier.AI_ASSISTANT_GENERATE_STREAM_STOP_NOTIFICATION)).stop(this.chatFinishParams.getRequestId(), this.chatFinishParams.getSessionId(), this.chatFinishParams.getStatusCode(), this.chatFinishParams.getReason(), this.chatFinishParams.getExtra()));
            } else if (SessionTypeEnum.INLINE.getType().equals(sessionType)) {
                if (null != this.chatFinishParams.getFullAnswer()) {
                    if (null == this.chatFinishParams.getExtra()) {
                        this.chatFinishParams.setExtra(new HashMap<String, Object>());
                    }
                    this.chatFinishParams.getExtra().put("fullAnswer", this.chatFinishParams.getFullAnswer());
                }
                SwingUtilities.invokeAndWait(() -> ((InlineChatStreamStopNotifier)project.getMessageBus().syncPublisher(InlineChatStreamStopNotifier.INLINE_CHAT_GENERATE_STREAM_STOP_NOTIFICATION)).stop(this.chatFinishParams.getRequestId(), this.chatFinishParams.getSessionId(), this.chatFinishParams.getStatusCode(), this.chatFinishParams.getReason(), this.chatFinishParams.getExtra()));
            } else {
                SwingUtilities.invokeAndWait(() -> ((GenerateStreamStopNotifier)project.getMessageBus().syncPublisher(GenerateStreamStopNotifier.GENERATE_STREAM_STOP_NOTIFICATION)).stop(this.chatFinishParams.getRequestId(), this.chatFinishParams.getSessionId(), this.chatFinishParams.getStatusCode(), this.chatFinishParams.getReason(), Collections.emptyMap()));
            }
        }
        catch (Exception e) {
            log.error("finish error: " + e.getMessage(), (Throwable)e);
        }
        Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(this.chatFinishParams.getRequestId());
        Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(this.chatFinishParams.getRequestId());
        return true;
    }
}

