/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.processor;

import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChatThinkingParams;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.topic.ChatThinkingStreamPushNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.InlineChatThinkingStreamPushNotifier;
import com.alibabacloud.intellij.qoder.util.ChatSessionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;

public class ChatThinkingProcessor {
    private static final Logger log = Logger.getInstance(ChatThinkingProcessor.class);
    private static Lock lock = new ReentrantLock();
    private ChatThinkingParams chatThinkingParams;

    public ChatThinkingProcessor(ChatThinkingParams chatThinkingParams) {
        this.chatThinkingParams = chatThinkingParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean updateThinking() {
        CopyOnWriteArrayList chatThinkingList;
        if (this.chatThinkingParams == null) {
            log.error("Chat thinking params contain null.");
            return false;
        }
        Project project = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(this.chatThinkingParams.getRequestId());
        if (project == null) {
            log.debug("Cannot find project in chat thinking processor by request_id " + this.chatThinkingParams.getRequestId());
            return false;
        }
        ChatSessionUtil.updateAnsweringStatus(this.chatThinkingParams.getRequestId());
        lock.lock();
        try {
            ConcurrentHashMap<String, CopyOnWriteArrayList> answerListMap = (ConcurrentHashMap<String, CopyOnWriteArrayList>)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_THINKING_LIST);
            if (answerListMap == null) {
                answerListMap = new ConcurrentHashMap<String, CopyOnWriteArrayList>();
                ApplicationManager.getApplication().putUserData(CosyKey.REQUEST_TO_THINKING_LIST, answerListMap);
            }
            chatThinkingList = answerListMap.computeIfAbsent(this.chatThinkingParams.getRequestId(), k -> new CopyOnWriteArrayList());
        }
        finally {
            lock.unlock();
        }
        chatThinkingList.add(this.chatThinkingParams);
        String thinkingWholeText = chatThinkingList.stream().sorted(Comparator.comparingLong(ChatThinkingParams::getTimestamp)).map(ChatThinkingParams::getText).filter(Objects::nonNull).collect(Collectors.joining(""));
        boolean isDone = ChatThinkingParams.ChatThinkingStepEnum.DONE.getName().equals(this.chatThinkingParams.getStep());
        try {
            if (SessionTypeEnum.INLINE.getType().equals(this.chatThinkingParams.getSessionType())) {
                SwingUtilities.invokeAndWait(() -> ((InlineChatThinkingStreamPushNotifier)project.getMessageBus().syncPublisher(InlineChatThinkingStreamPushNotifier.INLINE_CHAT_THINKING_PUSH_NOTIFICATION)).push(this.chatThinkingParams.getRequestId(), this.chatThinkingParams.getSessionId(), thinkingWholeText, isDone));
            } else {
                SwingUtilities.invokeAndWait(() -> ((ChatThinkingStreamPushNotifier)project.getMessageBus().syncPublisher(ChatThinkingStreamPushNotifier.CHAT_THINKING_PUSH_NOTIFICATION)).push(this.chatThinkingParams.getRequestId(), this.chatThinkingParams.getSessionId(), thinkingWholeText, isDone));
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.warn("fail to send chat thinking message. " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (isDone) {
                lock.lock();
                try {
                    Map answerListMap = (Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_THINKING_LIST);
                    if (answerListMap != null) {
                        log.info("Thinking done, remove chat thinking data for request id:" + this.chatThinkingParams.getRequestId());
                        answerListMap.remove(this.chatThinkingParams.getRequestId());
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return false;
    }
}

