/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.chat.processor;

import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallSyncResult;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolCallStatusEnum;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class ChatToolEventProcessor {
    private static final Logger log = Logger.getInstance(ChatToolEventProcessor.class);
    public static final ChatToolEventProcessor INSTANCE = new ChatToolEventProcessor();
    private final Map<String, BlockingDeque<ToolCallSyncResult>> toolCallEventMap = new ConcurrentHashMap<String, BlockingDeque<ToolCallSyncResult>>();
    private final Map<String, Map<String, ToolPanel>> toolCallPanelMap = new ConcurrentHashMap<String, Map<String, ToolPanel>>();
    private final Set<String> requestIdToThreadSet = ConcurrentHashMap.newKeySet();
    private final Map<String, LockInfo> requestIdToLock = new ConcurrentHashMap<String, LockInfo>();
    private final ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(99999), new ThreadPoolExecutor.AbortPolicy());

    private ChatToolEventProcessor() {
        this.executorService.allowCoreThreadTimeOut(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPanel(@NotNull String requestId, String toolCallId, ToolPanel panel) {
        if (requestId == null) {
            ChatToolEventProcessor.$$$reportNull$$$0(0);
        }
        this.toolCallPanelMap.computeIfAbsent(requestId, k -> new ConcurrentHashMap()).computeIfAbsent(toolCallId, key -> panel);
        this.toolCallEventMap.computeIfAbsent(requestId, k -> new LinkedBlockingDeque());
        LockInfo lockInfo = this.requestIdToLock.computeIfAbsent(requestId, k -> new LockInfo());
        lockInfo.getLock().lock();
        log.info("registerPanel: requestId: " + requestId + ", toolCallId: " + toolCallId);
        try {
            if (!this.requestIdToThreadSet.contains(requestId)) {
                this.requestIdToThreadSet.add(requestId);
                this.executorService.submit(() -> {
                    try {
                        while (true) {
                            ToolCallSyncResult event;
                            if (null == (event = this.toolCallEventMap.get(requestId).poll(5L, TimeUnit.MINUTES))) {
                                log.warn("wait tool event timeout for requestId: " + requestId);
                                continue;
                            }
                            if (ToolCallStatusEnum.REQUEST_FINISHED.getStatus().equals(event.getToolCallStatus())) break;
                            ToolPanel toolPanel = this.toolCallPanelMap.get(requestId).get(event.getToolCallId());
                            if (null == toolPanel) {
                                long startTime = System.currentTimeMillis();
                                LockInfo lock = this.requestIdToLock.computeIfAbsent(requestId, k -> new LockInfo());
                                lock.getLock().lock();
                                try {
                                    while (null == toolPanel) {
                                        if (System.currentTimeMillis() - startTime > 60000L) {
                                            log.warn("wait toolPanel timeout for request: " + requestId + ", panel: " + event.getToolCallId());
                                            break;
                                        }
                                        if (!lock.getCondition().await(1L, TimeUnit.SECONDS)) {
                                            log.warn("wait toolPanel again for request: " + requestId + ", panel: " + event.getToolCallId());
                                        }
                                        toolPanel = this.toolCallPanelMap.get(requestId).get(event.getToolCallId());
                                    }
                                }
                                finally {
                                    lock.getLock().unlock();
                                }
                                if (null == toolPanel) {
                                    log.warn("wait toolPanel failed for request: " + requestId + ", panel: " + event.getToolCallId());
                                    continue;
                                }
                            }
                            ToolPanel finalToolPanel = toolPanel;
                            SwingUtilities.invokeLater(() -> finalToolPanel.syncToolCall(event));
                        }
                    }
                    catch (InterruptedException e) {
                        log.warn("wait tool message error withInterruptedException  for " + requestId, (Throwable)e);
                    }
                    this.clear(requestId);
                });
            }
        }
        finally {
            lockInfo.getCondition().signalAll();
            lockInfo.getLock().unlock();
        }
    }

    public void offerEvent(ToolCallSyncResult event) {
        if (null == event) {
            log.warn("tool event is null");
            return;
        }
        if (null == event.getRequestId()) {
            log.warn("requestId of tool event is null");
            return;
        }
        boolean offered = this.toolCallEventMap.computeIfAbsent(event.getRequestId(), k -> new LinkedBlockingDeque()).offer(event);
        if (!offered) {
            log.warn("offer tool event failed for request: " + event);
        }
    }

    public void offerRequestFinishEvent(String requestId) {
        boolean offered;
        if (null != requestId && this.toolCallEventMap.containsKey(requestId) && !(offered = this.toolCallEventMap.computeIfAbsent(requestId, k -> new LinkedBlockingDeque()).offer(ToolCallSyncResult.builder().requestId(requestId).toolCallStatus(ToolCallStatusEnum.REQUEST_FINISHED.getStatus()).build()))) {
            log.warn("offer request finish event failed for request: " + requestId);
        }
    }

    private void clear(String requestId) {
        this.requestIdToThreadSet.remove(requestId);
        if (this.toolCallEventMap.containsKey(requestId)) {
            this.toolCallEventMap.get(requestId).remove();
            this.toolCallEventMap.remove(requestId);
        }
        if (this.toolCallPanelMap.containsKey(requestId)) {
            this.toolCallPanelMap.get(requestId).clear();
            this.toolCallPanelMap.remove(requestId);
        }
        this.requestIdToLock.remove(requestId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestId", "com/alibabacloud/intellij/qoder/chat/processor/ChatToolEventProcessor", "registerPanel"));
    }

    private static class LockInfo {
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();

        private LockInfo() {
        }

        @Generated
        public Lock getLock() {
            return this.lock;
        }

        @Generated
        public Condition getCondition() {
            return this.condition;
        }
    }
}

