/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.completion;

import com.alibabacloud.intellij.qoder.completion.CosyLookupElementWeigher;
import com.alibabacloud.intellij.qoder.completion.CosyPrefixMatcher;
import com.alibabacloud.intellij.qoder.completion.model.CompletionContext;
import com.alibabacloud.intellij.qoder.completion.model.CosyCompletionItem;
import com.alibabacloud.intellij.qoder.completion.template.TemplateSettingLoader;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.CompletionParams;
import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.listener.CosyLookupListener;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.CompletionUtil;
import com.alibabacloud.intellij.qoder.util.DocumentUtils;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosyCompletionContributor
extends CompletionContributor {
    private static final Logger log = Logger.getInstance(CosyCompletionContributor.class);
    private static final long COMPLETION_TIMEOUT = 500L;
    private static final String PLACEHOLDER_PATTERN_STR = "(\\$\\d)|(\\$\\{\\d\\:([a-z0-9_]+)\\})";
    private static final Pattern DEFAULT_PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{\\d\\:([a-z0-9_]+)\\}");
    private static final Pattern DOLLAR_ZERO_PATTERN = Pattern.compile("\\$0");

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            CosyCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CosyCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters.getEditor().getProject() == null) {
            return;
        }
        Project project = parameters.getEditor().getProject();
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return;
        }
        Document document = parameters.getEditor().getDocument();
        if (parameters.getEditor().getCaretModel().getCaretCount() > 1) {
            log.info("Multi editing mode, skip completion");
            return;
        }
        this.addCosyLookupListener(parameters);
        PrefixMatcher originMatcher = result.getPrefixMatcher();
        CompletionParams completionParams = new CompletionParams();
        completionParams.setUseLocalModel(true);
        completionParams.setUseRemoteModel(false);
        String filePath = parameters.getOriginalFile().getVirtualFile().getPath();
        String fileContent = parameters.getEditor().getDocument().getText();
        if (fileContent.length() >= 5000000) {
            log.warn("File content is larger than 10M, skip completion");
            return;
        }
        CompletionContext context = this.createCompletionContext(parameters, result);
        completionParams.setFileContent(fileContent);
        int line = context.getPosition().line;
        int column = parameters.getOffset() - document.getLineStartOffset(line);
        column = column > 0 ? column : context.getPosition().column;
        completionParams.setPosition(new Position(line, column));
        completionParams.setTextDocument(new TextDocumentIdentifier(filePath));
        completionParams.setUseRemoteModel(false);
        completionParams.setUseLocalModel(true);
        completionParams.setRequestId(UUID.randomUUID().toString());
        String currentContent = DocumentUtils.getCompleteLine(document, line);
        if (currentContent != null && TemplateSettingLoader.getInstance().getTemplateKeys().contains(currentContent.trim())) {
            log.info(String.format("Current content %s matches with live template, skip", currentContent));
            return;
        }
        List<CompletionItem> items = null;
        if (Cosy.INSTANCE.getLanguageService(project) != null) {
            items = Cosy.INSTANCE.getLanguageService(project).completionWithDebouncer(completionParams, 500L);
        }
        if (items == null || items.isEmpty()) {
            return;
        }
        log.debug(items.toString());
        result = result.withPrefixMatcher(new CosyPrefixMatcher(originMatcher).cloneWithPrefix(originMatcher.getPrefix())).withRelevanceSorter(CompletionSorter.defaultSorter((CompletionParameters)parameters, (PrefixMatcher)originMatcher).weigh((LookupElementWeigher)new CosyLookupElementWeigher()));
        result.restartCompletionOnAnyPrefixChange();
        result.addAllElements(this.createCompletions(context, items));
        this.duplicateOtherItems(parameters, result, items);
    }

    private void duplicateOtherItems(CompletionParameters params, @Nonnull CompletionResultSet result, List<CompletionItem> items) {
        HashSet<String> completionItems = new HashSet<String>();
        for (CompletionItem item2 : items) {
            String completionText = CompletionUtil.getCompletionText(item2);
            completionItems.add(completionText);
        }
        result.runRemainingContributors(params, item -> {
            String lookupString = item.getLookupElement().getLookupString();
            if (!completionItems.contains(lookupString.trim())) {
                result.passResult(item);
            } else {
                log.info("filter other completion item:" + lookupString);
            }
        }, true);
    }

    private ArrayList<LookupElement> createCompletions(CompletionContext context, List<CompletionItem> items) {
        ArrayList<LookupElement> elements = new ArrayList<LookupElement>();
        int limit = this.getCompletionLimit(context);
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)context.getParameters().getEditor());
        for (int i = 0; i < items.size() && elements.size() < limit; ++i) {
            CompletionItem item = items.get(i);
            LookupElement lookupElement = this.createLookupElement(context, i, item, (Lookup)lookupEx);
            elements.add(lookupElement);
        }
        return elements;
    }

    private LookupElement createLookupElement(final CompletionContext context, int index, CompletionItem item, @Nullable Lookup lookup) {
        CosyCompletionItem cosyItem = new CosyCompletionItem(index, item, context.getCursorPrefix(), context.getCursorSuffix());
        String completionText = CompletionUtil.getCompletionText(item);
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)cosyItem, (String)completionText).withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                CosyCompletionItem lookupElement = (CosyCompletionItem)element.getObject();
                CosyCompletionContributor.this.generateLookupElementPresentation(presentation, lookupElement.getOriginItem().getLabel());
            }
        }).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext insertionContext, @NotNull LookupElement element) {
                if (insertionContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                int tail = insertionContext.getTailOffset();
                CosyCompletionItem lookupElement = (CosyCompletionItem)element.getObject();
                TextEdit textEdit = (TextEdit)lookupElement.getOriginItem().getTextEdit().getLeft();
                Range lookupElementRange = textEdit.getRange();
                String newText = CompletionUtil.getCompletionText(lookupElement.getOriginItem());
                Document document = insertionContext.getDocument();
                if (document == null) {
                    return;
                }
                String prefix = context.getPrefix();
                int startPivot = document.getLineStartOffset(lookupElementRange.getStart().getLine()) + lookupElementRange.getStart().getCharacter();
                int endPivot = document.getLineStartOffset(lookupElementRange.getEnd().getLine()) + lookupElementRange.getEnd().getCharacter();
                String startLineContent = DocumentUtils.getCompleteLine(document, lookupElementRange.getStart().getLine());
                try {
                    document.deleteString(tail - newText.length() + prefix.length(), tail);
                    document.deleteString(startPivot, endPivot);
                    int caretPivot = 0;
                    if (newText.endsWith("\n}")) {
                        String leadingWhitespaces = StringUtils.countLeadingLength(startLineContent, StringUtils.TAB_SPACE_PATTERN);
                        String tabContent = StringUtils.tabContent(leadingWhitespaces);
                        StringBuilder sb = new StringBuilder();
                        if (newText.endsWith("\n$0\n}")) {
                            sb.append(newText, 0, newText.length() - 4).append(leadingWhitespaces).append(tabContent).append("$0\n").append(leadingWhitespaces).append("}");
                            newText = sb.toString();
                        } else {
                            int endCutLength = 1;
                            if (newText.length() > 2 && newText.charAt(newText.length() - 2) == '\n') {
                                endCutLength = 2;
                            }
                            int beforeLength = newText.length() - endCutLength;
                            sb.append(newText, 0, newText.length() - endCutLength).append(leadingWhitespaces).append(tabContent).append("\n").append(leadingWhitespaces).append("}");
                            newText = sb.toString();
                            caretPivot = startPivot + beforeLength + leadingWhitespaces.length() + tabContent.length();
                        }
                    }
                    document.insertString(startPivot, (CharSequence)newText);
                    insertionContext.setTailOffset(startPivot + newText.length());
                    insertionContext.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startPivot);
                    int tailOffset = insertionContext.getTailOffset();
                    int lineEndOffset = document.getLineEndOffset(lookupElementRange.getEnd().getLine());
                    boolean isEndMatch = tailOffset == lineEndOffset;
                    boolean isBeginWithAt = startLineContent.trim().startsWith("@");
                    boolean isBeginWithLoopSymbol = startLineContent.trim().startsWith("for ") || startLineContent.trim().startsWith("for(");
                    boolean isBeginWithIf = startLineContent.trim().startsWith("if ") || startLineContent.trim().startsWith("if(");
                    boolean isContainingStream = startLineContent.trim().contains("stream()") || startLineContent.trim().contains("parallelStream()");
                    boolean dollarIsReplaced = CosyCompletionContributor.this.replaceDollarZeroAndMoveCaret(insertionContext, true);
                    if (!dollarIsReplaced && caretPivot > 0) {
                        insertionContext.getEditor().getCaretModel().moveToOffset(caretPivot);
                    }
                    if (!(dollarIsReplaced || !isEndMatch || !newText.endsWith(")") || isBeginWithAt || isBeginWithLoopSymbol || isBeginWithIf || isContainingStream)) {
                        JavaSmartEnterProcessor javaSmartEnterProcessor = new JavaSmartEnterProcessor();
                        javaSmartEnterProcessor.process(insertionContext.getProject(), insertionContext.getEditor(), insertionContext.getFile());
                    }
                }
                catch (RuntimeException re) {
                    Logger.getInstance(this.getClass()).warn("Error inserting new suffix. End = " + tail + ", old suffix length = " + lookupElement.getCursorSuffix() + ", new suffix length = " + lookupElement.getCursorSuffix(), (Throwable)re);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "insertionContext";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                }
                objectArray[1] = "com/alibabacloud/intellij/qoder/completion/CosyCompletionContributor$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return lookupElementBuilder;
    }

    @Deprecated
    private void replaceDefaultParameter(InsertionContext insertionContext) {
        String completionText = insertionContext.getDocument().getText(new TextRange(insertionContext.getStartOffset(), insertionContext.getTailOffset()));
        Matcher matcher = DEFAULT_PLACEHOLDER_PATTERN.matcher(completionText);
        int start = insertionContext.getStartOffset();
        if (matcher != null) {
            int lastOffset = 0;
            while (matcher.find()) {
                int startIndex = matcher.start();
                int endIndex = matcher.end();
                String replacedText = matcher.group(1);
                insertionContext.getDocument().replaceString(start + startIndex - lastOffset, start + endIndex - lastOffset, (CharSequence)replacedText);
                lastOffset = endIndex - startIndex - 1;
            }
        }
        insertionContext.commitDocument();
        insertionContext.commitDocument();
    }

    private boolean replaceDollarZeroAndMoveCaret(InsertionContext insertionContext, boolean needMoveCaret) {
        String completionText = insertionContext.getDocument().getText(new TextRange(insertionContext.getStartOffset(), insertionContext.getTailOffset()));
        Matcher matcher = DOLLAR_ZERO_PATTERN.matcher(completionText);
        int start = insertionContext.getStartOffset();
        int caretOffset = insertionContext.getTailOffset();
        boolean isFound = false;
        if (matcher != null) {
            int lastOffset = 0;
            while (matcher.find()) {
                int startIndex = matcher.start();
                int endIndex = matcher.end();
                String replacedText = "";
                insertionContext.getDocument().replaceString(start + startIndex - lastOffset, start + endIndex - lastOffset, (CharSequence)replacedText);
                caretOffset = start + startIndex - lastOffset;
                lastOffset = endIndex - startIndex;
                isFound = true;
            }
        }
        insertionContext.commitDocument();
        if (needMoveCaret) {
            insertionContext.getEditor().getCaretModel().moveToOffset(caretOffset);
        }
        return isFound;
    }

    private int getCompletionLimit(CompletionContext context) {
        return 4;
    }

    private CompletionContext createCompletionContext(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            CosyCompletionContributor.$$$reportNull$$$0(2);
        }
        if (result == null) {
            CosyCompletionContributor.$$$reportNull$$$0(3);
        }
        LogicalPosition position = parameters.getEditor().getCaretModel().getLogicalPosition();
        String cursorPrefix = CompletionUtil.getCursorPrefix(parameters);
        String cursorSuffix = CompletionUtil.getCursorSuffix(parameters);
        return new CompletionContext(cursorPrefix, cursorSuffix, result.getPrefixMatcher().getPrefix(), parameters, result, position);
    }

    private void generateLookupElementPresentation(LookupElementPresentation presentation, String insertionText) {
        presentation.setTypeText(CosyBundle.message("local.completion.flag.text", new Object[0]));
        presentation.setItemTextBold(false);
        presentation.setItemText(insertionText);
        presentation.setIcon(CommonIcons.AI);
    }

    private void addCosyLookupListener(CompletionParameters parameters) {
        if (parameters == null || parameters.getEditor() == null) {
            return;
        }
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)parameters.getEditor());
        if (lookupEx == null) {
            return;
        }
        lookupEx.removeLookupListener((LookupListener)CosyLookupListener.getInstance());
        lookupEx.addLookupListener((LookupListener)CosyLookupListener.getInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/completion/CosyCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createCompletionContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

