/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.completion.action;

import com.alibabacloud.intellij.qoder.completion.action.CosyApplyInlayAction;
import com.alibabacloud.intellij.qoder.completion.action.QoderAction;
import com.alibabacloud.intellij.qoder.editor.CosyInlayManager;
import com.alibabacloud.intellij.qoder.editor.CosyInlineEditManager;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;

public class BaseAcceptAction
extends EditorAction
implements DumbAware,
QoderAction {
    private static final Logger LOG = Logger.getInstance(CosyApplyInlayAction.class);

    public BaseAcceptAction(EditorActionHandler defaultHandler) {
        super(defaultHandler);
        this.setInjectedContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseAcceptAction.$$$reportNull$$$0(0);
        }
        if (this.isIgnoredKeyboardEvent(e)) {
            LOG.info("ignore keyboard event");
            e.getPresentation().setEnabled(false);
            return;
        }
        super.update(e);
    }

    private boolean isIgnoredKeyboardEvent(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseAcceptAction.$$$reportNull$$$0(1);
        }
        if (!(e.getInputEvent() instanceof KeyEvent)) {
            return false;
        }
        if (((KeyEvent)e.getInputEvent()).getKeyChar() != '\t') {
            LOG.info("isIgnoredKeyboardEvent not tab event");
            return false;
        }
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Editor editor = this.getEditor(e.getDataContext());
        if (editor == null) {
            return false;
        }
        Document document = editor.getDocument();
        int blockIndent = CodeStyle.getIndentOptions((Project)project, (Document)document).INDENT_SIZE;
        int caretOffset = editor.getCaretModel().getOffset();
        int line = document.getLineNumber(caretOffset);
        if (BaseAcceptAction.isNonEmptyLinePrefix(document, line, caretOffset)) {
            LOG.info("isIgnoredKeyboardEvent check not empty line prefix");
            return false;
        }
        int caretOffsetAfterTab = EditorUtil.indentLine(project, editor, line, blockIndent, caretOffset);
        if (caretOffsetAfterTab < caretOffset) {
            return false;
        }
        TextRange tabRange = TextRange.create((int)caretOffset, (int)caretOffsetAfterTab);
        if (CosyInlayManager.getInstance().countCompletionInlays(editor, tabRange, true, false, false, false) > 0) {
            return false;
        }
        int endOfLineInlays = CosyInlayManager.getInstance().countCompletionInlays(editor, tabRange, false, true, false, false);
        if (endOfLineInlays > 0) {
            return false;
        }
        int blockInlays = CosyInlayManager.getInstance().countCompletionInlays(editor, tabRange, false, false, true, false);
        if (blockInlays > 0) {
            TextRange caretToEndOfLineRange = TextRange.create((int)caretOffset, (int)document.getLineEndOffset(line));
            return CosyInlayManager.getInstance().countCompletionInlays(editor, caretToEndOfLineRange, true, true, false, true) > 0;
        }
        LOG.info("isIgnoredKeyboardEvent ignore accept");
        return true;
    }

    private static boolean isNonEmptyLinePrefix(Document document, int lineNumber, int caretOffset) {
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        if (lineStartOffset == caretOffset) {
            return false;
        }
        String linePrefix = document.getText(TextRange.create((int)lineStartOffset, (int)caretOffset));
        return !StringUtils.isTabsSpaces(linePrefix, false);
    }

    static boolean isSupported(@NotNull Editor editor) {
        if (editor == null) {
            BaseAcceptAction.$$$reportNull$$$0(2);
        }
        Project project = editor.getProject();
        boolean ideCompletionsSupported = true;
        if (project == null) {
            return false;
        }
        if (CosyInlayManager.getInstance().hasCompletionInlays(editor)) {
            return true;
        }
        return CosyInlineEditManager.getInstance().hasInlineEdits(editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/completion/action/BaseAcceptAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredKeyboardEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

