/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.completion.template;

import com.alibabacloud.intellij.qoder.util.LanguageUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class TemplateSettingLoader
implements Runnable {
    private static final Logger LOGGER = Logger.getInstance(TemplateSettingLoader.class);
    private static final int CACHE_MINUTE_LIMIT = 10;
    private static final int MAX_REPORT_MESSAGE_COUNT = 100;
    public static Map<String, Set<String>> relateLangs = new HashMap<String, Set<String>>();
    public Set<String> templateKeys = new HashSet<String>();
    public Map<String, Set<String>> groupTemplateKeys = new HashMap<String, Set<String>>();
    private Cache<String, Set<String>> templateCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(100L).build();
    private static TemplateSettingLoader instance;

    private TemplateSettingLoader() {
    }

    public static TemplateSettingLoader getInstance() {
        if (instance == null) {
            instance = new TemplateSettingLoader();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block5: {
            if (!this.groupTemplateKeys.isEmpty() && !this.templateKeys.isEmpty()) break block5;
            Map<String, Set<String>> map = this.groupTemplateKeys;
            synchronized (map) {
                TemplateImpl[] templates;
                block6: {
                    if (!this.groupTemplateKeys.isEmpty() && !this.templateKeys.isEmpty()) break block5;
                    templates = TemplateSettings.getInstance().getTemplates();
                    if (templates.length == 0) break block6;
                    if (this.getTemplateKeys().size() == templates.length) break block5;
                }
                Arrays.stream(templates).map(TemplateImpl::getKey).forEach(this.templateKeys::add);
                Arrays.stream(templates).collect(Collectors.groupingBy(TemplateImpl::getGroupName)).forEach((key, template) -> {
                    HashSet groupTemplateKeys = new HashSet();
                    template.forEach(t -> groupTemplateKeys.add(t.getKey()));
                    this.groupTemplateKeys.put(key.toLowerCase(Locale.ROOT), groupTemplateKeys);
                });
            }
        }
    }

    private Set<String> getDefaultTemplateKeys(String filePath) {
        String language = LanguageUtil.getLanguageByFilePath(filePath);
        if (language == null) {
            return Collections.emptySet();
        }
        language = language.toLowerCase(Locale.ROOT);
        Set relateLang = relateLangs.getOrDefault(language, Collections.emptySet());
        String cacheKey = language + "_template";
        HashSet<String> defaultTemplateKeys = (HashSet<String>)this.templateCache.getIfPresent((Object)cacheKey);
        if (defaultTemplateKeys != null) {
            return defaultTemplateKeys;
        }
        defaultTemplateKeys = new HashSet<String>();
        block0: for (Map.Entry<String, Set<String>> entry : this.groupTemplateKeys.entrySet()) {
            if (entry.getKey().contains(language.toLowerCase(Locale.ROOT))) {
                defaultTemplateKeys.addAll((Collection<String>)entry.getValue());
                continue;
            }
            for (String relateLangKey : relateLang) {
                if (!entry.getKey().contains(relateLangKey)) continue;
                defaultTemplateKeys.addAll((Collection<String>)entry.getValue());
                continue block0;
            }
        }
        this.templateCache.put((Object)cacheKey, defaultTemplateKeys);
        return defaultTemplateKeys;
    }

    public Set<String> getCurrentTemplateKeys(Editor editor) {
        if (editor == null || editor.getProject() == null || editor.getProject().isDisposed()) {
            return Collections.emptySet();
        }
        try {
            String fileExt;
            Set<String> result = null;
            int caretOffset = editor.getCaretModel().getOffset();
            int line = editor.getDocument().getLineNumber(caretOffset);
            PsiFile file = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
            if (file == null) {
                return Collections.emptySet();
            }
            Object cacheKey = file.getVirtualFile() == null ? String.valueOf(line) : file.getVirtualFile().getPath() + "_" + line;
            result = (HashSet)this.templateCache.getIfPresent(cacheKey);
            if (result != null) {
                LOGGER.debug("get template keys from cache, key: " + (String)cacheKey + " result:" + result.size());
                return result;
            }
            String fileExtCacheKey = null;
            if (file.getVirtualFile() != null && (fileExt = FilenameUtils.getExtension((String)file.getVirtualFile().getPath())) != null && (result = (Set)this.templateCache.getIfPresent((Object)(fileExtCacheKey = "cache_" + fileExt))) != null) {
                LOGGER.debug("get template keys from lang cache, key: " + (String)cacheKey + " result:" + result.size());
                return result;
            }
            result = new HashSet();
            List templates = TemplateManagerImpl.listApplicableTemplates((TemplateActionContext)TemplateActionContext.expanding((PsiFile)file, (Editor)editor));
            for (TemplateImpl template : templates) {
                result.add(template.getKey());
            }
            List customTemplates = TemplateManagerImpl.listApplicableCustomTemplates((TemplateActionContext)TemplateActionContext.expanding((PsiFile)file, (Editor)editor));
            for (CustomLiveTemplate customTemplate : customTemplates) {
                result.add(customTemplate.getTitle());
            }
            if (!result.isEmpty()) {
                this.templateCache.put(cacheKey, result);
                if (fileExtCacheKey != null) {
                    this.templateCache.put((Object)fileExtCacheKey, result);
                }
            } else if (file.getVirtualFile() != null) {
                result = this.getDefaultTemplateKeys(file.getVirtualFile().getPath());
            }
            LOGGER.debug("get template keys directly, key: " + (String)cacheKey + " result:" + result.size());
            return result;
        }
        catch (Exception e) {
            LOGGER.warn("get currentTemplate keys error", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public Set<String> getTemplateKeys() {
        return this.templateKeys;
    }

    static {
        relateLangs.put("java", new HashSet<String>(List.of("android")));
        relateLangs.put("python", new HashSet<String>(Arrays.asList("django", "flask")));
        relateLangs.put("javascript", new HashSet<String>(Arrays.asList("typescript", "vue", "react", "angular")));
        relateLangs.put("xml", new HashSet<String>(Arrays.asList("maven", "xsl")));
    }
}

