/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.completion.trigger;

import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckContext;
import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckerAdapter;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.CompletionParams;
import com.alibabacloud.intellij.qoder.editor.model.CosyEditorInlayItem;
import com.alibabacloud.intellij.qoder.editor.model.CosyEditorInlayList;
import com.alibabacloud.intellij.qoder.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.qoder.service.listener.CompletionEventListener;
import com.alibabacloud.intellij.qoder.service.model.Features;
import com.alibabacloud.intellij.qoder.util.PsiUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class CommentTriggerChecker
extends TriggerCheckerAdapter {
    private static final Logger LOG = Logger.getInstance(CommentTriggerChecker.class);
    private static final Cache<String, Integer> CACHE = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).maximumSize(100L).build();
    private static final int MAX_DISPOSE_COUNT = 2;

    private static String getCacheKey(CompletionParams params) {
        return params.getTextDocument().getUri() + "_" + params.getPosition().getLine();
    }

    private static String getCacheKey(Editor editor) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(editor.getDocument());
        if (virtualFile == null) {
            return "";
        }
        String path = virtualFile.getPresentableUrl();
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        return path + "_" + position.line;
    }

    @Override
    public boolean check(TriggerCheckContext context) {
        int lineIndex;
        int offset;
        TextRange lineSuffixRange;
        if (context.getEditor() == null || context.getCaretElement() == null) {
            return false;
        }
        Editor editor = context.getEditor();
        PsiElement element = context.getCaretElement();
        if (!PsiUtils.isCommentElement(element, editor)) {
            return true;
        }
        Document document = editor.getDocument();
        String lineSuffix = document.getText(lineSuffixRange = TextRange.create((int)(offset = editor.getCaretModel().getOffset()), (int)document.getLineEndOffset(lineIndex = document.getLineNumber(offset))));
        if (!StringUtils.isBlank((CharSequence)lineSuffix)) {
            return false;
        }
        if (!Features.COMPLETION_COMMENT_LIMIT_ENABLE.booleanValue().booleanValue()) {
            return true;
        }
        String cacheKey = CommentTriggerChecker.getCacheKey(context.getEditor());
        Integer currentValue = (Integer)CACHE.getIfPresent((Object)cacheKey);
        if (currentValue != null && currentValue >= 2) {
            LOG.debug("skip invalid comment completion. dispose count:" + currentValue + " for " + cacheKey);
            return false;
        }
        return true;
    }

    public static class CommentCompletionEventListener
    implements CompletionEventListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acceptCompletion(Editor editor, CosyEditorInlayItem inlayItem) {
            if (inlayItem.getRequest() == null) {
                return;
            }
            Cache<String, Integer> cache = CACHE;
            synchronized (cache) {
                CACHE.invalidate((Object)CommentTriggerChecker.getCacheKey(inlayItem.getRequest().getParams()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disposeCompletion(CosyEditorInlayList inlayList, InlayDisposeEventEnum disposeAction) {
            if (inlayList.getRequest() == null) {
                return;
            }
            Cache<String, Integer> cache = CACHE;
            synchronized (cache) {
                String cacheKey = CommentTriggerChecker.getCacheKey(inlayList.getRequest().getParams());
                Integer currentValue = (Integer)CACHE.getIfPresent((Object)cacheKey);
                int newValue = currentValue != null ? currentValue + 1 : 1;
                CACHE.put((Object)cacheKey, (Object)newValue);
            }
        }
    }
}

