/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.completion.trigger;

import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckContext;
import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckerAdapter;
import com.alibabacloud.intellij.qoder.util.LanguageUtil;
import com.alibabacloud.intellij.qoder.util.PsiUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;

public class InvalidElementTriggerChecker
extends TriggerCheckerAdapter {
    private static final Logger LOGGER = Logger.getInstance(InvalidElementTriggerChecker.class);
    boolean allowImport = false;
    boolean allowKeyword = true;

    public InvalidElementTriggerChecker() {
    }

    public InvalidElementTriggerChecker(boolean allowImport, boolean allowKeyword) {
        this.allowImport = allowImport;
        this.allowKeyword = allowKeyword;
    }

    @Override
    public boolean check(TriggerCheckContext context) {
        String word;
        PsiElement element;
        if (context.getEditor() == null || context.getCaretElement() == null) {
            LOGGER.debug("editor or caret element is null");
            return false;
        }
        if (PsiUtils.isLiteralElement(context.getEditor(), context.getCaretElement())) {
            LOGGER.debug("caret element is literal element");
            return false;
        }
        if (PsiUtils.isImportElement(context.getCaretElement(), context.getEditor())) {
            LOGGER.debug("caret element is import element");
            return this.allowImport;
        }
        if (!this.allowKeyword && !PsiUtils.isValidIdentifier(element = PsiUtils.findPrevValidElement(context.getCaretElement())) && (LanguageUtil.isKeyword(word = context.getCaretElement().getText()) || LanguageUtil.isKeywordPrefix(word))) {
            LOGGER.debug("caret element is keyword");
            return false;
        }
        return true;
    }
}

