/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.completion.trigger;

import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckContext;
import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckerAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;

public class LineMiddleTriggerChecker
extends TriggerCheckerAdapter {
    private static final Logger LOG = Logger.getInstance(LineMiddleTriggerChecker.class);

    @Override
    public boolean check(TriggerCheckContext context) {
        if (context.getEditor() == null || context.getCaretElement() == null) {
            return false;
        }
        Editor editor = context.getEditor();
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        boolean hasTextBefore = this.hasNonWhitespaceText(document, lineStartOffset, offset);
        boolean hasTextAfter = this.hasNonWhitespaceText(document, offset, lineEndOffset);
        if (hasTextBefore && hasTextAfter) {
            LOG.debug("Editing in the middle of a line detected");
            return true;
        }
        return false;
    }

    private boolean hasNonWhitespaceText(Document document, int startOffset, int endOffset) {
        if (startOffset >= endOffset) {
            return false;
        }
        String text = document.getText().substring(startOffset, endOffset);
        return text.trim().length() > 0;
    }
}

