/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.completion.trigger;

import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckContext;
import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckerAdapter;
import com.alibabacloud.intellij.qoder.util.DocumentUtils;
import com.alibabacloud.intellij.qoder.util.LanguageUtil;
import com.alibabacloud.intellij.qoder.util.PsiUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SymbolNameChangeTriggerChecker
extends TriggerCheckerAdapter {
    private static final Logger LOG = Logger.getInstance(SymbolNameChangeTriggerChecker.class);
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");

    @Override
    public boolean check(TriggerCheckContext context) {
        if (context.getEditor() == null || context.getCaretElement() == null) {
            return false;
        }
        Editor editor = context.getEditor();
        PsiElement element = PsiUtils.findPrevValidElement(context.getCaretElement());
        if (element == null) {
            LOG.debug("No valid element found before caret");
            return false;
        }
        if (PsiUtils.isCommentElement(element, context.getEditor()) || PsiUtils.isLiteralElement(context.getEditor(), element)) {
            LOG.debug("Element is a comment or literal: " + element.getText());
            return false;
        }
        String elementText = element.getText();
        if (!IDENTIFIER_PATTERN.matcher(elementText).matches() || LanguageUtil.isKeyword(elementText) || LanguageUtil.isKeywordPrefix(elementText)) {
            LOG.debug("Element is not a valid identifier: " + elementText);
            return false;
        }
        int elEndLine = editor.offsetToLogicalPosition((int)element.getTextRange().getEndOffset()).line;
        int offset = editor.getCaretModel().getOffset();
        int currentLine = editor.offsetToLogicalPosition((int)offset).line;
        if (currentLine != elEndLine) {
            LOG.debug("Element is not on the same line as the caret");
            return false;
        }
        String lineSuffix = DocumentUtils.getLineSuffixByOffset(editor.getDocument(), offset);
        String linePrefix = DocumentUtils.getLinePrefixByOffset(editor.getDocument(), offset);
        if (StringUtils.isBlank((CharSequence)lineSuffix) || StringUtils.isBlank((CharSequence)linePrefix)) {
            LOG.debug("Element invalid lineSuffix or linePrefix");
            return false;
        }
        if (this.isInRangeOfSymbol(editor, element, offset)) {
            LOG.debug("Symbol name change in the middle or beginning detected");
            return true;
        }
        if (this.hasMultipleReferences(element)) {
            LOG.debug("Symbol name change at the end with multiple references detected");
            return true;
        }
        LOG.debug("Invalid symbol rename");
        return false;
    }

    private boolean isInRangeOfSymbol(Editor editor, PsiElement element, int offset) {
        TextRange range = element.getTextRange();
        int elementStart = range.getStartOffset();
        int elementEnd = range.getEndOffset();
        return offset >= elementEnd - 1 || elementStart <= offset && offset <= elementEnd;
    }

    private boolean hasMultipleReferences(PsiElement element) {
        PsiElement declaration = this.getDeclaration(element);
        if (declaration == null) {
            return false;
        }
        Collection references = ReferencesSearch.search((PsiElement)declaration, (SearchScope)declaration.getUseScope()).findAll();
        return references.size() > 1;
    }

    private PsiElement getDeclaration(PsiElement element) {
        if (element instanceof PsiReference) {
            return ((PsiReference)element).resolve();
        }
        return element;
    }

    @Override
    public boolean passAllWhenPassOne() {
        return true;
    }

    @Override
    public boolean ignoreWhenNotPass() {
        return true;
    }
}

