/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.completion.trigger;

import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckContext;
import com.alibabacloud.intellij.qoder.completion.trigger.TriggerChecker;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;

public class TriggerExecutor {
    private static final Logger LOGGER = Logger.getInstance(TriggerExecutor.class);
    List<TriggerChecker> checkers = new ArrayList<TriggerChecker>();

    public TriggerExecutor() {
    }

    public TriggerExecutor(List<TriggerChecker> checkers) {
        this.checkers = checkers;
    }

    public void addChecker(TriggerChecker checker) {
        this.checkers.add(checker);
    }

    public boolean check(TriggerCheckContext context, boolean defaultValue) {
        try {
            for (TriggerChecker checker : this.checkers) {
                if (!checker.check(context)) {
                    if (checker.ignoreWhenNotPass()) continue;
                    LOGGER.warn("check failed by " + checker.getClass().getSimpleName());
                    return false;
                }
                if (!checker.passAllWhenPassOne()) continue;
                LOGGER.debug("trigger check passed by " + checker.getClass().getSimpleName());
                return true;
            }
            LOGGER.info("trigger check passed");
        }
        catch (Exception e) {
            LOGGER.warn("trigger check failed", (Throwable)e);
        }
        return defaultValue;
    }
}

