/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.completion.trigger;

import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckContext;
import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckerAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;

public class WordMiddleTriggerChecker
extends TriggerCheckerAdapter {
    private static final Logger LOG = Logger.getInstance(WordMiddleTriggerChecker.class);

    @Override
    public boolean check(TriggerCheckContext context) {
        boolean isInMiddleOfWord;
        if (context.getEditor() == null || context.getCaretElement() == null) {
            return false;
        }
        Editor editor = context.getEditor();
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        if (offset <= 0 || offset >= document.getTextLength()) {
            return false;
        }
        char charBefore = document.getCharsSequence().charAt(offset - 1);
        char charAfter = document.getCharsSequence().charAt(offset);
        boolean bl = isInMiddleOfWord = this.isPartOfIdentifier(charBefore) && this.isPartOfIdentifier(charAfter);
        if (isInMiddleOfWord) {
            LOG.debug("Editing in the middle of a word detected");
            return true;
        }
        return false;
    }

    private boolean isPartOfIdentifier(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    @Override
    public boolean passAllWhenPassOne() {
        return true;
    }

    @Override
    public boolean ignoreWhenNotPass() {
        return true;
    }
}

