/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.util.ApplicationUtil;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.VersionUtil;
import com.alibabacloud.intellij.qoder.util.ZipUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BinaryManager {
    private static final Logger log = Logger.getInstance(BinaryManager.class);
    public static final BinaryManager INSTANCE = new BinaryManager();
    public static final String VALID_ARCH = String.format("%s_%s", CosyConfig.SYSTEM_ARCH, CosyConfig.PLATFORM_NAME);
    public static final Set<String> IGNORE_FILES = new HashSet<String>(Arrays.asList("cache", "logs", "lingma_mcp.json", "extension"));

    @Contract(pure=true)
    private BinaryManager() {
    }

    public synchronized void checkBinary(boolean sameVersionForceUpdate) {
        File homeDir = CosyConfig.getHomeDirectory().toFile();
        if (!homeDir.exists() && !homeDir.mkdirs()) {
            log.error("fail to create directory " + homeDir);
            return;
        }
        this.checkBinary(homeDir, sameVersionForceUpdate);
    }

    public void checkBinary(@NotNull File workDirectory, boolean sameVersionForceUpdate) {
        if (workDirectory == null) {
            BinaryManager.$$$reportNull$$$0(0);
        }
        log.info("checking cosy binary updating, sameVersionForceUpdate = " + sameVersionForceUpdate);
        File root = this.getBinaryRoot(workDirectory);
        if (root == null) {
            log.error("fail to init binary");
            return;
        }
        File[] files = root.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.endsWith(".json");
            }
        });
        File configFile = new File(root, "config.json");
        if (files == null || files.length == 0 || !configFile.exists()) {
            this.initBinary(root);
        } else if (this.checkBinaryVersion(root, configFile, sameVersionForceUpdate)) {
            this.initBinary(root);
            ApplicationUtil.killCosyProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBinary(File binDir) {
        block21: {
            File zipTmpDir = new File(System.getProperty("java.io.tmpdir"), String.format("lingma_%d", System.currentTimeMillis()));
            try {
                log.info("start to init binary file.");
                this.findProcessAndKill();
                File archDir = ZipUtil.unZipBinary(zipTmpDir.getAbsolutePath(), VALID_ARCH);
                if (archDir == null || !archDir.exists()) {
                    log.warn("fail to unzip cosy binary for " + VALID_ARCH);
                    return;
                }
                this.checkWin7(archDir);
                try {
                    File versionDir = archDir.getParentFile();
                    File targetDir = new File(binDir, versionDir.getName());
                    if (targetDir.exists()) {
                        log.info("target version dir " + targetDir + " already exists, overwrite files.");
                        FileUtils.copyDirectoryToDirectory((File)versionDir, (File)binDir);
                    } else {
                        log.info("target version dir " + targetDir + " not exists, move files.");
                        FileUtils.moveDirectoryToDirectory((File)versionDir, (File)binDir, (boolean)true);
                    }
                    File[] files = zipTmpDir.listFiles();
                    if (files != null) {
                        for (File file : files) {
                            if (file.isDirectory()) continue;
                            log.info("copy file " + file + " to " + binDir);
                            FileUtils.copyFile((File)file, (File)new File(binDir, file.getName()));
                        }
                        break block21;
                    }
                    log.warn("fail to copy files from " + zipTmpDir + " to " + binDir + ", no files!");
                }
                catch (FileExistsException e) {
                    log.warn("fail to move directory " + archDir + " to " + binDir, (Throwable)e);
                }
            }
            catch (Throwable e) {
                log.error("fail to init binary for " + binDir, e);
            }
            finally {
                try {
                    FileUtils.deleteDirectory((File)zipTmpDir);
                }
                catch (IOException e) {
                    log.warn("fail to delete directory " + zipTmpDir, (Throwable)e);
                }
            }
        }
    }

    private void checkWin7(File finalDir) {
        boolean renamed;
        log.info("Lingma system environment arch:" + SystemInfo.OS_ARCH + " os.name:" + SystemInfo.OS_NAME + " os.version:" + SystemInfo.OS_VERSION);
        if (!SystemInfo.isWindows || "aarch64".equals(SystemInfo.OS_ARCH) || "arm64".equals(SystemInfo.OS_ARCH)) {
            log.info("Lingma system environment not windows");
            return;
        }
        if (SystemInfo.isWin10OrNewer) {
            log.info("Lingma system environment is win10 or newer");
            return;
        }
        if (finalDir == null || !finalDir.exists()) {
            log.info("Lingma system environment binary directory:" + finalDir);
            return;
        }
        File targetBinaryFile = new File(finalDir, "Qoder.exe");
        File backupBinaryFile = new File(finalDir, "QoderBak.exe");
        File win7BinaryFile = new File(finalDir, "QoderWin7.exe");
        if (targetBinaryFile.exists() && !(renamed = targetBinaryFile.renameTo(backupBinaryFile))) {
            log.warn("rename target binary file to backup binary file failed");
        }
        if (win7BinaryFile.exists()) {
            try {
                FileUtils.copyFile((File)win7BinaryFile, (File)targetBinaryFile);
            }
            catch (IOException e) {
                log.error("fail to copy win7 binary file to target binary file", (Throwable)e);
            }
        }
    }

    private void findProcessAndKill() {
        Pair<Integer, Long> infoPair = Cosy.INSTANCE.readCosyInfoFile(1, true);
        if (infoPair != null && infoPair.second != null) {
            Cosy.INSTANCE.killProcessAndDeleteInfoFile((Long)infoPair.second);
        } else {
            log.info("Pid not exist when trying to kill process, skip process killing");
        }
    }

    private boolean checkBinaryVersion(File binDir, File configFile, boolean sameVersionForceUpdate) {
        try {
            String zipVersion = ZipUtil.getCosyVersion();
            if (StringUtils.isEmpty((CharSequence)zipVersion)) {
                log.warn("invalid cosy config zip version.");
                return false;
            }
            String fileContent = FileUtils.readFileToString((File)configFile, (String)"utf-8");
            String localVersion = this.getVersionString(fileContent);
            if (StringUtils.isEmpty((CharSequence)localVersion)) {
                log.warn("invalid cosy config local version.");
                return true;
            }
            if (this.compareBinary(binDir, zipVersion, localVersion, sameVersionForceUpdate)) {
                log.warn("local binary version is not the latest. using internal version");
                return true;
            }
            if (!new File(binDir, localVersion).exists()) {
                return true;
            }
        }
        catch (IOException e) {
            log.error("fail to get config file from resource zip", (Throwable)e);
        }
        return false;
    }

    private boolean compareBinary(File binDir, String zipVersion, String localVersion, boolean sameVersionForceUpdate) {
        int flag = VersionUtil.compareVersion(zipVersion, localVersion);
        if (flag < 0) {
            log.warn("local binary version is the latest.");
            return false;
        }
        if (flag > 0) {
            log.warn("local binary version is too old, need to upgrade.");
            return true;
        }
        if (sameVersionForceUpdate) {
            log.warn("local binary version is the same, sameVersionForceUpdate=true, upgrade it.");
            return true;
        }
        log.info("local binary version is equal to plugin internal version, ignore update");
        File localBinaryFile = new File(this.getBinaryVersionPath(binDir, localVersion));
        if (!localBinaryFile.exists()) {
            log.warn("local binary not exist, upgrade it.");
            return true;
        }
        if (!ZipUtil.checkZipBinary(binDir.getAbsolutePath(), VALID_ARCH)) {
            log.warn("check binary failed, need to upgrade.");
            return true;
        }
        return false;
    }

    public String getBinaryPath(@NotNull File workDirectory) throws IOException {
        File root;
        if (workDirectory == null) {
            BinaryManager.$$$reportNull$$$0(1);
        }
        if ((root = this.getBinaryRoot(workDirectory)) == null) {
            log.error("cannot get binary root");
            return null;
        }
        File configFile = new File(root, "config.json");
        if (configFile.exists()) {
            return this.getBinaryPathFromConfig(root, configFile);
        }
        return this.getDefaultBinaryPath(root, configFile);
    }

    private File getBinaryRoot(@NotNull File workDirectory) {
        File dir;
        if (workDirectory == null) {
            BinaryManager.$$$reportNull$$$0(2);
        }
        if (!(dir = new File(workDirectory, "bin")).exists() && !dir.mkdirs()) {
            return null;
        }
        return dir;
    }

    private String getDefaultBinaryPath(File root, File configFile) throws IOException {
        File[] dirs = root.listFiles();
        long maxTime = 0L;
        File maxDir = null;
        for (File dir : dirs) {
            if (dir.isFile() || maxTime >= dir.lastModified()) continue;
            maxDir = dir;
        }
        if (maxDir != null) {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("cosy.core.version", maxDir.getName());
            FileUtils.write((File)configFile, (CharSequence)JSON.toJSONString(config), (String)"utf-8");
            this.checkBinaryPermissions(root, maxDir.getName());
            return this.getBinaryVersionPath(root, maxDir.getName());
        }
        return null;
    }

    private String getBinaryPathFromConfig(File root, File configFile) throws IOException {
        String fileContent = FileUtils.readFileToString((File)configFile, (String)"utf-8");
        if (StringUtils.isEmpty((CharSequence)fileContent)) {
            log.error("invalid cosy config file.");
            return null;
        }
        String version = this.getVersionString(fileContent);
        if (StringUtils.isEmpty((CharSequence)version)) {
            return null;
        }
        this.checkBinaryPermissions(root, version);
        return this.getBinaryVersionPath(root, version);
    }

    private String getBinaryVersionPath(File root, String version) {
        return Paths.get(root.getAbsolutePath(), version, String.format("%s_%s", CosyConfig.SYSTEM_ARCH, CosyConfig.PLATFORM_NAME), CosyConfig.COSY_EXECUTABLE_NAME).toString();
    }

    private void checkBinaryPermissions(File root, String version) {
        File[] files;
        File versionDir = Paths.get(root.getAbsolutePath(), version, String.format("%s_%s", CosyConfig.SYSTEM_ARCH, CosyConfig.PLATFORM_NAME)).toFile();
        if (versionDir.exists()) {
            versionDir.setExecutable(true);
        }
        if ((files = versionDir.listFiles()) != null) {
            for (File file : files) {
                file.setExecutable(true);
            }
        }
    }

    public String getVersionString(String configContent) {
        if (StringUtils.isEmpty((CharSequence)configContent)) {
            log.warn("invalid config content:" + configContent);
            return null;
        }
        JSONObject jobj = JSON.parseObject((String)configContent);
        String version = jobj.getString("cosy.core.version");
        if (StringUtils.isEmpty((CharSequence)version)) {
            log.warn("invalid cosy config version from cotnent:" + configContent);
            return null;
        }
        return version;
    }

    public void clearEnv() {
        log.info("starting to clear cosy env");
        ApplicationUtil.killCosyProcess();
        File homeDir = CosyConfig.getHomeDirectory().toFile();
        if (!homeDir.exists()) {
            return;
        }
        try {
            FileUtil.deleteFiles(homeDir, IGNORE_FILES);
        }
        catch (IOException e) {
            log.warn("fail to clear cosy env: " + e.getMessage(), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "workDirectory";
        objectArray2[1] = "com/alibabacloud/intellij/qoder/core/BinaryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBinary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBinaryPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBinaryRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

