/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.core;

import com.alibabacloud.intellij.qoder.core.BinaryManager;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.util.ProcessReader;
import com.alibabacloud.intellij.qoder.util.ProcessUtils;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BinaryRunner {
    private static final Logger log = Logger.getInstance(BinaryRunner.class);
    private final File workDirectory;
    private Process process;

    public BinaryRunner(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    public boolean run() throws IOException {
        this.checkBinary();
        List<String> commands = this.buildStartCommands();
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.directory(this.workDirectory);
        this.process = builder.start();
        try {
            if (this.process != null) {
                ProcessReader reader = new ProcessReader(this.process, true);
                reader.start();
            }
        }
        catch (Exception e) {
            log.warn("Kill process encountered exception");
        }
        return this.process.isAlive();
    }

    public List<String> buildStartCommands() throws IOException {
        this.checkBinary();
        @NotNull String binaryPath = BinaryManager.INSTANCE.getBinaryPath(this.workDirectory);
        List<String> binaryStartCommands = this.createCommand(binaryPath);
        log.info("commands:" + binaryStartCommands);
        return binaryStartCommands;
    }

    private void checkBinary() throws IOException {
        String binaryPath = BinaryManager.INSTANCE.getBinaryPath(this.workDirectory);
        if (binaryPath == null) {
            return;
        }
        if (!new File(binaryPath).exists()) {
            BinaryManager.INSTANCE.checkBinary(false);
        }
        if ((binaryPath = BinaryManager.INSTANCE.getBinaryPath(this.workDirectory)) == null) {
            throw new IOException("check binary failed.");
        }
    }

    public void close() {
        Runtime rt = Runtime.getRuntime();
        try {
            Long pid = ProcessUtils.getPid(this.process);
            if (pid != null) {
                Cosy.INSTANCE.killProcessAndDeleteInfoFile(pid);
            } else {
                log.info("Failed to get pid");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.process != null && this.process.isAlive()) {
            this.process.destroyForcibly();
        }
    }

    private List<String> createCommand(@NotNull String binaryPath) {
        if (binaryPath == null) {
            BinaryRunner.$$$reportNull$$$0(0);
        }
        ArrayList<String> commands = new ArrayList<String>();
        if (ProcessUtils.isWindowsPlatform()) {
            log.info("Windows platform add 'cmd /c' to detach");
            Object command = "cmd";
            File cmdFile = new File(System.getenv("WINDIR") + "\\system32\\cmd.exe");
            if (!cmdFile.exists()) {
                log.warn(cmdFile + " not found");
                cmdFile = new File("c:\\Windows\\system32\\cmd.exe");
            }
            if (cmdFile.exists()) {
                command = "\"" + cmdFile.getAbsolutePath() + "\"";
            }
            commands.add((String)command);
            commands.add("/c");
        }
        if (ProcessUtils.isWindowsPlatform()) {
            binaryPath = ((String)binaryPath).replace("(", "^(").replace(")", "^)").replace("&", "^&").replace(">", "^>").replace("<", "^<").replace("|", "^|");
            binaryPath = "\"" + (String)binaryPath + "\"";
        }
        commands.add((String)binaryPath);
        commands.add("start");
        return commands;
    }

    public Process getProcess() {
        return this.process;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryPath", "com/alibabacloud/intellij/qoder/core/BinaryRunner", "createCommand"));
    }
}

