/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.core;

import com.alibabacloud.intellij.qoder.core.BinaryManager;
import com.alibabacloud.intellij.qoder.util.ProcessReader;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class BinaryUninstaller {
    private static final Logger log = Logger.getInstance(BinaryUninstaller.class);
    private static final long UNINSTALL_TIMEOUT = 10L;

    public static void uninstall(File workDirectory) {
        try {
            String binaryPath = BinaryManager.INSTANCE.getBinaryPath(workDirectory);
            if (binaryPath == null) {
                return;
            }
            List<String> commands = BinaryUninstaller.createCommand(binaryPath, workDirectory);
            ProcessBuilder builder = new ProcessBuilder(commands);
            builder.directory(workDirectory);
            Process process = builder.start();
            ProcessReader reader = new ProcessReader(process);
            reader.start();
            log.info("wait for uninstalling");
            process.waitFor(10L, TimeUnit.SECONDS);
            log.info("uninstall process output:" + reader.getOutput());
            reader.interrupt();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("check uninstall interrupted." + e.getMessage());
        }
    }

    private static List<String> createCommand(@NotNull String binaryPath, @NotNull File workDirectory) {
        if (binaryPath == null) {
            BinaryUninstaller.$$$reportNull$$$0(0);
        }
        if (workDirectory == null) {
            BinaryUninstaller.$$$reportNull$$$0(1);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(binaryPath);
        commands.add("uninstall");
        return commands;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "binaryPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "workDirectory";
                break;
            }
        }
        objectArray[1] = "com/alibabacloud/intellij/qoder/core/BinaryUninstaller";
        objectArray[2] = "createCommand";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

