/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.core.lsp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.chat.model.BadFeedbackParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatAskParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatCodeChangeApplyParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatLikeParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatNoticeRequest;
import com.alibabacloud.intellij.qoder.chat.model.ChatQuotaRemindRequest;
import com.alibabacloud.intellij.qoder.chat.model.ChatReplyRequestParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatStopParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatSystemEventParam;
import com.alibabacloud.intellij.qoder.chat.model.GenerateCommitMsgParam;
import com.alibabacloud.intellij.qoder.chat.model.ReportDiagnosisLogParam;
import com.alibabacloud.intellij.qoder.chat.model.StepProcessConfirmParam;
import com.alibabacloud.intellij.qoder.chat.model.StopSessionParam;
import com.alibabacloud.intellij.qoder.chat.model.result.ChatAskResult;
import com.alibabacloud.intellij.qoder.chat.model.result.ChatLikeResult;
import com.alibabacloud.intellij.qoder.chat.model.result.ChatReplyListResult;
import com.alibabacloud.intellij.qoder.chat.model.result.ChatSystemEventResult;
import com.alibabacloud.intellij.qoder.chat.model.result.ReportDiagnosisLogResult;
import com.alibabacloud.intellij.qoder.chat.model.result.StepProcessConfirmResult;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.completion.model.CosyCompletionItem;
import com.alibabacloud.intellij.qoder.constants.Constants;
import com.alibabacloud.intellij.qoder.core.lsp.LanguageConnectClient;
import com.alibabacloud.intellij.qoder.core.lsp.model.AuthGrantInfoResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.LanguageClient;
import com.alibabacloud.intellij.qoder.core.lsp.model.LanguageServer;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthGrantInfo;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthLogoutResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.BaseResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatModelClassResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatModelItem;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatSession;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.FeedbackResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.GlobalCommandAllowListConfig;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.GlobalConfig;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.GlobalEndpointConfig;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.GlobalMcpAutoRunConfig;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.GlobalWebToolsAutoExecuteConfig;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.IdeSeriesType;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ListCurrentSessionResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ListSnapshotsResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ListWorkingSpaceFileResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.LoginResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.LoginStartResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.OperateCommonResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.RecommendResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.UpdateConfigResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.UpdateWorkingSpaceFileContentRequest;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.UserPlanResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.WorkingSpaceFileContent;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.WorkingSpaceFileParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChangeUserSettingParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChatModelClassRequest;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.CodebaseRecommendationParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.CodebaseRecommendationResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ComboBoxItem;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.CompletionParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.CustomCommandGetResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.DataPolicyResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.DelChatRecordParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.DelChatSessionParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GeneralStatisticsParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GenerateCommitMsgResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetChatSessionParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetComboBoxItemParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetGrantInfosParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetProfileUrlParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetProfileUrlResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ItemSelectedParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.KnowledgeBaseParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.KnowledgeBaseResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ListChatHistoryParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ListSnapshotsBySessionParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ListWorkingSpaceFileBySnapshotParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.LoginParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.PreCompletionParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.SearchParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.SnapshotOperateParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.SwitchAccountParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.UpdateParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.UpdateResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.UploadImageParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.UploadImageResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.WorkingSpaceFileOperateParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.GetSessionToolCallRequest;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ListToolCallInfoResponse;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallApproveRequest;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallSyncResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.qoder.core.pipe.CosyStdioConnectClient;
import com.alibabacloud.intellij.qoder.core.websocket.CosyWebSocketConnectClient;
import com.alibabacloud.intellij.qoder.search.asyn.Debouncer;
import com.alibabacloud.intellij.qoder.ui.search.track.ReportStatistic;
import com.alibabacloud.intellij.qoder.ui.statusbar.CosyStatusBarWidget;
import com.alibabacloud.intellij.qoder.util.ApplicationUtil;
import com.alibabacloud.intellij.qoder.util.CompletionUtil;
import com.alibabacloud.intellij.qoder.util.SuggestPromptUtil;
import com.google.gson.Gson;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.websocket.DeploymentException;
import lombok.Generated;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jsoup.internal.StringUtil;

public class LanguageWebSocketService {
    private static final Logger log = Logger.getInstance(LanguageWebSocketService.class);
    LanguageClient client;
    LanguageServer server;
    LanguageConnectClient languageClient;
    public static final String COSY_URI_LINK_PREFIX = "ws://127.0.0.1:";
    private final Debouncer completionDebouncer;
    private final Debouncer inlayCompletionDebouncer;
    private final Debouncer preCompletionDebouncer;

    private LanguageWebSocketService(LanguageConnectClient languageConnectClient, LanguageClient client, LanguageServer server) {
        this.languageClient = languageConnectClient;
        this.client = client;
        this.server = server;
        this.completionDebouncer = new Debouncer();
        this.inlayCompletionDebouncer = new Debouncer();
        this.preCompletionDebouncer = new Debouncer();
    }

    public static LanguageWebSocketService createService(Project project, int port) throws URISyntaxException {
        CosyWebSocketConnectClient webSocketClient = new CosyWebSocketConnectClient(project, new URI(COSY_URI_LINK_PREFIX + port));
        return new LanguageWebSocketService(webSocketClient, webSocketClient.getClient(), webSocketClient.getServer());
    }

    public static LanguageWebSocketService createServiceWithPipe(Project project, File homeDir, String workDir, List<String> commands) {
        CosyStdioConnectClient webSocketClient = new CosyStdioConnectClient(project, homeDir, workDir, commands.toArray(new String[0]));
        return new LanguageWebSocketService(webSocketClient, webSocketClient.getClient(), webSocketClient.getServer());
    }

    public void connect() throws DeploymentException, IOException {
        this.languageClient.connect();
        this.server = this.languageClient.getServer();
    }

    public void cancelInlayCompletion() {
        this.inlayCompletionDebouncer.shutdown();
    }

    public List<CompletionItem> completionWithDebouncer(CompletionParams params, long timeout) {
        return this.completionWithDebouncer(params, 10L, timeout);
    }

    public List<CompletionItem> completionWithDebouncer(CompletionParams params, long delayTime, long timeout) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        Future future = this.completionDebouncer.debounce(params.getRequestId(), () -> this.completion(params, timeout), delayTime, TimeUnit.MILLISECONDS);
        try {
            List result = (List)future.get(timeout, TimeUnit.MILLISECONDS);
            if (result != null) {
                completionItems.addAll(result);
            }
        }
        catch (TimeoutException e) {
            log.warn("cosy completion request timeout, RequestId:" + params.getRequestId());
        }
        catch (CancellationException e) {
            log.warn("cosy completion request canceled, RequestId:" + params.getRequestId());
        }
        catch (InterruptedException e) {
            log.warn("cosy completion debouncer is interrupted, RequestId:" + params.getRequestId());
        }
        catch (Exception e) {
            log.warn("cosy completion error " + e.getMessage() + ", RequestId:" + params.getRequestId(), (Throwable)e);
        }
        return completionItems;
    }

    public List<CompletionItem> completionInlayWithDebouncer(CompletionParams params, long delayTime, long timeout) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        Future future = this.inlayCompletionDebouncer.debounce(params.getRequestId(), () -> this.completion(params, timeout), delayTime, TimeUnit.MILLISECONDS);
        try {
            List result = (List)future.get(timeout, TimeUnit.MILLISECONDS);
            if (result != null) {
                completionItems.addAll(result);
            }
        }
        catch (TimeoutException e) {
            log.warn("cosy completion request timeout, RequestId:" + params.getRequestId());
        }
        catch (CancellationException e) {
            log.warn("cosy completion request canceled, RequestId:" + params.getRequestId());
        }
        catch (InterruptedException e) {
            log.warn("cosy completion debouncer is interrupted, RequestId:" + params.getRequestId());
        }
        catch (Exception e) {
            log.warn("cosy completion error " + e.getMessage() + ", RequestId:" + params.getRequestId(), (Throwable)e);
        }
        return completionItems;
    }

    public void aysncCompletionInlayWithDebouncer(Editor editor, CompletionParams params, long delayTime, long timeout, Consumer<CompletionParams> consumer) {
        this.inlayCompletionDebouncer.debounce(params.getRequestId(), () -> {
            if (!CompletionUtil.isTriggerWhenLookup(editor)) {
                log.info("cancel completion request by lookup popup, RequestId:" + params.getRequestId());
                return Collections.emptyList();
            }
            if (consumer != null) {
                consumer.consume((Object)params);
            }
            CosyStatusBarWidget.setStatusBarGenerating(editor.getProject(), true, false);
            List<CompletionItem> ret = this.completion(params, timeout);
            CosyStatusBarWidget.setStatusBarGenerating(editor.getProject(), false, true);
            return ret;
        }, delayTime, TimeUnit.MILLISECONDS);
    }

    public List<CompletionItem> completion(CompletionParams params, long timeout) {
        List result = null;
        try {
            log.info("tongyi trigger completion:" + params.getRequestId() + " local:" + params.getUseLocalModel() + " remote:" + params.getUseRemoteModel());
            CompletableFuture<Either<List<CompletionItem>, CompletionList>> future = this.server.getTextDocumentService().completion(params);
            Either<List<CompletionItem>, CompletionList> either = future.get(timeout, TimeUnit.MILLISECONDS);
            CompletionList list = (CompletionList)either.getRight();
            result = list != null ? list.getItems() : (List)either.getLeft();
        }
        catch (InterruptedException e) {
            log.warn("cosy completion request interrupted");
        }
        catch (TimeoutException e) {
            log.warn("cosy completion request timeout");
        }
        catch (Exception e) {
            log.warn("cosy completion error " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public RecommendResult search(SearchParams params, long timeout) {
        RecommendResult recommendResult = null;
        log.info("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<Object> future = this.server.getSnippetService().search(params);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            recommendResult = (RecommendResult)JSON.parseObject((String)JSON.toJSONString((Object)either), RecommendResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy search request timeout");
        }
        catch (Exception e) {
            log.warn("cosy search error " + e.getMessage(), (Throwable)e);
        }
        return recommendResult;
    }

    public void updateReport(ReportStatistic reportStatistic) {
        this.server.getSnippetService().report(reportStatistic);
    }

    public void changeUsageStatisticsSetting(ChangeUserSettingParams params) {
        this.server.changeUserSetting(params);
    }

    public void itemSelected(CosyCompletionItem item) {
        List arguments = item.getOriginItem().getCommand().getArguments();
        if (arguments.size() > 0) {
            Gson gson = new Gson();
            ItemSelectedParams params = (ItemSelectedParams)gson.fromJson(arguments.get(0).toString(), ItemSelectedParams.class);
            this.server.itemSelected(params);
        }
    }

    public ChatAskResult chatAsk(ChatAskParam params, long timeout) {
        ChatAskResult chatAskResult = null;
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<Object> future = this.server.getChatService().ask(params);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            chatAskResult = (ChatAskResult)JSON.parseObject((String)JSON.toJSONString((Object)either), ChatAskResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy chat ask request timeout");
        }
        catch (Exception e) {
            log.warn("cosy chat ask error " + e.getMessage(), (Throwable)e);
        }
        return chatAskResult;
    }

    public StepProcessConfirmResult stepProcessConfirm(StepProcessConfirmParam param, long timeout) {
        StepProcessConfirmResult confirmResult = null;
        try {
            CompletableFuture<Object> future = this.server.getTestAgentService().stepProcessConfirm(param);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            confirmResult = (StepProcessConfirmResult)JSON.parseObject((String)JSON.toJSONString((Object)either), StepProcessConfirmResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy stepProcessConfirm request timeout");
        }
        catch (Exception e) {
            log.warn("cosy stepProcessConfirm error " + e.getMessage(), (Throwable)e);
        }
        return confirmResult;
    }

    public ChatReplyListResult chatReplyRequest(ChatReplyRequestParam params, long timeout) {
        ChatReplyListResult chatReplyListResult = null;
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<Object> future = this.server.getChatService().replyRequest(params);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            chatReplyListResult = (ChatReplyListResult)JSON.parseObject((String)JSON.toJSONString((Object)either), ChatReplyListResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy chat reply request timeout");
        }
        catch (Exception e) {
            log.warn("cosy chat reply error " + e.getMessage(), (Throwable)e);
        }
        return chatReplyListResult;
    }

    public ChatLikeResult chatLike(ChatLikeParam params, long timeout) {
        ChatLikeResult chatLikeResult = null;
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<Object> future = this.server.getChatService().like(params);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            chatLikeResult = (ChatLikeResult)JSON.parseObject((String)JSON.toJSONString((Object)either), ChatLikeResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy chat like request timeout");
        }
        catch (Exception e) {
            log.warn("cosy chat like error " + e.getMessage(), (Throwable)e);
        }
        return chatLikeResult;
    }

    public void chatStop(ChatStopParam params) {
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            this.server.getChatService().stop(params);
        }
        catch (Exception e) {
            log.warn("cosy chat stop error " + e.getMessage(), (Throwable)e);
        }
    }

    public void stopSession(StopSessionParam params) {
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            this.server.getChatService().stopSession(params);
        }
        catch (Exception e) {
            log.warn("cosy chat stop session error " + e.getMessage(), (Throwable)e);
        }
    }

    public ChatSystemEventResult chatSystemEvent(ChatSystemEventParam params, long timeout) {
        ChatSystemEventResult chatSystemEventResult = null;
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<Object> future = this.server.getChatService().systemEvent(params);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            chatSystemEventResult = (ChatSystemEventResult)JSON.parseObject((String)JSON.toJSONString((Object)either), ChatSystemEventResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy chat system event request timeout");
        }
        catch (Exception e) {
            log.warn("cosy chat system event error " + e.getMessage(), (Throwable)e);
        }
        return chatSystemEventResult;
    }

    public List<ChatSession> listAllSessions(ListChatHistoryParams listChatHistoryParams, long timeout) {
        List<ChatSession> chatHistoryRecords = null;
        log.debug("params: " + JSON.toJSON((Object)listChatHistoryParams));
        try {
            CompletableFuture<List<ChatSession>> future = this.server.getChatService().listAllSessions(listChatHistoryParams);
            chatHistoryRecords = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("chat list all sessions request timeout");
        }
        catch (Exception e) {
            log.warn("chat list all sessions error " + e.getMessage(), (Throwable)e);
        }
        return chatHistoryRecords;
    }

    public ChatSession getSessionById(GetChatSessionParams getChatSessionParams, long timeout) {
        ChatSession chatSession = null;
        log.debug("params: " + JSON.toJSON((Object)getChatSessionParams));
        try {
            CompletableFuture<ChatSession> future = this.server.getChatService().getSessionById(getChatSessionParams);
            chatSession = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("chat get session by id request timeout");
        }
        catch (Exception e) {
            log.warn("chat get session by id error " + e.getMessage(), (Throwable)e);
        }
        return chatSession;
    }

    public boolean deleteChatById(DelChatRecordParams delChatRecordParams) {
        log.debug("params: " + JSON.toJSON((Object)delChatRecordParams));
        try {
            this.server.getChatService().deleteChatById(delChatRecordParams);
            return true;
        }
        catch (Exception e) {
            log.warn("chat delete chat by id error " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean deleteSessionById(DelChatSessionParams delChatSessionParams) {
        log.debug("params: " + JSON.toJSON((Object)delChatSessionParams));
        try {
            this.server.getChatService().deleteSessionById(delChatSessionParams);
            return true;
        }
        catch (Exception e) {
            log.warn("chat delete session by id error " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean clearAllSessions() {
        try {
            this.server.getChatService().clearAllSessions();
            return true;
        }
        catch (Exception e) {
            log.warn("chat clear all sessions error " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public LoginStartResult authLogin(LoginParams loginParams, long timeout) {
        try {
            CompletableFuture<LoginStartResult> future = this.server.getAuthService().login(loginParams);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("cosy auth login request timeout");
        }
        catch (Exception e) {
            log.warn("cosy login error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public LoginResult getLoginInfo(long timeout) {
        try {
            CompletableFuture<LoginResult> future = this.server.getLoginService().generateUrl();
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("cosy get login info timeout");
        }
        catch (Exception e) {
            log.warn("cosy get login info error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public AuthStatus authStatus(long timeout) {
        return this.authStatus(timeout, 1);
    }

    public AuthStatus authStatus(long timeout, int retryCount) {
        for (int i = 0; i < retryCount; ++i) {
            try {
                CompletableFuture<AuthStatus> future = this.server.getAuthService().status();
                return future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                log.warn("cosy get auth status timeout");
            }
            catch (Exception e) {
                log.warn("cosy get auth status error " + e.getMessage(), (Throwable)e);
            }
            if (i >= retryCount - 1) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean authLogout(long timeout) {
        try {
            CompletableFuture<AuthLogoutResult> future = this.server.getAuthService().logout();
            AuthLogoutResult result = future.get(timeout, TimeUnit.MILLISECONDS);
            if (result != null && result.getSuccess() != null) {
                return result.getSuccess();
            }
        }
        catch (TimeoutException e) {
            log.warn("cosy auth logout timeout");
        }
        catch (Exception e) {
            log.warn("cosy logout error " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Deprecated
    public List<AuthGrantInfo> getGrantInfos(GetGrantInfosParams params, long timeout) {
        try {
            CompletableFuture<List<AuthGrantInfo>> future = this.server.getAuthService().grantInfos(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("cosy auth get grant infos timeout");
        }
        catch (Exception e) {
            log.warn("cosy auth get grant infos error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public AuthGrantInfoResult getGrantInfoResult(GetGrantInfosParams params, long timeout) {
        try {
            CompletableFuture<AuthGrantInfoResult> future = this.server.getAuthService().grantInfosWrap(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("cosy auth get grant infos timeout");
        }
        catch (Exception e) {
            log.warn("cosy auth get grant infos error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public BaseResult switchAccount(SwitchAccountParams params, long timeout) {
        try {
            CompletableFuture<BaseResult> future = this.server.getAuthService().switchAccount(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("cosy switch account timeout");
        }
        catch (Exception e) {
            log.warn("cosy switch account error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public GlobalConfig getGlobalConfig(long timeout) {
        try {
            CompletableFuture<GlobalConfig> future = this.server.getGlobalConfig();
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("get global config timeout");
        }
        catch (Exception e) {
            log.warn("cosy global config error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void updateGlobalConfig(GlobalConfig params, long timeout) {
        try {
            this.server.updateGlobalConfig(params);
        }
        catch (Exception e) {
            log.warn("cosy update global config error " + e.getMessage(), (Throwable)e);
        }
    }

    public void updateGlobalMcpAutoRun(GlobalMcpAutoRunConfig params, long timeout) {
        try {
            this.server.updateGlobalMcpAutoRun(params);
        }
        catch (Exception e) {
            log.warn("cosy update global config error " + e.getMessage(), (Throwable)e);
        }
    }

    public void appendCommandAllowList(GlobalCommandAllowListConfig params, long timeout) {
        try {
            this.server.appendCommandAllowList(params);
        }
        catch (Exception e) {
            log.warn("cosy update global config error " + e.getMessage(), (Throwable)e);
        }
    }

    public void removeCommandAllowList(GlobalCommandAllowListConfig params, long timeout) {
        try {
            this.server.removeCommandAllowList(params);
        }
        catch (Exception e) {
            log.warn("cosy update global config error " + e.getMessage(), (Throwable)e);
        }
    }

    public void updateGlobalTerminalRunMode(GlobalConfig params, long timeout) {
        try {
            this.server.updateGlobalTerminalRunMode(params);
        }
        catch (Exception e) {
            log.warn("cosy update global config error " + e.getMessage(), (Throwable)e);
        }
    }

    public void updateGlobalWebToolsAutoExecute(GlobalWebToolsAutoExecuteConfig params, long timeout) {
        try {
            this.server.updateGlobalWebToolsAutoExecute(params);
        }
        catch (Exception e) {
            log.warn("cosy update global config error " + e.getMessage(), (Throwable)e);
        }
    }

    public GlobalEndpointConfig getEndpointConfig(long timeout) {
        try {
            CompletableFuture<GlobalEndpointConfig> future = this.server.getEndpoint();
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("get global endpoint timeout");
        }
        catch (Exception e) {
            log.warn("cosy global endpoint error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public UpdateConfigResult updateEndpoint(GlobalEndpointConfig params, long timeout) {
        try {
            CompletableFuture<UpdateConfigResult> future = this.server.updateEndpoint(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.warn("cosy update endpoint config error " + e.getMessage(), (Throwable)e);
            return new UpdateConfigResult(false);
        }
    }

    public Map<String, List<ChatModelItem>> queryModels(long timeout) {
        try {
            CompletableFuture<Map<String, List<ChatModelItem>>> future = this.server.queryModels();
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.warn("cosy query model error " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public FeedbackResult submitFeedback(BadFeedbackParam badFeedbackParam, long timeout) {
        FeedbackResult feedbackResult = null;
        log.debug("params: " + JSON.toJSON((Object)badFeedbackParam));
        try {
            CompletableFuture<Object> future = this.server.getFeedbackService().submit(badFeedbackParam);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            feedbackResult = (FeedbackResult)JSON.parseObject((String)JSON.toJSONString((Object)either), FeedbackResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy submit feedback request timeout");
        }
        catch (Exception e) {
            log.warn("cosy submit feedback error " + e.getMessage(), (Throwable)e);
        }
        return feedbackResult;
    }

    public void telemetry(String eventType, String requestId, Map<String, String> data) {
        GeneralStatisticsParams params = new GeneralStatisticsParams();
        params.setEventType(eventType);
        params.setRequestId(requestId);
        params.setEventData(data);
        params.setIdeVersion(CosyConfig.IDE_VERSION);
        params.setIdeType(CosyConfig.IDE_NAME);
        params.setPluginPublisher(Constants.TELEMETRY_PLUGIN_PUBLISHER);
        params.setPluginName(Constants.TELEMETRY_PLUGIN_NAME);
        this.server.telemetry(params);
    }

    public UpdateResult ideUpdate(boolean autoDownload, long timeout) {
        try {
            UpdateParams params = new UpdateParams();
            params.setAutoDownload(autoDownload);
            params.setIdeType(IdeSeriesType.JETBRAINS.getName().toLowerCase(Locale.ROOT));
            params.setIdeVersion(ApplicationUtil.getApplicationVersion());
            params.setPluginVersion(Constants.getPluginVersion());
            CompletableFuture<UpdateResult> future = this.server.ideUpdate(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("cosy update timeout");
        }
        catch (Exception e) {
            log.warn("cosy update error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public GenerateCommitMsgResult generateCommitMsg(GenerateCommitMsgParam params, long timeout) {
        GenerateCommitMsgResult generateCommitMsgResult = null;
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<GenerateCommitMsgResult> future = this.server.generateCommitMsg(params);
            GenerateCommitMsgResult either = future.get(timeout, TimeUnit.MILLISECONDS);
            generateCommitMsgResult = (GenerateCommitMsgResult)JSON.parseObject((String)JSON.toJSONString((Object)either), GenerateCommitMsgResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy generate commit message request timeout");
        }
        catch (Exception e) {
            log.warn("cosy generate commit message  error " + e.getMessage(), (Throwable)e);
        }
        return generateCommitMsgResult;
    }

    public void preCompletionWithDebouncer(PreCompletionParams params, long delayTime, long timeout) {
        this.preCompletionDebouncer.debounce(params.getRequestId(), () -> {
            this.triggerPreCompletion(params);
            return null;
        }, delayTime, TimeUnit.MILLISECONDS);
    }

    private void triggerPreCompletion(PreCompletionParams params) {
        try {
            this.server.getTextDocumentService().preCompletion(params);
        }
        catch (Exception e) {
            log.warn("pre completion request interrupt");
        }
    }

    public CustomCommandGetResult refreshCustomCommands(Project project, long timeout) {
        CustomCommandGetResult customCommandGetResult = null;
        try {
            CompletableFuture<CustomCommandGetResult> future = this.server.getCustomCommands();
            CustomCommandGetResult either = future.get(timeout, TimeUnit.MILLISECONDS);
            customCommandGetResult = (CustomCommandGetResult)JSON.parseObject((String)JSON.toJSONString((Object)either), CustomCommandGetResult.class);
            log.debug("extension/query result is " + either);
            if (customCommandGetResult == null) {
                log.warn("get custom command result is null");
                return customCommandGetResult;
            }
            SuggestPromptUtil.updateCustomSuggestPrompt(project, customCommandGetResult);
            return customCommandGetResult;
        }
        catch (TimeoutException e) {
            log.warn("cosy get custom commands request timeout");
        }
        catch (Exception e) {
            log.warn("cosy get custom commands  error " + e.getMessage(), (Throwable)e);
        }
        return customCommandGetResult;
    }

    public LanguageServer getServer() {
        return this.server;
    }

    public boolean isSessionOpen() {
        return this.languageClient.isSessionOpen();
    }

    public void closeSession() {
        this.languageClient.closeSession();
    }

    public LanguageConnectClient getLanguageClient() {
        return this.languageClient;
    }

    public boolean agreeImprovementPlan() {
        try {
            CompletableFuture<DataPolicyResult> future = this.server.agreeDataPolicy();
            DataPolicyResult dataPolicyResult = future.get(10000L, TimeUnit.MILLISECONDS);
            if (dataPolicyResult == null || dataPolicyResult.getErrorCode() != null) {
                log.warn("agreeImprovementPlan error, result is " + dataPolicyResult);
                return false;
            }
        }
        catch (TimeoutException e) {
            log.warn("agree improvement plan timeout ");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("agree improvement plan error " + e);
            return false;
        }
        return true;
    }

    public boolean disagreeImprovementPlan() {
        try {
            CompletableFuture<DataPolicyResult> future = this.server.disagreeDataPolicy();
            DataPolicyResult dataPolicyResult = future.get(10000L, TimeUnit.MILLISECONDS);
            if (dataPolicyResult == null || dataPolicyResult.getErrorCode() != null) {
                log.warn("disagreeImprovementPlan error, result is " + dataPolicyResult);
                return false;
            }
        }
        catch (TimeoutException e) {
            log.warn("disagree improvement plan timeout ");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("disagree improvement plan  error " + e);
            return false;
        }
        return true;
    }

    public String getProfileUrl(GetProfileUrlParams getProfileUrlParams) {
        try {
            CompletableFuture<GetProfileUrlResult> future = this.server.getProfileUrl(getProfileUrlParams);
            GetProfileUrlResult getProfileUrlResult = future.get(10000L, TimeUnit.MILLISECONDS);
            if (getProfileUrlResult == null || getProfileUrlResult.getUrl() == null) {
                log.warn("get profile url error, result is " + getProfileUrlResult);
                return null;
            }
            return getProfileUrlResult.getUrl();
        }
        catch (TimeoutException e) {
            log.warn("get profile url timeout ");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("get profile url error " + e);
        }
        return null;
    }

    public boolean updateProfile(GetProfileUrlParams updateProfileParams) {
        try {
            log.debug("updateProfile params is " + updateProfileParams);
            this.server.updateProfile(updateProfileParams);
        }
        catch (Exception e) {
            log.warn("get profile url error " + e, (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean uploadImage(UploadImageParams uploadImageParams) {
        try {
            log.debug("uploadImage params is " + uploadImageParams);
            CompletableFuture<UploadImageResult> future = this.server.uploadImage(uploadImageParams);
            UploadImageResult uploadImageResult = future.get(10000L, TimeUnit.MILLISECONDS);
            if (uploadImageResult == null || !StringUtil.isBlank((String)uploadImageResult.getErrorMessage()) || uploadImageResult.getResult() == null) {
                log.warn("uploadImage error, result=" + JSONObject.toJSONString((Object)uploadImageResult));
                return false;
            }
            return uploadImageResult.getResult().get("success");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("get profile url error " + e);
            return false;
        }
    }

    public List<ComboBoxItem> loadComboBoxItems(GetComboBoxItemParams params, int timeout) {
        List customCommandGetResult = null;
        try {
            CompletableFuture<List<ComboBoxItem>> future = this.server.loadComboBoxItems(params);
            List<ComboBoxItem> either = future.get(timeout, TimeUnit.MILLISECONDS);
            customCommandGetResult = JSONArray.parseArray((String)JSON.toJSONString(either), ComboBoxItem.class);
            log.debug("loadComboBoxItems result is " + either);
            if (customCommandGetResult == null) {
                log.warn("loadComboBoxItems result is null");
                return customCommandGetResult;
            }
            return customCommandGetResult;
        }
        catch (TimeoutException e) {
            log.warn("cosy get custom commands request timeout");
        }
        catch (Exception e) {
            log.warn("cosy get custom commands  error " + e.getMessage(), (Throwable)e);
        }
        return customCommandGetResult;
    }

    public ListSnapshotsResult listSnapshotsBySession(ListSnapshotsBySessionParams params, long timeout) {
        try {
            CompletableFuture<ListSnapshotsResult> future = this.server.getSnapshotService().listBySession(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("list snapshots by session timeout");
        }
        catch (Exception e) {
            log.warn("list snapshots by session error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public OperateCommonResult operateSnapshot(SnapshotOperateParams params, long timeout) {
        try {
            CompletableFuture<OperateCommonResult> future = this.server.getSnapshotService().operate(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("operate snapshot timeout");
        }
        catch (Exception e) {
            log.warn("operate snapshot error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public ListWorkingSpaceFileResult listWorkingSpaceFilesBySnapshot(ListWorkingSpaceFileBySnapshotParams params, long timeout) {
        try {
            CompletableFuture<ListWorkingSpaceFileResult> future = this.server.getWorkingSpaceFileService().listBySnapshot(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("list working space files by snapshot timeout");
        }
        catch (Exception e) {
            log.warn("list working space files by snapshot error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public WorkingSpaceFileContent getLastStableContent(WorkingSpaceFileParams params, long timeout) {
        try {
            CompletableFuture<WorkingSpaceFileContent> future = this.server.getWorkingSpaceFileService().getLastStableContent(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("list working space files by snapshot timeout");
        }
        catch (Exception e) {
            log.warn("list working space files by snapshot error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public WorkingSpaceFileContent getFullContent(WorkingSpaceFileParams params, long timeout) {
        try {
            CompletableFuture<WorkingSpaceFileContent> future = this.server.getWorkingSpaceFileService().getFullContent(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("list working space files by snapshot timeout");
        }
        catch (Exception e) {
            log.warn("list working space files by snapshot error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public OperateCommonResult operateWorkingSpaceFile(WorkingSpaceFileOperateParams params, long timeout) {
        try {
            CompletableFuture<OperateCommonResult> future = this.server.getWorkingSpaceFileService().operate(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("operate working space file timeout");
        }
        catch (Exception e) {
            log.warn("operate working space file error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public List<String> listCurrentSession(long timeout) {
        try {
            CompletableFuture<ListCurrentSessionResult> future = this.server.getSessionService().getCurrent();
            ListCurrentSessionResult listCurrentSessionResult = future.get(timeout, TimeUnit.MILLISECONDS);
            if (StringUtils.isNotBlank((String)listCurrentSessionResult.getErrorCode())) {
                log.warn("list current session errorCode=" + listCurrentSessionResult.getErrorCode() + "&errorMsg=" + listCurrentSessionResult.getErrorMessage());
                return null;
            }
            return listCurrentSessionResult.getCurrentSessionIds();
        }
        catch (TimeoutException e) {
            log.warn("list current session timeout");
        }
        catch (Exception e) {
            log.warn("list current session error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public OperateCommonResult updateContent(UpdateWorkingSpaceFileContentRequest params, long timeout) {
        try {
            CompletableFuture<OperateCommonResult> future = this.server.getWorkingSpaceFileService().updateContent(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("update working space file timeout");
        }
        catch (Exception e) {
            log.warn("update working space file error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public ReportDiagnosisLogResult reportIssue(ReportDiagnosisLogParam params, long timeout) {
        ReportDiagnosisLogResult result = null;
        try {
            CompletableFuture<ReportDiagnosisLogResult> future = this.server.getSystemService().reportDiagnosisLog(params);
            result = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("reportIssue timeout");
        }
        catch (Exception e) {
            log.warn("reportIssue error " + e.getMessage(), (Throwable)e);
        }
        if (null == result) {
            log.warn("reportIssue failed with null result");
        } else if (result.getErrorCode() != null) {
            log.warn("reportIssue failed with errorCode=" + result.getErrorCode() + "&errorMsg=" + result.getErrorMessage());
        }
        return result;
    }

    public CodebaseRecommendationResult getCodebaseRecommendation(CodebaseRecommendationParams params, long timeout) {
        CodebaseRecommendationResult result = null;
        try {
            CompletableFuture<CodebaseRecommendationResult> future = this.server.getCodebaseRecommendation(params);
            result = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("getCodebaseRecommendation timeout");
        }
        catch (Exception e) {
            log.warn("getCodebaseRecommendation error " + e.getMessage(), (Throwable)e);
        }
        if (null == result) {
            log.warn("getCodebaseRecommendation failed with null result");
        } else if (result.getErrorCode() != null) {
            log.warn("getCodebaseRecommendation failed with errorCode=" + result.getErrorCode() + "&errorMsg=" + result.getErrorMessage());
        } else if (null == result.getMetas()) {
            log.warn("getCodebaseRecommendation with empty result");
        }
        return result;
    }

    public KnowledgeBaseResult getKnowledgeBaseList(KnowledgeBaseParams params, long timeout) {
        KnowledgeBaseResult result = null;
        try {
            CompletableFuture<KnowledgeBaseResult> future = this.server.getKnowledgeBaseList(params);
            result = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("getKnowledgeBaseList timeout");
        }
        catch (Exception e) {
            log.warn("getKnowledgeBaseList error " + e.getMessage(), (Throwable)e);
        }
        if (null == result) {
            log.warn("getKnowledgeBaseList failed with null result");
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)result.getErrorMessage())) {
            log.warn("getKnowledgeBaseList failed with errorMsg=" + result.getErrorMessage());
        } else if (null == result.getList()) {
            log.warn("getKnowledgeBaseList with empty result");
        }
        return result;
    }

    public OperateCommonResult reportToolInvokeResult(ToolInvokeResponse response, long timeout) {
        OperateCommonResult result = null;
        try {
            CompletableFuture<OperateCommonResult> future = this.server.getToolService().invokeResult(response);
            result = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("reportToolInvokeResult timeout");
        }
        catch (Exception e) {
            log.warn("reportToolInvokeResult error " + e.getMessage(), (Throwable)e);
        }
        if (null == result) {
            log.warn("reportToolInvokeResult failed with null result");
        } else if (result.getErrorCode() != null) {
            log.warn("reportToolInvokeResult failed with errorCode=" + result.getErrorCode() + "&errorMsg=" + result.getErrorMessage());
        }
        return result;
    }

    public void toolCallApprove(ToolCallApproveRequest request, long timeout) {
        try {
            CompletableFuture<Object> future = this.server.getToolCallService().approve(request);
            Object object = future.get(timeout, TimeUnit.MILLISECONDS);
            if (object != null) {
                log.debug("toolCallApprove result not null");
            }
        }
        catch (TimeoutException e) {
            log.warn("toolCallApprove timeout");
        }
        catch (Exception e) {
            log.warn("toolCallApprove error " + e.getMessage(), (Throwable)e);
        }
    }

    public List<ToolCallSyncResult> listToolCallInfo(String sessionId, long timeout) {
        try {
            GetSessionToolCallRequest request = new GetSessionToolCallRequest(sessionId);
            CompletableFuture<ListToolCallInfoResponse> future = this.server.getToolCallService().listToolCallInfo(request);
            ListToolCallInfoResponse response = future.get(timeout, TimeUnit.MILLISECONDS);
            if (BooleanUtils.isTrue((Boolean)response.getSuccessful())) {
                return response.getToolResults();
            }
            return null;
        }
        catch (TimeoutException e) {
            log.warn("listToolCallInfo timeout");
        }
        catch (Exception e) {
            log.warn("listToolCallInfo error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void chatCodeChangeApply(ChatCodeChangeApplyParam request, long timeout) {
        try {
            log.debug("chatCodeChangeApply request=" + JSON.toJSONString((Object)request));
            CompletableFuture<Object> future = this.server.getChatService().codeChangeApply(request);
            Object response = future.get(timeout, TimeUnit.MILLISECONDS);
            if (response != null) {
                log.debug("chatCodeChangeApply result=" + JSON.toJSONString((Object)response));
            }
        }
        catch (TimeoutException e) {
            log.warn("chatCodeChangeApply timeout");
        }
        catch (Exception e) {
            log.warn("chatCodeChangeApply error " + e.getMessage(), (Throwable)e);
        }
    }

    public void receiveNotice(ChatNoticeRequest request) {
        try {
            CompletableFuture<Void> future = this.server.getChatService().receiveNotice(request);
            Void response = future.get(3000L, TimeUnit.MILLISECONDS);
            if (response != null) {
                log.debug("receiveNotice result=" + JSON.toJSONString((Object)response));
            }
        }
        catch (TimeoutException e) {
            log.warn("receiveNotice timeout");
        }
        catch (Exception e) {
            log.warn("receiveNotice error " + e.getMessage(), (Throwable)e);
        }
    }

    public void dontRemindMeQuota(ChatQuotaRemindRequest request) {
        try {
            CompletableFuture<Void> future = this.server.getChatService().quotaNotRemind(request);
            Void response = future.get(3000L, TimeUnit.MILLISECONDS);
            if (response != null) {
                log.debug("dontRemindMeQuota result=" + JSON.toJSONString((Object)response));
            }
        }
        catch (TimeoutException e) {
            log.warn("dontRemindMeQuota timeout");
        }
        catch (Exception e) {
            log.warn("dontRemindMeQuota error " + e.getMessage(), (Throwable)e);
        }
    }

    public List<ChatModelClassResult> queryModelClasses(String sessionType) {
        try {
            CompletableFuture<List<ChatModelClassResult>> future = this.server.queryModelClasses(ChatModelClassRequest.builder().scene(sessionType).build());
            return future.get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("queryModelClasses timeout");
        }
        catch (Exception e) {
            log.warn("queryModelClasses error " + e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    public UserPlanResult queryUserPlan() {
        try {
            CompletableFuture<UserPlanResult> future = this.server.queryUserPlan();
            return future.get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("queryUserPlan timeout");
        }
        catch (Exception e) {
            log.warn("queryUserPlan error " + e.getMessage(), (Throwable)e);
        }
        return new UserPlanResult();
    }

    private List<ChatModelClassResult> mock() {
        return Arrays.asList(ChatModelClassResult.builder().name("auto").enabled(true).multiModalSupported(true).priceFactor(1.0).originalPriceFactor(1.0).build(), ChatModelClassResult.builder().name("performance").enabled(false).multiModalSupported(true).priceFactor(1.0).originalPriceFactor(1.0).build(), ChatModelClassResult.builder().name("efficient").enabled(false).multiModalSupported(true).priceFactor(1.0).originalPriceFactor(1.0).build(), ChatModelClassResult.builder().name("lite").enabled(true).multiModalSupported(false).priceFactor(1.0).originalPriceFactor(1.0).build());
    }

    @Generated
    public LanguageClient getClient() {
        return this.client;
    }

    @Generated
    public Debouncer getInlayCompletionDebouncer() {
        return this.inlayCompletionDebouncer;
    }
}

