/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.core.lsp.model.params;

import com.alibabacloud.intellij.qoder.core.lsp.model.model.LoginDedicatedType;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.RegionEnvEnum;
import com.alibabacloud.intellij.qoder.search.enums.LoginModeEnum;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class LoginParams {
    String loginType;
    String accessKey;
    String secretKey;
    String userName;
    String orgId;
    String personalToken;
    String regionEnv;
    String loginDedicatedType;

    public static LoginParams fromUserName(String userName) {
        LoginParams result = new LoginParams();
        result.setLoginType(LoginModeEnum.USERNAME_ONLY.getLabel());
        result.setUserName(userName);
        return result;
    }

    public static LoginParams fromAccessKey(String accessKey, String secretKey, String orgId, RegionEnvEnum regionEnv, LoginDedicatedType loginDedicatedType) {
        LoginParams result = new LoginParams();
        result.setLoginType(LoginModeEnum.ACCESS_KEY.getLabel());
        result.setAccessKey(accessKey);
        result.setSecretKey(secretKey);
        result.setOrgId(orgId);
        result.setRegionEnv(regionEnv.getId());
        result.setLoginDedicatedType(loginDedicatedType.getId());
        return result;
    }

    public static LoginParams fromAliyun() {
        LoginParams result = new LoginParams();
        result.setLoginType(LoginModeEnum.ALIYUN_ACCOUNT.getLabel());
        result.setRegionEnv(RegionEnvEnum.CN.getId());
        result.setLoginDedicatedType(LoginDedicatedType.STANDARD.getId());
        return result;
    }

    public static LoginParams fromAliyunCloud() {
        LoginParams result = new LoginParams();
        result.setLoginType(LoginModeEnum.ALIYUN_ACCOUNT.getLabel());
        result.setRegionEnv(RegionEnvEnum.INTL.getId());
        result.setLoginDedicatedType(LoginDedicatedType.STANDARD.getId());
        return result;
    }

    public static LoginParams fromDedicatedDomain() {
        LoginParams result = new LoginParams();
        result.setLoginType(LoginModeEnum.DEDICATED.getLabel());
        result.setRegionEnv(RegionEnvEnum.UNKNOWN.getId());
        result.setLoginDedicatedType(LoginDedicatedType.DEDICATED.getId());
        return result;
    }

    public static LoginParams fromPersonalToken(String personalToken, String orgId, RegionEnvEnum regionEnvEnum, LoginDedicatedType loginDedicatedType) {
        LoginParams result = new LoginParams();
        result.setLoginType(LoginModeEnum.PERSONAL_TOKEN.getLabel());
        result.setPersonalToken(personalToken);
        result.setOrgId(orgId);
        result.setRegionEnv(regionEnvEnum.getId());
        result.setLoginDedicatedType(loginDedicatedType.getId());
        return result;
    }

    public boolean validate() {
        if (LoginModeEnum.ALIYUN_ACCOUNT.getLabel().equals(this.getLoginType())) {
            return true;
        }
        if (LoginModeEnum.INTL_ALIYUN_ACCOUNT.getLabel().equals(this.getLoginType())) {
            return true;
        }
        if (LoginModeEnum.ACCESS_KEY.getLabel().equals(this.getLoginType())) {
            return StringUtils.isNotBlank((CharSequence)this.getAccessKey()) && StringUtils.isNotBlank((CharSequence)this.getSecretKey());
        }
        if (LoginModeEnum.USERNAME_ONLY.getLabel().equals(this.getLoginType())) {
            return StringUtils.isNotBlank((CharSequence)this.getUserName());
        }
        if (LoginModeEnum.PERSONAL_TOKEN.getLabel().equals(this.getLoginType())) {
            return StringUtils.isNotBlank((CharSequence)this.getPersonalToken());
        }
        if (LoginModeEnum.DEDICATED.getLabel().equals(this.getLoginType())) {
            return true;
        }
        if (LoginModeEnum.INTL_ACCESS_KEY.getLabel().equals(this.getLoginType())) {
            return StringUtils.isNotBlank((CharSequence)this.getAccessKey()) && StringUtils.isNotBlank((CharSequence)this.getSecretKey());
        }
        return false;
    }

    @Generated
    public String getLoginType() {
        return this.loginType;
    }

    @Generated
    public String getAccessKey() {
        return this.accessKey;
    }

    @Generated
    public String getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getOrgId() {
        return this.orgId;
    }

    @Generated
    public String getPersonalToken() {
        return this.personalToken;
    }

    @Generated
    public String getRegionEnv() {
        return this.regionEnv;
    }

    @Generated
    public String getLoginDedicatedType() {
        return this.loginDedicatedType;
    }

    @Generated
    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    @Generated
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Generated
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    @Generated
    public void setPersonalToken(String personalToken) {
        this.personalToken = personalToken;
    }

    @Generated
    public void setRegionEnv(String regionEnv) {
        this.regionEnv = regionEnv;
    }

    @Generated
    public void setLoginDedicatedType(String loginDedicatedType) {
        this.loginDedicatedType = loginDedicatedType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginParams)) {
            return false;
        }
        LoginParams other = (LoginParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$loginType = this.getLoginType();
        String other$loginType = other.getLoginType();
        if (this$loginType == null ? other$loginType != null : !this$loginType.equals(other$loginType)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$personalToken = this.getPersonalToken();
        String other$personalToken = other.getPersonalToken();
        if (this$personalToken == null ? other$personalToken != null : !this$personalToken.equals(other$personalToken)) {
            return false;
        }
        String this$regionEnv = this.getRegionEnv();
        String other$regionEnv = other.getRegionEnv();
        if (this$regionEnv == null ? other$regionEnv != null : !this$regionEnv.equals(other$regionEnv)) {
            return false;
        }
        String this$loginDedicatedType = this.getLoginDedicatedType();
        String other$loginDedicatedType = other.getLoginDedicatedType();
        return !(this$loginDedicatedType == null ? other$loginDedicatedType != null : !this$loginDedicatedType.equals(other$loginDedicatedType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoginParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $loginType = this.getLoginType();
        result = result * 59 + ($loginType == null ? 43 : $loginType.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $personalToken = this.getPersonalToken();
        result = result * 59 + ($personalToken == null ? 43 : $personalToken.hashCode());
        String $regionEnv = this.getRegionEnv();
        result = result * 59 + ($regionEnv == null ? 43 : $regionEnv.hashCode());
        String $loginDedicatedType = this.getLoginDedicatedType();
        result = result * 59 + ($loginDedicatedType == null ? 43 : $loginDedicatedType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LoginParams(loginType=" + this.getLoginType() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", userName=" + this.getUserName() + ", orgId=" + this.getOrgId() + ", personalToken=" + this.getPersonalToken() + ", regionEnv=" + this.getRegionEnv() + ", loginDedicatedType=" + this.getLoginDedicatedType() + ")";
    }

    @Generated
    public LoginParams() {
    }

    @Generated
    public LoginParams(String loginType, String accessKey, String secretKey, String userName, String orgId, String personalToken, String regionEnv, String loginDedicatedType) {
        this.loginType = loginType;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.userName = userName;
        this.orgId = orgId;
        this.personalToken = personalToken;
        this.regionEnv = regionEnv;
        this.loginDedicatedType = loginDedicatedType;
    }
}

