/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.core.websocket;

import com.alibabacloud.intellij.qoder.core.websocket.CosyMessageJsonHandler;
import com.alibabacloud.intellij.qoder.core.websocket.CosyWebSocketMessageConsumer;
import com.alibabacloud.intellij.qoder.core.websocket.CosyWebSocketMessageHandler;
import java.util.Collection;
import java.util.Map;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueHandler;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;

public class CosyWebSocketLauncherBuilder<T>
extends Launcher.Builder<T> {
    protected Session session;

    public Collection<Object> getLocalServices() {
        return this.localServices;
    }

    public CosyWebSocketLauncherBuilder<T> setSession(Session session) {
        this.session = session;
        return this;
    }

    public Launcher<T> create() {
        if (this.localServices == null) {
            throw new IllegalStateException("Local service must be configured.");
        }
        if (this.remoteInterfaces == null) {
            throw new IllegalStateException("Remote interface must be configured.");
        }
        MessageJsonHandler jsonHandler = this.createJsonHandler();
        RemoteEndpoint remoteEndpoint = this.createRemoteEndpoint(jsonHandler);
        this.addMessageHandlers(jsonHandler, remoteEndpoint);
        Object remoteProxy = this.createProxy(remoteEndpoint);
        return this.createLauncher(null, remoteProxy, remoteEndpoint, null);
    }

    protected MessageJsonHandler createJsonHandler() {
        Map supportedMethods = this.getSupportedMethods();
        return this.configureGson != null ? new CosyMessageJsonHandler(supportedMethods, this.configureGson) : new CosyMessageJsonHandler(supportedMethods);
    }

    protected RemoteEndpoint createRemoteEndpoint(MessageJsonHandler jsonHandler) {
        CosyWebSocketMessageConsumer outgoingMessageStream = new CosyWebSocketMessageConsumer(this.session, jsonHandler);
        Endpoint localEndpoint = ServiceEndpoints.toEndpoint((Collection)this.localServices);
        RemoteEndpoint remoteEndpoint = this.exceptionHandler == null ? new RemoteEndpoint((MessageConsumer)outgoingMessageStream, localEndpoint) : new RemoteEndpoint((MessageConsumer)outgoingMessageStream, localEndpoint, this.exceptionHandler);
        jsonHandler.setMethodProvider((MethodProvider)remoteEndpoint);
        this.wrapMessageConsumer((MessageConsumer)remoteEndpoint);
        return remoteEndpoint;
    }

    protected void addMessageHandlers(MessageJsonHandler jsonHandler, RemoteEndpoint remoteEndpoint) {
        MessageConsumer messageConsumer = this.wrapMessageConsumer((MessageConsumer)remoteEndpoint);
        this.session.addMessageHandler((MessageHandler)new CosyWebSocketMessageHandler(messageConsumer, jsonHandler, (MessageIssueHandler)remoteEndpoint));
    }
}

