/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor;

import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.editor.CosyInlayRenderer;
import com.alibabacloud.intellij.qoder.editor.model.CosyEditorInlayItem;
import com.alibabacloud.intellij.qoder.editor.model.InlayCompletionRequest;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ActionUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.alibabacloud.intellij.qoder.util.KeyboardUtil;
import com.alibabacloud.intellij.qoder.util.ReflectUtil;
import com.alibabacloud.intellij.qoder.util.RenderUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosyDefaultInlayRenderer
implements CosyInlayRenderer {
    private static final String INLAY_TEXT_WITHOUT_BACKGROUND_FIELD = "INLAY_TEXT_WITHOUT_BACKGROUND";
    private static final TextAttributes DEFAULT_INLAY_TEXT_THEME = new TextAttributes();
    private static final int TOOLTIPS_OFFSET = 16;
    private static final String ACCEPT_SBY_LINE_TOOLTIPS = CosyBundle.message("completion.apply.partial.tooltips", new Object[0]);
    @NotNull
    private final List<String> lines;
    private final List<String> tooltipTexts;
    @NotNull
    private final String content;
    @NotNull
    private final TextAttributes textAttributes;
    @Nullable
    private Inlay<CosyInlayRenderer> inlay;
    private int cachedWidth;
    private int cachedHeight;
    private int lineMaxLength;
    private int totalLineCount;
    private CosyEditorInlayItem item;
    private long lastUpdateDisplayTimeLength;

    public CosyDefaultInlayRenderer(@NotNull CosyEditorInlayItem item, @NotNull Editor editor, @NotNull InlayCompletionRequest request, @NotNull List<String> lines, int lineStartIndex, int totalLineCount, int lineMaxLength) {
        if (item == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(1);
        }
        if (request == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(2);
        }
        if (lines == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(3);
        }
        this.cachedWidth = -1;
        this.cachedHeight = -1;
        this.lastUpdateDisplayTimeLength = 0L;
        this.item = item;
        this.lines = this.processLines(request, lines);
        this.lineMaxLength = lineMaxLength;
        this.totalLineCount = totalLineCount;
        this.content = org.apache.commons.lang3.StringUtils.join(this.lines, (String)"\n");
        this.textAttributes = CosyDefaultInlayRenderer.getEdtorTextAttributes(editor);
        this.tooltipTexts = this.createTooltipText(lineStartIndex);
    }

    public int calcHeightInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(4);
        }
        if (this.cachedHeight < 0) {
            this.cachedHeight = inlay.getEditor().getLineHeight() * this.lines.size();
            return this.cachedHeight;
        }
        return this.cachedHeight;
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Editor editor;
        if (inlay == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(5);
        }
        if (g == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(6);
        }
        if (targetRegion == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(7);
        }
        if (textAttributes == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(8);
        }
        if ((editor = inlay.getEditor()).isDisposed()) {
            return;
        }
        Rectangle region = targetRegion;
        if (this.content.trim().isEmpty() || this.lines.isEmpty()) {
            return;
        }
        Rectangle clipBounds = g.getClipBounds();
        Graphics2D g2 = (Graphics2D)g.create();
        GraphicsUtil.setupAAPainting((Graphics)g2);
        Font font = FontUtil.getFont(editor, this.content + org.apache.commons.lang3.StringUtils.join((Object[])new List[]{this.tooltipTexts}));
        g2.setFont(font);
        FontMetrics metrics = FontUtil.fontMetrics(editor, font);
        double lineHeight = editor.getLineHeight();
        double fontBaseline = Math.ceil(font.createGlyphVector(metrics.getFontRenderContext(), "lAba").getVisualBounds().getHeight());
        double linePadding = (lineHeight - fontBaseline) / 2.0;
        double offsetX = region.getX();
        double offsetY = region.getY() + fontBaseline + linePadding;
        int lineOffset = 0;
        g2.setClip(clipBounds != null && !clipBounds.equals(region) ? region.createIntersection(clipBounds) : region);
        for (int i = 0; i < this.lines.size(); ++i) {
            String tooltipText;
            String line = this.lines.get(i);
            RenderUtil.renderBackground(g2, this.textAttributes, offsetX, region.getY() + (double)lineOffset, region.getWidth(), lineHeight);
            g2.setColor(this.textAttributes.getForegroundColor());
            g2.drawString(line, (float)offsetX, (float)(offsetY + (double)lineOffset));
            if (i < this.tooltipTexts.size() && (tooltipText = this.tooltipTexts.get(i)) != null) {
                g2.drawString(tooltipText, (float)(this.lineMaxLength + 16), (float)(offsetY + (double)lineOffset));
            }
            if (editor instanceof EditorImpl) {
                RenderUtil.renderEffects(g2, offsetX, offsetY + (double)lineOffset, metrics.stringWidth(line), ((EditorImpl)editor).getCharHeight(), ((EditorImpl)editor).getDescent(), this.textAttributes, font);
            }
            lineOffset = (int)((double)lineOffset + lineHeight);
        }
        g2.dispose();
        this.item.setRendered(true);
        if (this.item.getFirstDisplayTimeMs() == 0L) {
            this.item.setFirstDisplayTimeMs(System.currentTimeMillis());
        }
        if (!(this.item.isAccepted() || this.lastUpdateDisplayTimeLength != 0L && this.lastUpdateDisplayTimeLength >= (long)this.item.getContent().length())) {
            this.lastUpdateDisplayTimeLength = this.item.getContent().length();
            this.item.setDisplayTimeMs(System.currentTimeMillis());
        }
    }

    @Nullable
    @NonNls
    public String getContextMenuGroupId(@NotNull Inlay inlay) {
        if (inlay == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(9);
        }
        return "cosy.inlayContextMenu";
    }

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(10);
        }
        if (this.cachedWidth < 0) {
            if (this.totalLineCount <= 1) {
                this.cachedWidth = FontUtil.calculateWidth(inlay.getEditor(), this.content, this.lines);
            } else {
                String shortcutText = KeyboardUtil.getShortcutText(ActionUtil.getActionId("ApplyCosyInlayByLineCompletion"), "");
                String tips = String.format("%s %s", shortcutText, ACCEPT_SBY_LINE_TOOLTIPS);
                String maxLine = null;
                for (String tip : this.tooltipTexts) {
                    if (maxLine != null && tip.length() <= maxLine.length()) continue;
                    maxLine = tip;
                }
                this.cachedWidth = this.lineMaxLength;
                FontMetrics metrics = FontUtil.fontMetrics(inlay.getEditor(), FontUtil.getFont(inlay.getEditor(), tips));
                int tipWidth = maxLine == null ? 0 : metrics.stringWidth(maxLine) + 16;
                this.cachedWidth += tipWidth;
            }
        }
        return this.cachedWidth;
    }

    private static TextAttributes getEdtorTextAttributes(@NotNull Editor editor) {
        TextAttributes customAttributes;
        if (editor == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(11);
        }
        EditorColorsScheme scheme = editor.getColorsScheme();
        TextAttributes themeAttributes = null;
        try {
            TextAttributesKey key = (TextAttributesKey)ReflectUtil.getStaticField(DefaultLanguageHighlighterColors.class, INLAY_TEXT_WITHOUT_BACKGROUND_FIELD);
            themeAttributes = key != null ? scheme.getAttributes(key) : DEFAULT_INLAY_TEXT_THEME;
        }
        catch (Exception e) {
            themeAttributes = DEFAULT_INLAY_TEXT_THEME;
        }
        Color userColor = null;
        if (userColor == null && themeAttributes != null && themeAttributes.getForegroundColor() != null) {
            return themeAttributes;
        }
        TextAttributes textAttributes = customAttributes = themeAttributes != null ? themeAttributes.clone() : new TextAttributes();
        if (userColor != null) {
            customAttributes.setForegroundColor(userColor);
        }
        if (customAttributes.getForegroundColor() == null) {
            customAttributes.setForegroundColor((Color)JBColor.GRAY);
        }
        return customAttributes;
    }

    @Override
    @NotNull
    public List<String> getContentLines() {
        List<String> list = this.lines;
        if (list == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public Inlay<CosyInlayRenderer> getInlay() {
        return this.inlay;
    }

    public void setInlay(@NotNull Inlay<CosyInlayRenderer> inlay) {
        if (inlay == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(13);
        }
        this.inlay = inlay;
    }

    private List<String> createTooltipText(int lineStartIndex) {
        ArrayList<String> tooltips = new ArrayList<String>();
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting == null || this.totalLineCount <= 1) {
            return tooltips;
        }
        String shortcutText = KeyboardUtil.getShortcutText(ActionUtil.getActionId("ApplyCosyInlayByLineCompletion"), "");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)shortcutText)) {
            return tooltips;
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            if (lineStartIndex + i != 0) continue;
            tooltips.add(String.format("%s %s", shortcutText, ACCEPT_SBY_LINE_TOOLTIPS));
            break;
        }
        return tooltips;
    }

    private List<String> processLines(InlayCompletionRequest request, List<String> lines) {
        lines = StringUtils.replaceHeadTabs(lines, false, request.getTabWidth());
        lines = lines.stream().map(line -> line.replace("<|cursor|>", "")).collect(Collectors.toList());
        return lines;
    }

    @NotNull
    @Generated
    public List<String> getLines() {
        List<String> list = this.lines;
        if (list == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Generated
    public List<String> getTooltipTexts() {
        return this.tooltipTexts;
    }

    @NotNull
    @Generated
    public String getContent() {
        String string = this.content;
        if (string == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    @Generated
    public TextAttributes getTextAttributes() {
        TextAttributes textAttributes = this.textAttributes;
        if (textAttributes == null) {
            CosyDefaultInlayRenderer.$$$reportNull$$$0(16);
        }
        return textAttributes;
    }

    @Generated
    public int getCachedWidth() {
        return this.cachedWidth;
    }

    @Generated
    public int getCachedHeight() {
        return this.cachedHeight;
    }

    @Generated
    public int getLineMaxLength() {
        return this.lineMaxLength;
    }

    @Generated
    public int getTotalLineCount() {
        return this.totalLineCount;
    }

    @Generated
    public CosyEditorInlayItem getItem() {
        return this.item;
    }

    @Generated
    public long getLastUpdateDisplayTimeLength() {
        return this.lastUpdateDisplayTimeLength;
    }

    @Generated
    public void setCachedWidth(int cachedWidth) {
        this.cachedWidth = cachedWidth;
    }

    @Generated
    public void setCachedHeight(int cachedHeight) {
        this.cachedHeight = cachedHeight;
    }

    @Generated
    public void setLineMaxLength(int lineMaxLength) {
        this.lineMaxLength = lineMaxLength;
    }

    @Generated
    public void setTotalLineCount(int totalLineCount) {
        this.totalLineCount = totalLineCount;
    }

    @Generated
    public void setItem(CosyEditorInlayItem item) {
        this.item = item;
    }

    @Generated
    public void setLastUpdateDisplayTimeLength(long lastUpdateDisplayTimeLength) {
        this.lastUpdateDisplayTimeLength = lastUpdateDisplayTimeLength;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CosyDefaultInlayRenderer)) {
            return false;
        }
        CosyDefaultInlayRenderer other = (CosyDefaultInlayRenderer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$lines = this.getLines();
        List<String> other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        List<String> this$tooltipTexts = this.getTooltipTexts();
        List<String> other$tooltipTexts = other.getTooltipTexts();
        if (this$tooltipTexts == null ? other$tooltipTexts != null : !((Object)this$tooltipTexts).equals(other$tooltipTexts)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        TextAttributes this$textAttributes = this.getTextAttributes();
        TextAttributes other$textAttributes = other.getTextAttributes();
        if (this$textAttributes == null ? other$textAttributes != null : !this$textAttributes.equals(other$textAttributes)) {
            return false;
        }
        Inlay<CosyInlayRenderer> this$inlay = this.getInlay();
        Inlay<CosyInlayRenderer> other$inlay = other.getInlay();
        if (this$inlay == null ? other$inlay != null : !this$inlay.equals(other$inlay)) {
            return false;
        }
        if (this.getCachedWidth() != other.getCachedWidth()) {
            return false;
        }
        if (this.getCachedHeight() != other.getCachedHeight()) {
            return false;
        }
        if (this.getLineMaxLength() != other.getLineMaxLength()) {
            return false;
        }
        if (this.getTotalLineCount() != other.getTotalLineCount()) {
            return false;
        }
        CosyEditorInlayItem this$item = this.getItem();
        CosyEditorInlayItem other$item = other.getItem();
        if (this$item == null ? other$item != null : !((Object)this$item).equals(other$item)) {
            return false;
        }
        return this.getLastUpdateDisplayTimeLength() == other.getLastUpdateDisplayTimeLength();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CosyDefaultInlayRenderer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        List<String> $tooltipTexts = this.getTooltipTexts();
        result = result * 59 + ($tooltipTexts == null ? 43 : ((Object)$tooltipTexts).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        TextAttributes $textAttributes = this.getTextAttributes();
        result = result * 59 + ($textAttributes == null ? 43 : $textAttributes.hashCode());
        Inlay<CosyInlayRenderer> $inlay = this.getInlay();
        result = result * 59 + ($inlay == null ? 43 : $inlay.hashCode());
        result = result * 59 + this.getCachedWidth();
        result = result * 59 + this.getCachedHeight();
        result = result * 59 + this.getLineMaxLength();
        result = result * 59 + this.getTotalLineCount();
        CosyEditorInlayItem $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        long $lastUpdateDisplayTimeLength = this.getLastUpdateDisplayTimeLength();
        result = result * 59 + (int)($lastUpdateDisplayTimeLength >>> 32 ^ $lastUpdateDisplayTimeLength);
        return result;
    }

    @Generated
    public String toString() {
        return "CosyDefaultInlayRenderer(lines=" + this.getLines() + ", tooltipTexts=" + this.getTooltipTexts() + ", content=" + this.getContent() + ", textAttributes=" + this.getTextAttributes() + ", inlay=" + this.getInlay() + ", cachedWidth=" + this.getCachedWidth() + ", cachedHeight=" + this.getCachedHeight() + ", lineMaxLength=" + this.getLineMaxLength() + ", totalLineCount=" + this.getTotalLineCount() + ", item=" + this.getItem() + ", lastUpdateDisplayTimeLength=" + this.getLastUpdateDisplayTimeLength() + ")";
    }

    static {
        DEFAULT_INLAY_TEXT_THEME.setForegroundColor((Color)new JBColor(new Color(0x7A7A7A), new Color(0x7A7A7A)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegion";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/qoder/editor/CosyDefaultInlayRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/qoder/editor/CosyDefaultInlayRenderer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentLines";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcHeightInPixels";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContextMenuGroupId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcWidthInPixels";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEdtorTextAttributes";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setInlay";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

