/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor;

import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.completion.CosyCompletionService;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.editor.CosyDefaultInlayRenderer;
import com.alibabacloud.intellij.qoder.editor.CosyInlayManager;
import com.alibabacloud.intellij.qoder.editor.CosyInlayRenderer;
import com.alibabacloud.intellij.qoder.editor.inline.InlineEditUtil;
import com.alibabacloud.intellij.qoder.editor.model.CompletionTriggerConfig;
import com.alibabacloud.intellij.qoder.editor.model.CosyEditorInlayItem;
import com.alibabacloud.intellij.qoder.editor.model.CosyEditorInlayList;
import com.alibabacloud.intellij.qoder.editor.model.InlayCompletionRequest;
import com.alibabacloud.intellij.qoder.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.qoder.editor.request.InlayPreviewRequest;
import com.alibabacloud.intellij.qoder.editor.request.NextCompletionRequest;
import com.alibabacloud.intellij.qoder.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.service.model.TextChangeContext;
import com.alibabacloud.intellij.qoder.service.model.TimestampEnum;
import com.alibabacloud.intellij.qoder.util.ApplicationUtil;
import com.alibabacloud.intellij.qoder.util.CompletionUtil;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.LanguageUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;

public class CosyInlayManagerImpl
implements CosyInlayManager {
    private static final Logger LOGGER = Logger.getInstance(CosyInlayManagerImpl.class);
    private static final long INLAY_COMPLETION_MANUAL_TYPE_TRIGGER_DELAY = 75L;
    private static final long INLAY_COMPLETION_TOGGLE_DELAY = 75L;
    private static final long REQUEST_TIMEOUT = 10000L;

    @Override
    @RequiresEdt
    public boolean isAvailable(@NotNull Editor editor) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(0);
        }
        if (editor.isDisposed()) {
            return false;
        }
        Boolean isAvailable = (Boolean)CosyCacheKeys.KEY_EDITOR_INLAY_SUPPORTED.get((UserDataHolder)editor);
        if (isAvailable == null) {
            isAvailable = !(editor instanceof EditorWindow) && !(editor instanceof ImaginaryEditor) && (!(editor instanceof EditorEx) || !((EditorEx)editor).isEmbeddedIntoDialogWrapper()) && !editor.isViewer() && !editor.isOneLineMode() && ApplicationUtil.isSupportedIDE(editor.getProject()) && this.isAvailableFile(editor);
            CosyCacheKeys.KEY_EDITOR_INLAY_SUPPORTED.set((UserDataHolder)editor, (Object)isAvailable);
        }
        return isAvailable;
    }

    private boolean isAvailableFile(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        return file != null && !(file instanceof PsiBinaryFile) && !file.getFileType().isBinary() && !FileUtil.isLargeFile(file.getVirtualFile());
    }

    @Override
    public void editorChanged(@NotNull CompletionTriggerConfig config, @NotNull Editor editor) {
        if (config == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(3);
        }
        int caretOffset = EditorUtil.getCaretOffset(editor);
        this.editorChanged(config, editor, caretOffset, CompletionTriggerModeEnum.AUTO);
    }

    @Override
    public void editorChanged(@NotNull CompletionTriggerConfig config, @NotNull Editor editor, CompletionTriggerModeEnum triggerMode) {
        if (config == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(5);
        }
        int caretOffset = EditorUtil.getCaretOffset(editor);
        this.editorChanged(config, editor, caretOffset, triggerMode);
    }

    @Override
    public void editorChanged(@NotNull CompletionTriggerConfig config, @NotNull Editor editor, int offset, CompletionTriggerModeEnum triggerMode) {
        Project project;
        if (config == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(7);
        }
        if (!Cosy.INSTANCE.checkCosy(project = editor.getProject(), true)) {
            return;
        }
        if (CompletionTriggerModeEnum.ACCEPT.getName().equals(triggerMode.getName())) {
            NextCompletionRequest.build().triggerNext(editor);
        } else {
            InlineEditUtil.disposeAllInline(editor, InlayDisposeEventEnum.TYPING);
            InlayPreviewRequest.build().generate(config, editor, triggerMode);
        }
    }

    @Override
    public void toggleInlayCompletion(@NotNull Editor editor, int direction, int maxCount) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(8);
        }
        CosyEditorInlayList list = (CosyEditorInlayList)CosyCacheKeys.KEY_COMPLETION_INLAY_ITEMS.get((UserDataHolder)editor);
        InlayCompletionRequest oldRequest = (InlayCompletionRequest)CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.get((UserDataHolder)editor);
        if (list == null || list.isEmpty() || oldRequest == null) {
            return;
        }
        this.disposeInlays(editor, InlayDisposeEventEnum.TOGGLE_COMPLETION);
        if (!Cosy.INSTANCE.checkCosy(editor.getProject(), true)) {
            return;
        }
        if (maxCount > list.size()) {
            InlayPreviewRequest.build().toggle(editor, oldRequest);
        } else {
            CosyEditorInlayItem item = list.select(list.getSelectIndex() + direction);
            if (item != null) {
                this.renderInlayCompletionItem(oldRequest, item);
            }
        }
    }

    @Override
    public void renderInlayCompletionItem(InlayCompletionRequest request, CosyEditorInlayItem item) {
        Editor editor = request.getEditor();
        InlayModel inlayModel = editor.getInlayModel();
        ArrayList insertedInlays = new ArrayList();
        int index = 0;
        int lineStartIndex = 0;
        int totalLineCount = item.getTotalLineCount();
        int lineMaxLength = CompletionUtil.getInlayChunkMaxPixelLength(editor, request, item);
        try {
            for (int i = 0; i < item.getChunks().size(); ++i) {
                CosyEditorInlayItem.EditorInlayItemChunk inlay = item.getChunks().get(i);
                if (i == item.getChunks().size() - 1 && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)org.apache.commons.lang3.StringUtils.join(inlay.getCompletionLines(), (String)"\n").trim())) continue;
                int finalLineStartIndex = lineStartIndex;
                int finalIndex = index++;
                ApplicationManager.getApplication().runReadAction(() -> {
                    CosyDefaultInlayRenderer renderer = new CosyDefaultInlayRenderer(item, editor, request, inlay.getCompletionLines(), finalLineStartIndex, totalLineCount, lineMaxLength);
                    Inlay editorInlay = null;
                    switch (inlay.getType()) {
                        case Inline: {
                            editorInlay = inlayModel.addInlineElement(item.getEditorOffset(), true, Integer.MAX_VALUE - finalIndex, (EditorCustomElementRenderer)renderer);
                            break;
                        }
                        case AfterLineEnd: {
                            editorInlay = inlayModel.addAfterLineEndElement(item.getEditorOffset(), true, (EditorCustomElementRenderer)renderer);
                            break;
                        }
                        case Block: {
                            editorInlay = inlayModel.addBlockElement(item.getEditorOffset(), true, false, Integer.MAX_VALUE - finalIndex, (EditorCustomElementRenderer)renderer);
                        }
                    }
                    if (editorInlay != null) {
                        renderer.setInlay(editorInlay);
                    }
                    insertedInlays.add(editorInlay);
                });
                lineStartIndex += inlay.getCompletionLines().size();
            }
        }
        catch (Exception e) {
            LOGGER.warn("render inlay error:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void disposeInlays(@NotNull Editor editor, InlayDisposeEventEnum disposeAction) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(9);
        }
        this.disposeInlays(editor, disposeAction, null);
    }

    @Override
    public void disposeInlays(@NotNull Editor editor, InlayDisposeEventEnum disposeAction, String commandName) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(10);
        }
        List<CosyInlayRenderer> renderers = this.collectInlays(editor, 0, editor.getDocument().getTextLength());
        this.clearInlays(renderers);
        CosyEditorInlayList inlayList = (CosyEditorInlayList)CosyCacheKeys.KEY_COMPLETION_INLAY_ITEMS.get((UserDataHolder)editor);
        if (disposeAction != InlayDisposeEventEnum.GENERATING && disposeAction != InlayDisposeEventEnum.TOGGLE_COMPLETION) {
            this.cancelCompletion(editor);
            InlayCompletionRequest oldRequest = (InlayCompletionRequest)CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.get((UserDataHolder)editor);
            if (oldRequest != null) {
                oldRequest.cancel();
                Disposer.dispose((Disposable)oldRequest);
                CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.set((UserDataHolder)editor, null);
                CosyCacheKeys.KEY_COMPLETION_LATEST_PROJECT_REQUEST.set((UserDataHolder)editor.getProject(), null);
            }
            CosyCacheKeys.KEY_COMPLETION_INLAY_ITEMS.set((UserDataHolder)editor, null);
        }
        if (!renderers.isEmpty()) {
            TelemetryService.getInstance().disposeCompletion(disposeAction, editor, inlayList, commandName);
        }
    }

    private void clearInlays(List<CosyInlayRenderer> renderers) {
        for (CosyInlayRenderer renderer : renderers) {
            Inlay<?> inlay = renderer.getInlay();
            if (inlay == null) continue;
            ApplicationManager.getApplication().runReadAction(() -> Disposer.dispose((Disposable)inlay));
        }
    }

    @Override
    public boolean hasCompletionInlays(@NotNull Editor editor) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(11);
        }
        if (!this.isAvailable(editor)) {
            return false;
        }
        return this.countCompletionInlays(editor, TextRange.from((int)0, (int)editor.getDocument().getTextLength()), true, true, true, true) > 0;
    }

    @Override
    public int countCompletionInlays(@NotNull Editor editor, @NotNull TextRange searchRange, boolean inlineInlays, boolean afterLineEndInlays, boolean blockInlays, boolean matchInLeadingWhitespace) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(12);
        }
        if (searchRange == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(13);
        }
        if (!this.isAvailable(editor)) {
            return 0;
        }
        int startOffset = searchRange.getStartOffset();
        int endOffset = searchRange.getEndOffset();
        InlayModel inlayModel = editor.getInlayModel();
        int totalCount = 0;
        if (inlineInlays) {
            totalCount = (int)((long)totalCount + inlayModel.getInlineElementsInRange(startOffset, endOffset).stream().filter(inlay -> {
                if (!(inlay.getRenderer() instanceof CosyInlayRenderer)) {
                    return false;
                }
                if (matchInLeadingWhitespace) {
                    return true;
                }
                List<String> lines = ((CosyInlayRenderer)inlay.getRenderer()).getContentLines();
                if (lines.isEmpty()) {
                    return false;
                }
                int whitespaceEnd = inlay.getOffset() + StringUtils.countHeadWhitespaceLength(lines.get(0));
                return searchRange.getEndOffset() >= whitespaceEnd;
            }).count());
        }
        if (blockInlays) {
            totalCount = (int)((long)totalCount + inlayModel.getBlockElementsInRange(startOffset, endOffset).stream().filter(inlay -> inlay.getRenderer() instanceof CosyInlayRenderer).count());
        }
        if (afterLineEndInlays) {
            totalCount = (int)((long)totalCount + inlayModel.getAfterLineEndElementsInRange(startOffset, endOffset).stream().filter(inlay -> inlay.getRenderer() instanceof CosyInlayRenderer).count());
        }
        return totalCount;
    }

    public List<CosyInlayRenderer> collectInlays(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(14);
        }
        InlayModel model = editor.getInlayModel();
        ArrayList inlays = new ArrayList();
        inlays.addAll(model.getInlineElementsInRange(startOffset, endOffset));
        inlays.addAll(model.getAfterLineEndElementsInRange(startOffset, endOffset));
        inlays.addAll(model.getBlockElementsInRange(startOffset, endOffset));
        ArrayList<CosyInlayRenderer> renderers = new ArrayList<CosyInlayRenderer>();
        for (Inlay inlay : inlays) {
            if (!(inlay.getRenderer() instanceof CosyInlayRenderer)) continue;
            renderers.add((CosyInlayRenderer)inlay.getRenderer());
        }
        return renderers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresEdt
    public boolean applyCompletion(@NotNull Editor editor, Integer lineCount) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(15);
        }
        if (editor.isDisposed()) {
            LOGGER.warn("editor already disposed");
            return false;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            LOGGER.warn("project disposed or null: " + project);
            return false;
        }
        if (this.isProcessing(editor)) {
            LOGGER.warn("can't apply inlays while processing");
            return false;
        }
        Key<CosyEditorInlayList> key = CosyCacheKeys.KEY_COMPLETION_INLAY_ITEMS;
        synchronized (key) {
            CosyEditorInlayList list = (CosyEditorInlayList)CosyCacheKeys.KEY_COMPLETION_INLAY_ITEMS.get((UserDataHolder)editor);
            if (list == null) {
                return false;
            }
            TelemetryService.getInstance().updateTimestamp(TimestampEnum.ACCEPT_TIMESTAMP_TYPE.getType(), System.currentTimeMillis());
            this.disposeInlays(editor, InlayDisposeEventEnum.ACCEPTED);
            CosyEditorInlayItem inlayItem = list.getCurrentInlayItem();
            if (inlayItem != null) {
                this.applyCompletion(project, editor, inlayItem, lineCount);
            }
            return true;
        }
    }

    @Override
    @RequiresEdt
    public void applyCompletion(@NotNull Project project, @NotNull Editor editor, @NotNull CosyEditorInlayItem inlayItem, Integer lineCount) {
        if (project == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(17);
        }
        if (inlayItem == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(18);
        }
        if (project.isDisposed()) {
            return;
        }
        String content = null;
        if (lineCount != null) {
            content = inlayItem.getLines(lineCount);
        }
        if (content == null) {
            content = inlayItem.getContent();
        }
        content = this.getCompletionInsertContent(inlayItem, editor, content);
        this.insertInlayContent(editor, content);
        inlayItem.setAccepted(true);
        int startLineNumber = editor.getDocument().getLineNumber(inlayItem.getEditorOffset());
        String filePath = EditorUtil.getEditorFilePath(editor);
        TelemetryService.getInstance().telemetryTextChange(new TextChangeContext(editor.getProject(), filePath, content, startLineNumber, true, LanguageUtil.getLanguageByFilePath(filePath), "completion"));
        TelemetryService.getInstance().applyCompletion(editor, inlayItem, lineCount == null ? inlayItem.getTotalLineCount() : lineCount.intValue(), content.length());
    }

    private void insertInlayContent(@NotNull Editor editor, String content) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(19);
        }
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)"Apply Tongyi Inline Suggestion", (String)"TONGYI", () -> {
            int caretOffset;
            String code = content;
            Document document = editor.getDocument();
            if (document instanceof DocumentImpl && !((DocumentImpl)document).acceptsSlashR()) {
                code = org.apache.commons.lang3.StringUtils.remove((String)code, (char)'\r');
            }
            if ((caretOffset = (code = org.apache.commons.lang3.StringUtils.stripEnd((String)code, (String)" \t\n")).indexOf("<|cursor|>")) < 0) {
                caretOffset = code.length();
            } else {
                code = code.replace("<|cursor|>", "");
            }
            int startOffset = editor.getCaretModel().getOffset();
            document.insertString(startOffset, (CharSequence)code);
            editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + caretOffset);
        }, (PsiFile[])new PsiFile[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean applyCompletionByLine(@NotNull Editor editor) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(20);
        }
        if (editor.isDisposed()) {
            LOGGER.warn("editor already disposed");
            return false;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            LOGGER.warn("project disposed or null: " + project);
            return false;
        }
        if (this.isProcessing(editor)) {
            LOGGER.warn("can't apply inlays while processing");
            return false;
        }
        Key<CosyEditorInlayList> key = CosyCacheKeys.KEY_COMPLETION_INLAY_ITEMS;
        synchronized (key) {
            String line;
            CosyEditorInlayList list = (CosyEditorInlayList)CosyCacheKeys.KEY_COMPLETION_INLAY_ITEMS.get((UserDataHolder)editor);
            if (list == null) {
                return false;
            }
            TelemetryService.getInstance().updateTimestamp(TimestampEnum.ACCEPT_TIMESTAMP_TYPE.getType(), System.currentTimeMillis());
            List<CosyInlayRenderer> renderers = this.collectInlays(editor, 0, editor.getDocument().getTextLength());
            this.clearInlays(renderers);
            CosyEditorInlayItem inlayItem = list.getCurrentAndRemoveOtherInlayItem();
            if (inlayItem != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(line = inlayItem.refactorByAcceptLine()))) {
                line = this.getCompletionInsertContent(inlayItem, editor, line);
                this.insertInlayContent(editor, line);
                int startLineNumber = editor.getDocument().getLineNumber(inlayItem.getEditorOffset());
                String filePath = EditorUtil.getEditorFilePath(editor);
                TelemetryService.getInstance().telemetryTextChange(new TextChangeContext(editor.getProject(), filePath, line, startLineNumber, true, LanguageUtil.getLanguageByFilePath(filePath), "completion"));
                TelemetryService.getInstance().applyCompletion(editor, inlayItem, 1, line.length());
                if (inlayItem.getTotalLineCount() > 0) {
                    InlayCompletionRequest oldRequest = (InlayCompletionRequest)CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.get((UserDataHolder)editor);
                    inlayItem.setEditorOffset(editor.getCaretModel().getOffset());
                    oldRequest.setCursorOffset(editor.getCaretModel().getOffset());
                    oldRequest.getParams().setFileContent(editor.getDocument().getText());
                    LogicalPosition position = editor.getCaretModel().getLogicalPosition();
                    int column = editor.getCaretModel().getOffset() - editor.getDocument().getLineStartOffset(position.line);
                    column = column > 0 ? column : position.column;
                    oldRequest.getParams().setPosition(new Position(position.line, column));
                    this.renderInlayCompletionItem(oldRequest, inlayItem);
                } else {
                    this.disposeInlays(editor, InlayDisposeEventEnum.ACCEPTED);
                }
                inlayItem.setAccepted(true);
            }
            return true;
        }
    }

    private String getCompletionInsertContent(CosyEditorInlayItem inlayItem, Editor editor, String content) {
        if (inlayItem.isAccepted() && !((String)content).startsWith("\n")) {
            String linePrefix = CompletionUtil.getCursorPrefix(editor, editor.getCaretModel().getOffset());
            String lineSuffix = CompletionUtil.getCursorSuffix(editor, editor.getCaretModel().getOffset());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)linePrefix) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)lineSuffix)) {
                content = "\n" + (String)content;
            }
        }
        return content;
    }

    @Override
    public void cancelCompletion(@NotNull Editor editor) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(21);
        }
        CosyCompletionService.getInstance().cancelInlayCompletions(editor.getProject());
    }

    public void dispose() {
    }

    private boolean isProcessing(@NotNull Editor editor) {
        if (editor == null) {
            CosyInlayManagerImpl.$$$reportNull$$$0(22);
        }
        return (Boolean)CosyCacheKeys.KEY_COMPLETION_PROCESSING.get((UserDataHolder)editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchRange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlayItem";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/editor/CosyInlayManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "editorChanged";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "toggleInlayCompletion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "disposeInlays";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "hasCompletionInlays";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "countCompletionInlays";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInlays";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "applyCompletion";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "insertInlayContent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "applyCompletionByLine";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelCompletion";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isProcessing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

