/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor;

import com.alibabacloud.intellij.qoder.editor.BaseCosyEditorChatHintProvider;
import com.alibabacloud.intellij.qoder.util.ReflectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;

public class CosyKotlinEditorChatHintProvider
extends BaseCosyEditorChatHintProvider {
    private static final Logger log = Logger.getInstance(CosyKotlinEditorChatHintProvider.class);
    private static final String FUNCTION_CLASS_NAME_KOTLIN = "org.jetbrains.kotlin.psi.KtNamedFunction";
    private static final String[] FUNCTION_CLASS_NAMES = new String[]{"org.jetbrains.kotlin.psi.KtNamedFunction"};

    @Override
    protected boolean checkIsInvalidMethod(@NotNull PsiElement element) {
        if (element == null) {
            CosyKotlinEditorChatHintProvider.$$$reportNull$$$0(0);
        }
        return CosyKotlinEditorChatHintProvider.isInvalidKotlinMethod(element);
    }

    @Override
    protected String[] getFunctionClassNames() {
        return FUNCTION_CLASS_NAMES;
    }

    private static boolean isInvalidKotlinMethod(@NotNull PsiElement element) {
        if (element == null) {
            CosyKotlinEditorChatHintProvider.$$$reportNull$$$0(1);
        }
        try {
            Method getHasBody = ReflectUtil.getMethod(element.getClass(), "hasBody", new Class[0]);
            if (getHasBody == null) {
                return false;
            }
            Object hasBlockBody = getHasBody.invoke((Object)element, new Object[0]);
            return !BooleanUtils.isTrue((Boolean)((Boolean)hasBlockBody));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.warn("get method error", (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/alibabacloud/intellij/qoder/editor/CosyKotlinEditorChatHintProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIsInvalidMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInvalidKotlinMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

