/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor;

import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.ui.search.model.ActiveFileInfo;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QoderEditorCopyActionHandler
extends EditorActionHandler {
    private static final Logger log = Logger.getInstance(QoderEditorCopyActionHandler.class);
    private final EditorActionHandler originalHandler;

    public QoderEditorCopyActionHandler(EditorActionHandler originalHandler) {
        this.originalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            QoderEditorCopyActionHandler.$$$reportNull$$$0(0);
        }
        if (editor.getEditorKind().equals((Object)EditorKind.MAIN_EDITOR)) {
            try {
                ActiveFileInfo copyInfo;
                SelectionModel selection = editor.getSelectionModel();
                if (selection.hasSelection() && this.needRecordCopy(copyInfo = ActiveFileInfo.getFromEditor(editor))) {
                    CosyCacheKeys.KEY_LAST_EDITOR_COPY.set((UserDataHolder)ApplicationManager.getApplication(), (Object)copyInfo);
                }
            }
            catch (Exception e) {
                log.warn("LingmaEditorCopyActionHandler executeWriteAction error", (Throwable)e);
            }
        }
        if (null != this.originalHandler) {
            this.originalHandler.execute(editor, caret, dataContext);
        }
    }

    private boolean needRecordCopy(ActiveFileInfo copyInfo) {
        return null != copyInfo.getStatLine() && null != copyInfo.getEndLine() && copyInfo.getEndLine() > copyInfo.getStatLine();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/alibabacloud/intellij/qoder/editor/QoderEditorCopyActionHandler", "doExecute"));
    }
}

