/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.action;

import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.InlineEditActionMessage;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.RewriteCodeAction;
import com.alibabacloud.intellij.qoder.editor.action.InlineActionType;
import com.alibabacloud.intellij.qoder.editor.action.InlineEditActionHandler;
import com.alibabacloud.intellij.qoder.editor.model.DiffChangeModel;
import com.alibabacloud.intellij.qoder.editor.model.InlineEditRequest;
import com.alibabacloud.intellij.qoder.editor.model.InlineEditSession;
import com.alibabacloud.intellij.qoder.ui.statusbar.CosyStatusBarWidget;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class NextEditActionHandler
implements InlineEditActionHandler {
    private static final Logger LOG = Logger.getInstance(NextEditActionHandler.class);
    private final Gson gson = new Gson();

    @Override
    public boolean handle(InlineEditActionMessage message) {
        if (message.getProject() == null || !message.getProject().isOpen()) {
            LOG.warn("Project is null or closed");
            return false;
        }
        try {
            int delta;
            InlineEditSession session = (InlineEditSession)CosyCacheKeys.KEY_INLINE_EDIT_SESSION.get((UserDataHolder)message.getProject());
            if (session == null || !message.getSessionId().equals(session.getSessionId())) {
                LOG.warn("Session is null or mismatched");
                return false;
            }
            InlineEditRequest currentRequest = session.getRequestById(message.getRequestId());
            if (currentRequest == null || !currentRequest.getRequestId().equals(message.getRequestId()) || currentRequest.isCanceled()) {
                LOG.warn("Request already canceled or new request initiated");
                return false;
            }
            if (currentRequest.getEditor().isDisposed()) {
                LOG.warn("Editor is disposed");
                return false;
            }
            currentRequest.setCacheRequestId(message.getCacheId());
            RewriteCodeAction item = (RewriteCodeAction)this.gson.fromJson((JsonElement)message.getData(), RewriteCodeAction.class);
            if (item == null || item.getEditRange() == null) {
                LOG.warn("Invalid inline edit item: " + item);
                return false;
            }
            currentRequest.setActionResult(InlineActionType.NEXT_EDIT.getActionType(), item);
            Document document = currentRequest.getEditor().getDocument();
            if (document instanceof DocumentImpl && !((DocumentImpl)document).acceptsSlashR()) {
                item.setContent(StringUtils.remove((String)item.getContent(), (char)'\r'));
            }
            if (0 != (delta = this.getDelta(item, currentRequest))) {
                item.getEditRange().getStart().setLine(item.getEditRange().getStart().getLine() + delta);
                item.getEditRange().getEnd().setLine(item.getEditRange().getEnd().getLine() + delta);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                currentRequest.setRender(currentRequest.createRender());
                currentRequest.getRender().renderInlineEditItem(item);
                CosyStatusBarWidget.setStatusBarGenerating(message.getProject(), false, false);
            });
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to handle rewrite code action", (Throwable)e);
            return false;
        }
    }

    private int getDelta(RewriteCodeAction item, InlineEditRequest currentRequest) {
        int delta = 0;
        int startLine = item.getEditRange().getStart().getLine();
        for (DiffChangeModel mode : currentRequest.getDiffChangeModels()) {
            List<LineFragment> fragments = mode.getDiffResult();
            if (mode.isOnlyDeleted()) {
                for (LineFragment fragment : fragments) {
                    if (startLine < fragment.getStartLine2()) continue;
                    delta += fragment.getStartLine1() - fragment.getEndLine1();
                }
                continue;
            }
            for (LineFragment fragment : fragments) {
                if (startLine < fragment.getStartLine2()) continue;
                delta += fragment.getEndLine2() - fragment.getStartLine2() - (fragment.getEndLine1() - fragment.getStartLine1());
            }
        }
        return delta;
    }
}

