/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.cache;

import com.alibabacloud.intellij.qoder.editor.model.InlayCompletionRequest;
import com.alibabacloud.intellij.qoder.service.model.Features;
import com.alibabacloud.intellij.qoder.util.CompletionUtil;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.Diff;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.CompletionItem;

public class CompletionCache {
    private static final Logger LOG = Logger.getInstance(CompletionCache.class);
    private static final int MAX_PREFIX_LENGTH = 512;
    private static final int MAX_SUFFIX_LENGTH = 512;
    final LinkedList<CacheItem> items = new LinkedList();

    public void add(InlayCompletionRequest request, CompletionItem completionItem) {
        String completionText = completionItem.getInsertText();
        String editorContent = request.getParams().getFileContent();
        String editorPrefix = editorContent.substring(Math.max(0, request.getCursorOffset() - 512), request.getCursorOffset());
        String editorSuffix = "";
        String editorSuffixLine = "";
        int endOfLineOffset = editorContent.indexOf(10, request.getCursorOffset());
        if (endOfLineOffset != -1) {
            editorSuffix = editorContent.substring(endOfLineOffset, Math.min(editorContent.length(), endOfLineOffset + 512));
            editorSuffixLine = editorContent.substring(request.getCursorOffset(), endOfLineOffset);
        } else {
            editorSuffixLine = editorContent.substring(request.getCursorOffset());
        }
        LOG.debug("add cache completion:" + completionText);
        this.add(new CacheItem.CacheItemBuilder().requestId(request.getParams().getRequestId()).text(completionText).editorPrefix(editorPrefix).editorSuffix(editorSuffix).editorSuffixLine(editorSuffixLine).offset(request.getCursorOffset()).timestamp(System.currentTimeMillis()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(CacheItem item) {
        item.setTimestamp(System.currentTimeMillis());
        LinkedList<CacheItem> linkedList = this.items;
        synchronized (linkedList) {
            this.items.offer(item);
            this.items.sort(Comparator.comparingLong(CacheItem::getTimestamp).reversed());
            if (this.items.size() > 10) {
                this.items.pollLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionItem getCacheResult(Editor editor) throws Exception {
        int caretOffset = EditorUtil.getCaretOffset(editor);
        CacheItem validItem = null;
        String changeText = null;
        LinkedList<CacheItem> linkedList = this.items;
        synchronized (linkedList) {
            Iterator it = this.items.iterator();
            while (it.hasNext()) {
                CacheItem item = (CacheItem)it.next();
                if (item.offset > caretOffset || !item.text.startsWith(changeText = editor.getDocument().getText(new TextRange(item.offset, caretOffset)))) continue;
                it.remove();
                validItem = item;
                break;
            }
        }
        if (validItem != null) {
            validItem.setTimestamp(System.currentTimeMillis());
            this.add(validItem);
            String editorPrefix = editor.getDocument().getText(new TextRange(Math.max(0, validItem.getOffset() - 512), validItem.getOffset()));
            String editorContent = editor.getDocument().getText();
            int adjustOffset = validItem.getOffset() + changeText.length();
            int endOfLineOffset = editorContent.indexOf(10, adjustOffset);
            String editorSuffix = "";
            if (endOfLineOffset != -1) {
                editorSuffix = editorContent.substring(endOfLineOffset, Math.min(editorContent.length(), endOfLineOffset + 512));
            }
            LOG.debug("valid cache completion item: " + validItem.text);
            if (!editorPrefix.equals(validItem.editorPrefix) || !editorSuffix.equals(validItem.editorSuffix)) {
                LOG.debug("prefix or suffix changed, ignore");
                return null;
            }
            String editorLineSuffix = CompletionUtil.getCursorSuffix(editor, caretOffset);
            String adjustCompletionText = validItem.text.substring(changeText.length());
            String commonPrefix = CompletionUtil.getCommonPrefix(adjustCompletionText, editorLineSuffix);
            if (StringUtils.isNotBlank((CharSequence)commonPrefix)) {
                LOG.debug("suffix common has prefix, ignore editorLineSuffix:" + editorLineSuffix + " commonPrefix:" + commonPrefix + " adjustCompletionText:" + adjustCompletionText + " changeText:" + changeText + " validItem.text:" + validItem.text);
                return null;
            }
            if (editorLineSuffix.equals(validItem.editorSuffixLine)) {
                LOG.debug("completion suffix match, editorLineSuffix:" + editorLineSuffix + " commonPrefix:" + commonPrefix + " , using cache result::" + adjustCompletionText);
                return this.buildItem(validItem, adjustCompletionText);
            }
            ArrayList<String> completionLines = new ArrayList<String>(Arrays.asList(adjustCompletionText.split("\n")));
            if (StringUtils.isNotBlank((CharSequence)editorLineSuffix)) {
                if (!Features.COMPLETION_CACHE_DIFF_CLIP_ENABLE.booleanValue().booleanValue()) {
                    LOG.debug("completion cache diff clip disabled");
                    return null;
                }
                CompletionUtil.removeOverlapTrailingLines(completionLines, editor.getDocument().getText(), caretOffset);
                if (!StringUtils.containsAny((CharSequence)((CharSequence)completionLines.get(0)), (CharSequence)"(){}>") || !StringUtils.containsAny((CharSequence)editorLineSuffix, (CharSequence)"(){}>")) {
                    return null;
                }
                int[] editorChars = editorLineSuffix.chars().toArray();
                int[] completionChars = ((String)completionLines.get(0)).chars().toArray();
                CompletionUtil.normalizeCharPairs(completionChars);
                Diff.Change changelist = Diff.buildChanges((int[])editorChars, (int[])completionChars);
                if (changelist == null) {
                    return null;
                }
                Diff.Change change = (Diff.Change)changelist.toList().get(0);
                if (change.inserted > 0 && change.line0 == 0) {
                    return this.buildItem(validItem, new String(((String)completionLines.get(0)).chars().toArray(), change.line1, change.inserted));
                }
                return null;
            }
            return completionLines.isEmpty() ? null : this.buildItem(validItem, String.join((CharSequence)"\n", completionLines));
        }
        return null;
    }

    private CompletionItem buildItem(CacheItem item, String completionText) {
        CompletionItem result = new CompletionItem();
        result.setInsertText(completionText);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("RequestId", item.requestId);
        jsonObject.addProperty("CacheId", item.requestId);
        jsonObject.addProperty("finished", Boolean.valueOf(true));
        jsonObject.addProperty("useCache", Boolean.valueOf(true));
        result.setData((Object)jsonObject);
        return result;
    }

    @Generated
    public LinkedList<CacheItem> getItems() {
        return this.items;
    }

    public static class CacheItem {
        String text;
        String editorPrefix;
        String editorSuffix;
        String editorSuffixLine;
        String requestId;
        int offset;
        long timestamp;

        @Generated
        public static CacheItemBuilder builder() {
            return new CacheItemBuilder();
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public String getEditorPrefix() {
            return this.editorPrefix;
        }

        @Generated
        public String getEditorSuffix() {
            return this.editorSuffix;
        }

        @Generated
        public String getEditorSuffixLine() {
            return this.editorSuffixLine;
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public int getOffset() {
            return this.offset;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @Generated
        public void setEditorPrefix(String editorPrefix) {
            this.editorPrefix = editorPrefix;
        }

        @Generated
        public void setEditorSuffix(String editorSuffix) {
            this.editorSuffix = editorSuffix;
        }

        @Generated
        public void setEditorSuffixLine(String editorSuffixLine) {
            this.editorSuffixLine = editorSuffixLine;
        }

        @Generated
        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Generated
        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Generated
        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheItem)) {
                return false;
            }
            CacheItem other = (CacheItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$editorPrefix = this.getEditorPrefix();
            String other$editorPrefix = other.getEditorPrefix();
            if (this$editorPrefix == null ? other$editorPrefix != null : !this$editorPrefix.equals(other$editorPrefix)) {
                return false;
            }
            String this$editorSuffix = this.getEditorSuffix();
            String other$editorSuffix = other.getEditorSuffix();
            if (this$editorSuffix == null ? other$editorSuffix != null : !this$editorSuffix.equals(other$editorSuffix)) {
                return false;
            }
            String this$editorSuffixLine = this.getEditorSuffixLine();
            String other$editorSuffixLine = other.getEditorSuffixLine();
            if (this$editorSuffixLine == null ? other$editorSuffixLine != null : !this$editorSuffixLine.equals(other$editorSuffixLine)) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            return this.getTimestamp() == other.getTimestamp();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CacheItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $editorPrefix = this.getEditorPrefix();
            result = result * 59 + ($editorPrefix == null ? 43 : $editorPrefix.hashCode());
            String $editorSuffix = this.getEditorSuffix();
            result = result * 59 + ($editorSuffix == null ? 43 : $editorSuffix.hashCode());
            String $editorSuffixLine = this.getEditorSuffixLine();
            result = result * 59 + ($editorSuffixLine == null ? 43 : $editorSuffixLine.hashCode());
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            result = result * 59 + this.getOffset();
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            return result;
        }

        @Generated
        public String toString() {
            return "CompletionCache.CacheItem(text=" + this.getText() + ", editorPrefix=" + this.getEditorPrefix() + ", editorSuffix=" + this.getEditorSuffix() + ", editorSuffixLine=" + this.getEditorSuffixLine() + ", requestId=" + this.getRequestId() + ", offset=" + this.getOffset() + ", timestamp=" + this.getTimestamp() + ")";
        }

        @Generated
        public CacheItem() {
        }

        @Generated
        public CacheItem(String text, String editorPrefix, String editorSuffix, String editorSuffixLine, String requestId, int offset, long timestamp) {
            this.text = text;
            this.editorPrefix = editorPrefix;
            this.editorSuffix = editorSuffix;
            this.editorSuffixLine = editorSuffixLine;
            this.requestId = requestId;
            this.offset = offset;
            this.timestamp = timestamp;
        }

        @Generated
        public static class CacheItemBuilder {
            @Generated
            private String text;
            @Generated
            private String editorPrefix;
            @Generated
            private String editorSuffix;
            @Generated
            private String editorSuffixLine;
            @Generated
            private String requestId;
            @Generated
            private int offset;
            @Generated
            private long timestamp;

            @Generated
            CacheItemBuilder() {
            }

            @Generated
            public CacheItemBuilder text(String text) {
                this.text = text;
                return this;
            }

            @Generated
            public CacheItemBuilder editorPrefix(String editorPrefix) {
                this.editorPrefix = editorPrefix;
                return this;
            }

            @Generated
            public CacheItemBuilder editorSuffix(String editorSuffix) {
                this.editorSuffix = editorSuffix;
                return this;
            }

            @Generated
            public CacheItemBuilder editorSuffixLine(String editorSuffixLine) {
                this.editorSuffixLine = editorSuffixLine;
                return this;
            }

            @Generated
            public CacheItemBuilder requestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Generated
            public CacheItemBuilder offset(int offset) {
                this.offset = offset;
                return this;
            }

            @Generated
            public CacheItemBuilder timestamp(long timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            @Generated
            public CacheItem build() {
                return new CacheItem(this.text, this.editorPrefix, this.editorSuffix, this.editorSuffixLine, this.requestId, this.offset, this.timestamp);
            }

            @Generated
            public String toString() {
                return "CompletionCache.CacheItem.CacheItemBuilder(text=" + this.text + ", editorPrefix=" + this.editorPrefix + ", editorSuffix=" + this.editorSuffix + ", editorSuffixLine=" + this.editorSuffixLine + ", requestId=" + this.requestId + ", offset=" + this.offset + ", timestamp=" + this.timestamp + ")";
            }
        }
    }
}

