/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.cache;

import com.alibabacloud.intellij.qoder.editor.cache.CompletionCache;
import com.alibabacloud.intellij.qoder.editor.model.InlayCompletionRequest;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.eclipse.lsp4j.CompletionItem;

public class CompletionCacheManager {
    private static final Logger LOGGER = Logger.getInstance(CompletionCacheManager.class);
    private static final CompletionCacheManager instance = new CompletionCacheManager();
    private static final int MAX_FILE_CACHE_COUNT = 10;
    private static final int CACHE_MINUTE_LIMIT = 5;
    private final Cache<String, CompletionCache> completionCaches = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(10L).build();

    private CompletionCacheManager() {
    }

    public CompletionCache getCompletionCache(Editor editor) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (virtualFile == null) {
            return null;
        }
        return (CompletionCache)this.completionCaches.get((Object)this.generateKey(project.getBasePath(), virtualFile.getPresentableUrl()), key -> new CompletionCache());
    }

    public CompletionItem getCacheResult(Editor editor) {
        CompletionCache completionCache = this.getCompletionCache(editor);
        if (completionCache == null) {
            return null;
        }
        try {
            return completionCache.getCacheResult(editor);
        }
        catch (Exception e) {
            LOGGER.warn("get cache result error", (Throwable)e);
            return null;
        }
    }

    public boolean add(InlayCompletionRequest request, CompletionItem completionItem) {
        CompletionCache completionCache = this.getCompletionCache(request.getEditor());
        if (completionCache == null) {
            return false;
        }
        completionCache.add(request, completionItem);
        return true;
    }

    private String generateKey(String workspace, String filePath) {
        return workspace + ":" + filePath;
    }

    @Generated
    public static CompletionCacheManager getInstance() {
        return instance;
    }
}

