/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.cache;

import com.alibabacloud.intellij.qoder.editor.model.InlayCompletionRequest;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class CompletionRequestManager {
    private static final CompletionRequestManager instance = new CompletionRequestManager();
    private static final int MAX_REQUEST_CACHE_COUNT = 10;
    private static final int CACHE_MINUTE_LIMIT = 1;
    private final Cache<String, InlayCompletionRequest> requestCaches = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(10L).build();

    public void add(InlayCompletionRequest request) {
        this.requestCaches.put((Object)request.getParams().getRequestId(), (Object)request);
    }

    public InlayCompletionRequest getRequest(String requestId) {
        return (InlayCompletionRequest)this.requestCaches.getIfPresent((Object)requestId);
    }

    @Generated
    public static CompletionRequestManager getInstance() {
        return instance;
    }
}

