/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.model;

import com.alibabacloud.intellij.qoder.completion.model.CompletionRenderType;
import com.alibabacloud.intellij.qoder.editor.model.InlayCompletionRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class CosyEditorInlayItem {
    private String requestId;
    private String cacheId;
    private int editorOffset;
    private String content;
    private List<EditorInlayItemChunk> chunks;
    private int totalLineCount;
    private boolean rendered = false;
    private long firstDisplayTimeMs;
    private long displayTimeMs;
    private int rankIndex;
    private String batchId;
    private boolean accepted = false;
    private boolean useCache = false;
    InlayCompletionRequest request;

    public String refactorByAcceptLine() {
        if (this.chunks == null || this.chunks.isEmpty()) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        Object validContent = "";
        while (StringUtils.isBlank((CharSequence)validContent) && StringUtils.isNotBlank((CharSequence)this.content)) {
            if (this.chunks.isEmpty()) {
                return null;
            }
            EditorInlayItemChunk chunk = this.chunks.get(0);
            if (chunk.getCompletionLines() == null || chunk.getCompletionLines().isEmpty()) {
                return null;
            }
            String line = chunk.getCompletionLines().get(0);
            lines.add(line);
            validContent = (String)validContent + line;
            if (CompletionRenderType.Inline == chunk.getType()) {
                this.chunks.remove(0);
            } else if (CompletionRenderType.Block == chunk.getType()) {
                chunk.getCompletionLines().remove(0);
            }
            this.totalLineCount = 0;
            StringBuilder sb = new StringBuilder();
            for (EditorInlayItemChunk c : this.chunks) {
                for (String line1 : c.getCompletionLines()) {
                    ++this.totalLineCount;
                    sb.append(line1).append("\n");
                }
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            this.content = sb.toString();
        }
        return StringUtils.join(lines, (String)"\n");
    }

    public void addChunk(CompletionRenderType type, List<String> completionLines) {
        if (this.chunks == null) {
            this.chunks = new ArrayList<EditorInlayItemChunk>();
        }
        this.chunks.add(new EditorInlayItemChunk(type, completionLines));
        this.totalLineCount += completionLines.size();
    }

    public String getLines(int lineCount) {
        String[] lines = this.content.split("\r\n|\n");
        if (lineCount <= 0 || lineCount > lines.length) {
            return null;
        }
        return Arrays.stream(lines).limit(lineCount).reduce("", (s1, s2) -> s1 + s2 + "\n");
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public String getCacheId() {
        return this.cacheId;
    }

    @Generated
    public int getEditorOffset() {
        return this.editorOffset;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public List<EditorInlayItemChunk> getChunks() {
        return this.chunks;
    }

    @Generated
    public int getTotalLineCount() {
        return this.totalLineCount;
    }

    @Generated
    public boolean isRendered() {
        return this.rendered;
    }

    @Generated
    public long getFirstDisplayTimeMs() {
        return this.firstDisplayTimeMs;
    }

    @Generated
    public long getDisplayTimeMs() {
        return this.displayTimeMs;
    }

    @Generated
    public int getRankIndex() {
        return this.rankIndex;
    }

    @Generated
    public String getBatchId() {
        return this.batchId;
    }

    @Generated
    public boolean isAccepted() {
        return this.accepted;
    }

    @Generated
    public boolean isUseCache() {
        return this.useCache;
    }

    @Generated
    public InlayCompletionRequest getRequest() {
        return this.request;
    }

    @Generated
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Generated
    public void setCacheId(String cacheId) {
        this.cacheId = cacheId;
    }

    @Generated
    public void setEditorOffset(int editorOffset) {
        this.editorOffset = editorOffset;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setChunks(List<EditorInlayItemChunk> chunks) {
        this.chunks = chunks;
    }

    @Generated
    public void setTotalLineCount(int totalLineCount) {
        this.totalLineCount = totalLineCount;
    }

    @Generated
    public void setRendered(boolean rendered) {
        this.rendered = rendered;
    }

    @Generated
    public void setFirstDisplayTimeMs(long firstDisplayTimeMs) {
        this.firstDisplayTimeMs = firstDisplayTimeMs;
    }

    @Generated
    public void setDisplayTimeMs(long displayTimeMs) {
        this.displayTimeMs = displayTimeMs;
    }

    @Generated
    public void setRankIndex(int rankIndex) {
        this.rankIndex = rankIndex;
    }

    @Generated
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @Generated
    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    @Generated
    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    @Generated
    public void setRequest(InlayCompletionRequest request) {
        this.request = request;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CosyEditorInlayItem)) {
            return false;
        }
        CosyEditorInlayItem other = (CosyEditorInlayItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$cacheId = this.getCacheId();
        String other$cacheId = other.getCacheId();
        if (this$cacheId == null ? other$cacheId != null : !this$cacheId.equals(other$cacheId)) {
            return false;
        }
        if (this.getEditorOffset() != other.getEditorOffset()) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<EditorInlayItemChunk> this$chunks = this.getChunks();
        List<EditorInlayItemChunk> other$chunks = other.getChunks();
        if (this$chunks == null ? other$chunks != null : !((Object)this$chunks).equals(other$chunks)) {
            return false;
        }
        if (this.getTotalLineCount() != other.getTotalLineCount()) {
            return false;
        }
        if (this.isRendered() != other.isRendered()) {
            return false;
        }
        if (this.getFirstDisplayTimeMs() != other.getFirstDisplayTimeMs()) {
            return false;
        }
        if (this.getDisplayTimeMs() != other.getDisplayTimeMs()) {
            return false;
        }
        if (this.getRankIndex() != other.getRankIndex()) {
            return false;
        }
        String this$batchId = this.getBatchId();
        String other$batchId = other.getBatchId();
        if (this$batchId == null ? other$batchId != null : !this$batchId.equals(other$batchId)) {
            return false;
        }
        if (this.isAccepted() != other.isAccepted()) {
            return false;
        }
        if (this.isUseCache() != other.isUseCache()) {
            return false;
        }
        InlayCompletionRequest this$request = this.getRequest();
        InlayCompletionRequest other$request = other.getRequest();
        return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CosyEditorInlayItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $cacheId = this.getCacheId();
        result = result * 59 + ($cacheId == null ? 43 : $cacheId.hashCode());
        result = result * 59 + this.getEditorOffset();
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<EditorInlayItemChunk> $chunks = this.getChunks();
        result = result * 59 + ($chunks == null ? 43 : ((Object)$chunks).hashCode());
        result = result * 59 + this.getTotalLineCount();
        result = result * 59 + (this.isRendered() ? 79 : 97);
        long $firstDisplayTimeMs = this.getFirstDisplayTimeMs();
        result = result * 59 + (int)($firstDisplayTimeMs >>> 32 ^ $firstDisplayTimeMs);
        long $displayTimeMs = this.getDisplayTimeMs();
        result = result * 59 + (int)($displayTimeMs >>> 32 ^ $displayTimeMs);
        result = result * 59 + this.getRankIndex();
        String $batchId = this.getBatchId();
        result = result * 59 + ($batchId == null ? 43 : $batchId.hashCode());
        result = result * 59 + (this.isAccepted() ? 79 : 97);
        result = result * 59 + (this.isUseCache() ? 79 : 97);
        InlayCompletionRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CosyEditorInlayItem(requestId=" + this.getRequestId() + ", cacheId=" + this.getCacheId() + ", editorOffset=" + this.getEditorOffset() + ", content=" + this.getContent() + ", chunks=" + this.getChunks() + ", totalLineCount=" + this.getTotalLineCount() + ", rendered=" + this.isRendered() + ", firstDisplayTimeMs=" + this.getFirstDisplayTimeMs() + ", displayTimeMs=" + this.getDisplayTimeMs() + ", rankIndex=" + this.getRankIndex() + ", batchId=" + this.getBatchId() + ", accepted=" + this.isAccepted() + ", useCache=" + this.isUseCache() + ", request=" + this.getRequest() + ")";
    }

    @Generated
    public CosyEditorInlayItem() {
    }

    @Generated
    public CosyEditorInlayItem(String requestId, String cacheId, int editorOffset, String content, List<EditorInlayItemChunk> chunks, int totalLineCount, boolean rendered, long firstDisplayTimeMs, long displayTimeMs, int rankIndex, String batchId, boolean accepted, boolean useCache, InlayCompletionRequest request) {
        this.requestId = requestId;
        this.cacheId = cacheId;
        this.editorOffset = editorOffset;
        this.content = content;
        this.chunks = chunks;
        this.totalLineCount = totalLineCount;
        this.rendered = rendered;
        this.firstDisplayTimeMs = firstDisplayTimeMs;
        this.displayTimeMs = displayTimeMs;
        this.rankIndex = rankIndex;
        this.batchId = batchId;
        this.accepted = accepted;
        this.useCache = useCache;
        this.request = request;
    }

    public static class EditorInlayItemChunk {
        private CompletionRenderType type;
        private List<String> completionLines;

        @Generated
        public CompletionRenderType getType() {
            return this.type;
        }

        @Generated
        public List<String> getCompletionLines() {
            return this.completionLines;
        }

        @Generated
        public void setType(CompletionRenderType type) {
            this.type = type;
        }

        @Generated
        public void setCompletionLines(List<String> completionLines) {
            this.completionLines = completionLines;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EditorInlayItemChunk)) {
                return false;
            }
            EditorInlayItemChunk other = (EditorInlayItemChunk)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CompletionRenderType this$type = this.getType();
            CompletionRenderType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            List<String> this$completionLines = this.getCompletionLines();
            List<String> other$completionLines = other.getCompletionLines();
            return !(this$completionLines == null ? other$completionLines != null : !((Object)this$completionLines).equals(other$completionLines));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EditorInlayItemChunk;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CompletionRenderType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            List<String> $completionLines = this.getCompletionLines();
            result = result * 59 + ($completionLines == null ? 43 : ((Object)$completionLines).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CosyEditorInlayItem.EditorInlayItemChunk(type=" + this.getType() + ", completionLines=" + this.getCompletionLines() + ")";
        }

        @Generated
        public EditorInlayItemChunk() {
        }

        @Generated
        public EditorInlayItemChunk(CompletionRenderType type, List<String> completionLines) {
            this.type = type;
            this.completionLines = completionLines;
        }
    }
}

