/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.model;

import com.alibabacloud.intellij.qoder.editor.model.CosyEditorInlayItem;
import com.alibabacloud.intellij.qoder.editor.model.InlayCompletionRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class CosyEditorInlayList {
    List<CosyEditorInlayItem> items;
    InlayCompletionRequest request;
    int selectIndex;
    String prefix;
    Lock lock = new ReentrantLock();

    public void add(CosyEditorInlayItem item) {
        this.lock.lock();
        try {
            if (this.items == null) {
                this.items = new ArrayList<CosyEditorInlayItem>();
            }
            this.selectIndex = this.items.size();
            item.setRankIndex(this.selectIndex);
            this.items.add(item);
            String batchId = this.items.get(0).getBatchId();
            if (StringUtils.isBlank((CharSequence)batchId)) {
                batchId = this.items.get(0).getRequestId();
            }
            item.setBatchId(batchId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int index, CosyEditorInlayItem item) {
        this.lock.lock();
        try {
            if (this.items != null && index >= 0 && index < this.items.size()) {
                CosyEditorInlayItem oldItem = this.items.get(index);
                if (oldItem != null) {
                    item.setBatchId(oldItem.getBatchId());
                    item.setRendered(oldItem.isRendered());
                    item.setFirstDisplayTimeMs(oldItem.getFirstDisplayTimeMs());
                    item.setDisplayTimeMs(oldItem.getDisplayTimeMs());
                }
                item.setRankIndex(index);
                this.items.set(index, item);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public CosyEditorInlayItem select(int index) {
        this.lock.lock();
        try {
            if (this.items == null || this.items.isEmpty()) {
                this.selectIndex = -1;
                CosyEditorInlayItem cosyEditorInlayItem = null;
                return cosyEditorInlayItem;
            }
            if (index < 0) {
                index = this.items.size() + index;
            } else if (index >= this.items.size()) {
                index -= this.items.size();
            }
            this.selectIndex = index;
        }
        finally {
            this.lock.unlock();
        }
        return this.getCurrentInlayItem();
    }

    public CosyEditorInlayItem getCurrentInlayItem() {
        this.lock.lock();
        try {
            if (this.items == null || this.selectIndex < 0 || this.selectIndex >= this.items.size()) {
                CosyEditorInlayItem cosyEditorInlayItem = null;
                return cosyEditorInlayItem;
            }
            CosyEditorInlayItem cosyEditorInlayItem = this.items.get(this.selectIndex);
            return cosyEditorInlayItem;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CosyEditorInlayItem getCurrentAndRemoveOtherInlayItem() {
        this.lock.lock();
        try {
            if (this.items == null || this.selectIndex < 0 || this.selectIndex >= this.items.size()) {
                CosyEditorInlayItem cosyEditorInlayItem = null;
                return cosyEditorInlayItem;
            }
            CosyEditorInlayItem item = this.items.get(this.selectIndex);
            if (this.items.size() > 1) {
                this.items.clear();
                this.items.add(item);
                this.selectIndex = 0;
            }
            CosyEditorInlayItem cosyEditorInlayItem = item;
            return cosyEditorInlayItem;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.items == null || this.items.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.items == null ? 0 : this.items.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Generated
    public List<CosyEditorInlayItem> getItems() {
        return this.items;
    }

    @Generated
    public InlayCompletionRequest getRequest() {
        return this.request;
    }

    @Generated
    public int getSelectIndex() {
        return this.selectIndex;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public Lock getLock() {
        return this.lock;
    }

    @Generated
    public void setItems(List<CosyEditorInlayItem> items) {
        this.items = items;
    }

    @Generated
    public void setRequest(InlayCompletionRequest request) {
        this.request = request;
    }

    @Generated
    public void setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
    }

    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Generated
    public void setLock(Lock lock) {
        this.lock = lock;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CosyEditorInlayList)) {
            return false;
        }
        CosyEditorInlayList other = (CosyEditorInlayList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<CosyEditorInlayItem> this$items = this.getItems();
        List<CosyEditorInlayItem> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        InlayCompletionRequest this$request = this.getRequest();
        InlayCompletionRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        if (this.getSelectIndex() != other.getSelectIndex()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Lock this$lock = this.getLock();
        Lock other$lock = other.getLock();
        return !(this$lock == null ? other$lock != null : !this$lock.equals(other$lock));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CosyEditorInlayList;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CosyEditorInlayItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        InlayCompletionRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        result = result * 59 + this.getSelectIndex();
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Lock $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CosyEditorInlayList(items=" + this.getItems() + ", request=" + this.getRequest() + ", selectIndex=" + this.getSelectIndex() + ", prefix=" + this.getPrefix() + ", lock=" + this.getLock() + ")";
    }

    @Generated
    public CosyEditorInlayList() {
    }

    @Generated
    public CosyEditorInlayList(List<CosyEditorInlayItem> items, InlayCompletionRequest request, int selectIndex, String prefix, Lock lock) {
        this.items = items;
        this.request = request;
        this.selectIndex = selectIndex;
        this.prefix = prefix;
        this.lock = lock;
    }
}

