/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.model;

import com.alibabacloud.intellij.qoder.core.lsp.model.model.RewriteCodeAction;
import com.alibabacloud.intellij.qoder.editor.render.HighlighterDrawUtil;
import com.alibabacloud.intellij.qoder.util.DiffUtil;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class DiffChangeModel {
    List<LineFragment> diffResult;
    RewriteCodeAction item;

    public DiffChangeModel(List<LineFragment> diffResult, RewriteCodeAction item) {
        this.diffResult = diffResult;
        this.item = item;
    }

    public boolean isOnlyDeleted() {
        return StringUtils.isBlank((CharSequence)this.item.getContent()) && this.diffResult.size() == 1;
    }

    public String getRewriteChangeCode() {
        String[] lines = this.item.getContent().split("\n", -1);
        int startLine = Integer.MAX_VALUE;
        int endLine = 0;
        for (LineFragment fragment : this.diffResult) {
            startLine = Math.min(startLine, fragment.getStartLine2());
            endLine = Math.max(endLine, fragment.getEndLine2());
        }
        CharSequence[] newLines = Arrays.copyOfRange(lines, startLine, endLine);
        return String.join((CharSequence)"\n", newLines);
    }

    public LineRange getOriginalChangeLineRange() {
        int startLine = Integer.MAX_VALUE;
        int endLine = 0;
        int lineOffset = this.item.getEditRange().getStart().getLine();
        for (LineFragment fragment : this.diffResult) {
            startLine = Math.min(startLine, fragment.getStartLine1() + lineOffset);
            endLine = Math.max(endLine, fragment.getEndLine1() + lineOffset);
        }
        return new LineRange(startLine, endLine);
    }

    public boolean containsLineBeforeChange(Document document, int lineNumber) {
        int startOffsetOfLine = document.getLineStartOffset(this.item.getEditRange().getStart().getLine());
        for (LineFragment fragment : this.diffResult) {
            LineFragment absoluteChange = DiffUtil.addOffset(fragment, this.item.getEditRange().getStart().getLine(), startOffsetOfLine);
            if (absoluteChange.getStartLine1() == absoluteChange.getEndLine1() && lineNumber == absoluteChange.getStartLine1()) {
                return true;
            }
            if (absoluteChange.getStartLine1() > lineNumber || absoluteChange.getEndLine1() <= lineNumber) continue;
            return true;
        }
        return false;
    }

    public int getEndOffsetAfterChange(Document document) {
        int startOffsetOfLine = document.getLineStartOffset(this.item.getEditRange().getStart().getLine());
        int targetOffset = -1;
        for (LineFragment fragment : this.diffResult) {
            LineFragment absoluteChange = DiffUtil.addOffset(fragment, this.item.getEditRange().getStart().getLine(), startOffsetOfLine);
            int changeStart = document.getLineStartOffset(absoluteChange.getStartLine2());
            if (fragment.getInnerFragments() != null) {
                for (DiffFragment innerFragment : fragment.getInnerFragments()) {
                    int absoluteOffset = changeStart + innerFragment.getEndOffset2();
                    if (targetOffset != -1 && absoluteOffset <= targetOffset) continue;
                    targetOffset = absoluteOffset;
                }
                continue;
            }
            targetOffset = absoluteChange.getEndOffset2();
        }
        if (targetOffset > 0) {
            for (int i = targetOffset; i > 0; --i) {
                String charAt = document.getText(new TextRange(i - 1, i));
                if (charAt.equals("\n") || charAt.equals("\r")) continue;
                return i;
            }
        }
        return targetOffset;
    }

    public int getLineStartOffsetBeforeChange(Document document) {
        int startOffsetOfLine = document.getLineStartOffset(this.item.getEditRange().getStart().getLine());
        int minStartLine = Integer.MAX_VALUE;
        for (LineFragment fragment : this.diffResult) {
            LineFragment absoluteChange = DiffUtil.addOffset(fragment, this.item.getEditRange().getStart().getLine(), startOffsetOfLine);
            minStartLine = Math.min(minStartLine, absoluteChange.getStartLine1());
        }
        int targetOffset = document.getLineStartOffset(minStartLine);
        return HighlighterDrawUtil.getStartValidCharOffset(document, targetOffset);
    }

    public int getStartOffsetBeforeChange(Document document) {
        int startOffsetOfLine = document.getLineStartOffset(this.item.getEditRange().getStart().getLine());
        int targetOffset = -1;
        for (LineFragment fragment : this.diffResult) {
            LineFragment absoluteChange = DiffUtil.addOffset(fragment, this.item.getEditRange().getStart().getLine(), startOffsetOfLine);
            int changeStart = document.getLineStartOffset(absoluteChange.getStartLine1());
            if (fragment.getInnerFragments() != null) {
                for (DiffFragment innerFragment : fragment.getInnerFragments()) {
                    if (targetOffset != -1 && innerFragment.getEndOffset2() <= targetOffset) continue;
                    targetOffset = changeStart + innerFragment.getStartOffset1();
                }
                continue;
            }
            targetOffset = absoluteChange.getStartOffset1();
        }
        return targetOffset;
    }

    @Generated
    public List<LineFragment> getDiffResult() {
        return this.diffResult;
    }

    @Generated
    public RewriteCodeAction getItem() {
        return this.item;
    }
}

