/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.model;

import com.alibabacloud.intellij.qoder.core.lsp.model.params.InlineEditParams;
import com.alibabacloud.intellij.qoder.editor.model.DiffChangeModel;
import com.alibabacloud.intellij.qoder.editor.render.InlineEditRender;
import com.alibabacloud.intellij.qoder.search.enums.InlineTriggerModeEnum;
import com.alibabacloud.intellij.qoder.ui.search.topic.InlineEditFocusedNotifier;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class InlineEditRequest
implements Disposable {
    private InlineEditParams params;
    private Editor editor;
    private int cursorOffset;
    private boolean canceled = false;
    long triggerDelayTime;
    boolean isComment;
    InlineTriggerModeEnum triggerMode;
    AtomicReference<String> cacheId = new AtomicReference();
    private Map<String, Object> actionResult;
    InlineEditRender render;
    List<DiffChangeModel> diffChangeModels;

    public InlineEditRequest(InlineEditParams params, Editor editor, int cursorOffset) {
        this.params = params;
        this.editor = editor;
        this.cursorOffset = cursorOffset;
        this.render = this.createRender();
        this.actionResult = new ConcurrentHashMap<String, Object>();
        this.diffChangeModels = new CopyOnWriteArrayList<DiffChangeModel>();
    }

    public InlineEditRender createRender() {
        return new InlineEditRender(this);
    }

    public String getRequestId() {
        return this.params.getRequestId();
    }

    public String getSessionId() {
        return this.params.getSessionId();
    }

    public void setSessionId(String sessionId) {
        this.params.setSessionId(sessionId);
    }

    public void setCacheRequestId(String cacheRequestId) {
        if (StringUtils.isBlank((CharSequence)cacheRequestId)) {
            return;
        }
        this.cacheId.getAndSet(cacheRequestId);
    }

    public String getCacheRequestId() {
        return this.cacheId.get();
    }

    public void dispose() {
        this.canceled = true;
        Disposer.dispose((Disposable)this.render);
        this.render.dispose();
    }

    public boolean cancel() {
        if (this.canceled && !this.render.hasShowingInlineEdit()) {
            return false;
        }
        this.canceled = true;
        Disposer.dispose((Disposable)this);
        return true;
    }

    public void onlyDisposeRender() {
        Disposer.dispose((Disposable)this.render);
        this.render.dispose();
    }

    public void setRenderActive(boolean active) {
        if (this.canceled) {
            return;
        }
        Project project = this.editor.getProject();
        if (project != null) {
            ((InlineEditFocusedNotifier)project.getMessageBus().syncPublisher(InlineEditFocusedNotifier.INLINE_EDIT_FOCUSED_NOTIFIER)).activateChange();
        }
    }

    public boolean equalsRequest(@NotNull InlineEditRequest o) {
        if (o == null) {
            InlineEditRequest.$$$reportNull$$$0(0);
        }
        if (this.params == null || o.getParams() == null) {
            return false;
        }
        return this.params.getRequestId().equals(o.getParams().getRequestId());
    }

    public boolean isChangeActivated() {
        int cursorOffset = EditorUtil.getCaretOffset(this.editor);
        int cursorLine = this.editor.getDocument().getLineNumber(cursorOffset);
        return this.getRender().getDiffChangeModel().containsLineBeforeChange(this.editor.getDocument(), cursorLine);
    }

    public void setActionResult(String key, Object value) {
        this.actionResult.put(key, value);
    }

    public Object getActionResult(String key) {
        return this.actionResult.get(key);
    }

    public Disposable getDisposable() {
        return this;
    }

    public boolean hasShowingInlineEdit() {
        return this.render.hasShowingInlineEdit();
    }

    @Generated
    public InlineEditParams getParams() {
        return this.params;
    }

    @Generated
    public Editor getEditor() {
        return this.editor;
    }

    @Generated
    public int getCursorOffset() {
        return this.cursorOffset;
    }

    @Generated
    public long getTriggerDelayTime() {
        return this.triggerDelayTime;
    }

    @Generated
    public boolean isComment() {
        return this.isComment;
    }

    @Generated
    public InlineTriggerModeEnum getTriggerMode() {
        return this.triggerMode;
    }

    @Generated
    public AtomicReference<String> getCacheId() {
        return this.cacheId;
    }

    @Generated
    public Map<String, Object> getActionResult() {
        return this.actionResult;
    }

    @Generated
    public InlineEditRender getRender() {
        return this.render;
    }

    @Generated
    public List<DiffChangeModel> getDiffChangeModels() {
        return this.diffChangeModels;
    }

    @Generated
    public void setParams(InlineEditParams params) {
        this.params = params;
    }

    @Generated
    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    @Generated
    public void setCursorOffset(int cursorOffset) {
        this.cursorOffset = cursorOffset;
    }

    @Generated
    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    @Generated
    public void setTriggerDelayTime(long triggerDelayTime) {
        this.triggerDelayTime = triggerDelayTime;
    }

    @Generated
    public void setComment(boolean isComment) {
        this.isComment = isComment;
    }

    @Generated
    public void setTriggerMode(InlineTriggerModeEnum triggerMode) {
        this.triggerMode = triggerMode;
    }

    @Generated
    public void setCacheId(AtomicReference<String> cacheId) {
        this.cacheId = cacheId;
    }

    @Generated
    public void setActionResult(Map<String, Object> actionResult) {
        this.actionResult = actionResult;
    }

    @Generated
    public void setRender(InlineEditRender render) {
        this.render = render;
    }

    @Generated
    public void setDiffChangeModels(List<DiffChangeModel> diffChangeModels) {
        this.diffChangeModels = diffChangeModels;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineEditRequest)) {
            return false;
        }
        InlineEditRequest other = (InlineEditRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InlineEditParams this$params = this.getParams();
        InlineEditParams other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        Editor this$editor = this.getEditor();
        Editor other$editor = other.getEditor();
        if (this$editor == null ? other$editor != null : !this$editor.equals(other$editor)) {
            return false;
        }
        if (this.getCursorOffset() != other.getCursorOffset()) {
            return false;
        }
        if (this.isCanceled() != other.isCanceled()) {
            return false;
        }
        if (this.getTriggerDelayTime() != other.getTriggerDelayTime()) {
            return false;
        }
        if (this.isComment() != other.isComment()) {
            return false;
        }
        InlineTriggerModeEnum this$triggerMode = this.getTriggerMode();
        InlineTriggerModeEnum other$triggerMode = other.getTriggerMode();
        if (this$triggerMode == null ? other$triggerMode != null : !((Object)((Object)this$triggerMode)).equals((Object)other$triggerMode)) {
            return false;
        }
        AtomicReference<String> this$cacheId = this.getCacheId();
        AtomicReference<String> other$cacheId = other.getCacheId();
        if (this$cacheId == null ? other$cacheId != null : !this$cacheId.equals(other$cacheId)) {
            return false;
        }
        Map<String, Object> this$actionResult = this.getActionResult();
        Map<String, Object> other$actionResult = other.getActionResult();
        if (this$actionResult == null ? other$actionResult != null : !((Object)this$actionResult).equals(other$actionResult)) {
            return false;
        }
        InlineEditRender this$render = this.getRender();
        InlineEditRender other$render = other.getRender();
        if (this$render == null ? other$render != null : !this$render.equals(other$render)) {
            return false;
        }
        List<DiffChangeModel> this$diffChangeModels = this.getDiffChangeModels();
        List<DiffChangeModel> other$diffChangeModels = other.getDiffChangeModels();
        return !(this$diffChangeModels == null ? other$diffChangeModels != null : !((Object)this$diffChangeModels).equals(other$diffChangeModels));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InlineEditRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InlineEditParams $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        Editor $editor = this.getEditor();
        result = result * 59 + ($editor == null ? 43 : $editor.hashCode());
        result = result * 59 + this.getCursorOffset();
        result = result * 59 + (this.isCanceled() ? 79 : 97);
        long $triggerDelayTime = this.getTriggerDelayTime();
        result = result * 59 + (int)($triggerDelayTime >>> 32 ^ $triggerDelayTime);
        result = result * 59 + (this.isComment() ? 79 : 97);
        InlineTriggerModeEnum $triggerMode = this.getTriggerMode();
        result = result * 59 + ($triggerMode == null ? 43 : ((Object)((Object)$triggerMode)).hashCode());
        AtomicReference<String> $cacheId = this.getCacheId();
        result = result * 59 + ($cacheId == null ? 43 : $cacheId.hashCode());
        Map<String, Object> $actionResult = this.getActionResult();
        result = result * 59 + ($actionResult == null ? 43 : ((Object)$actionResult).hashCode());
        InlineEditRender $render = this.getRender();
        result = result * 59 + ($render == null ? 43 : $render.hashCode());
        List<DiffChangeModel> $diffChangeModels = this.getDiffChangeModels();
        result = result * 59 + ($diffChangeModels == null ? 43 : ((Object)$diffChangeModels).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InlineEditRequest(params=" + this.getParams() + ", editor=" + this.getEditor() + ", cursorOffset=" + this.getCursorOffset() + ", canceled=" + this.isCanceled() + ", triggerDelayTime=" + this.getTriggerDelayTime() + ", isComment=" + this.isComment() + ", triggerMode=" + this.getTriggerMode() + ", cacheId=" + this.getCacheId() + ", actionResult=" + this.getActionResult() + ", render=" + this.getRender() + ", diffChangeModels=" + this.getDiffChangeModels() + ")";
    }

    @Generated
    public boolean isCanceled() {
        return this.canceled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/alibabacloud/intellij/qoder/editor/model/InlineEditRequest", "equalsRequest"));
    }
}

