/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.render;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class StagePopupVerticalLayout
implements LayoutManager {
    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.computeLayoutSize(parent, Component::getPreferredSize);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.computeLayoutSize(parent, Component::getMinimumSize);
    }

    private Dimension computeLayoutSize(Container parent, SizeFunction sizeFunction) {
        int width = 0;
        int height = 0;
        for (Component component : parent.getComponents()) {
            Dimension size = sizeFunction.getSize(component);
            width = Math.max(width, size.width);
            height += size.height;
        }
        return new Dimension(width, height);
    }

    @Override
    public void layoutContainer(Container parent) {
        int height2;
        int height1;
        boolean isBig2;
        assert (parent.getComponentCount() == 2);
        Dimension size = parent.getSize();
        Component panel1 = parent.getComponent(0);
        Component panel2 = parent.getComponent(1);
        int height = size.height;
        Dimension prefSize1 = panel1.getPreferredSize();
        Dimension prefSize2 = panel2.getPreferredSize();
        int prefHeight1 = prefSize1.height;
        int prefHeight2 = prefSize2.height;
        boolean isBig1 = prefHeight1 > height / 2;
        boolean bl = isBig2 = prefHeight2 > height / 2;
        if (isBig1 && isBig2) {
            height1 = height / 2;
            height2 = height - height1;
        } else if (isBig1) {
            height2 = prefHeight2;
            height1 = height - height2;
        } else if (isBig2) {
            height1 = prefHeight1;
            height2 = height - height1;
        } else {
            height1 = prefHeight1;
            height2 = prefHeight2;
        }
        panel1.setBounds(new Rectangle(0, 0, size.width, height1));
        panel2.setBounds(new Rectangle(0, height1, size.width, height2));
    }

    @FunctionalInterface
    static interface SizeFunction {
        public Dimension getSize(Component var1);
    }
}

