/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.render;

import com.alibabacloud.intellij.qoder.editor.render.InlineEditRender;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.border.Border;

public class TabJumpButton
extends RoundRectPanel
implements Disposable {
    private static final int EDIT_STATUS_TOOLBAR_HEIGHT = 26;
    private static final int EDIT_STATUS_TOOLBAR_MARGIN = 12;
    Editor editor;
    InlineEditRender render;
    JLabel iconLabel;

    public TabJumpButton(final Editor editor, final InlineEditRender render) {
        this.editor = editor;
        this.render = render;
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(ColorUtil.getButtonBackgroundColor());
        this.setCornerRadius(8);
        this.setBorderColor(ColorUtil.getDefaultButtonColor());
        this.setCursor(Cursor.getPredefinedCursor(12));
        if (Disposer.isDisposed((Disposable)render)) {
            return;
        }
        this.setup();
        SwingUtil.foreachChildComponent(this, component -> {
            component.setCursor(Cursor.getPredefinedCursor(12));
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    TabJumpButton.this.setBackground(ColorUtil.getDefaultButtonColor());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TabJumpButton.this.setBackground(ColorUtil.getButtonBackgroundColor());
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    int changeStartOffset = render.getDiffChangeModel().getLineStartOffsetBeforeChange(editor.getDocument());
                    editor.getCaretModel().moveToOffset(changeStartOffset);
                    editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
                    render.getRequest().setRenderActive(true);
                }
            });
        });
        if (!Disposer.isDisposed((Disposable)render)) {
            Disposer.register((Disposable)render, (Disposable)this);
        }
        editor.getScrollingModel().addVisibleAreaListener(e -> this.updateLayout(), (Disposable)this);
        this.updateLayout();
    }

    private void setup() {
        this.iconLabel = new JLabel("\u2191");
        this.iconLabel.setBorder((Border)JBUI.Borders.empty());
        this.iconLabel.setPreferredSize(new Dimension(28, 28));
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setVerticalAlignment(0);
        this.add(this.iconLabel);
        JSeparator separator = new JSeparator(1);
        separator.setForeground(ColorUtil.getButtonSeparatorColor());
        this.add(separator);
        JLabel textLabel = new JLabel(CosyBundle.message("nes.tab.to.jump.button.text", new Object[0]));
        textLabel.setBorder((Border)JBUI.Borders.empty((int)6, (int)8));
        textLabel.setFont(textLabel.getFont().deriveFont(14.0f));
        this.add(textLabel);
        this.editor.getContentComponent().add(this);
    }

    public void updateLayout() {
        if (this.render.getRequest().isChangeActivated()) {
            this.setVisible(false);
            return;
        }
        Rectangle visibleArea = this.editor.getScrollingModel().getVisibleArea();
        Rectangle diffArea = this.render.getRenderProvider().getVisibleRect(this.editor);
        if (diffArea == null) {
            this.setVisible(false);
            return;
        }
        if (visibleArea.intersects(diffArea)) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            Dimension size = this.getPreferredSize();
            int scrollbarWidth = ((EditorImpl)this.editor).getScrollPane().getVerticalScrollBar().getWidth();
            int x = visibleArea.x + visibleArea.width - size.width - scrollbarWidth - 8;
            if (diffArea.y + diffArea.height < visibleArea.y) {
                this.iconLabel.setText("\u2191");
                int stickyLinesPanelHeight = EditorUtil.getStickyLinesPanelHeight(this.editor);
                int headerHeight = Math.max(26, stickyLinesPanelHeight);
                this.setBounds(x, visibleArea.y + headerHeight + 12, size.width, size.height);
            } else {
                this.iconLabel.setText("\u2193");
                this.setBounds(x, visibleArea.y + visibleArea.height - size.height - 8, size.width, size.height);
            }
        }
    }

    public void dispose() {
        this.editor.getContentComponent().remove(this);
    }
}

