/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.render;

import com.alibabacloud.intellij.qoder.editor.render.InlineHighlighterBuilder;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.util.ArrayList;
import java.util.List;

public class WordDiffMerger {
    private final Editor editor;
    private final List<DiffFragment> wordDiff2;
    private final List<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
    private int dirtyStart = -1;
    private int dirtyEnd = -1;
    private final List<DiffFragment> affectedFragments = new ArrayList<DiffFragment>();

    public WordDiffMerger(Editor editor, List<DiffFragment> wordDiff2) {
        this.editor = editor;
        this.wordDiff2 = wordDiff2;
    }

    public List<RangeHighlighter> run() {
        for (DiffFragment fragment2 : this.wordDiff2) {
            this.handleFragment(fragment2);
        }
        this.flush(Integer.MAX_VALUE);
        return this.highlighters;
    }

    private void handleFragment(DiffFragment fragment) {
        this.flush(fragment.getStartOffset2());
        this.markDirtyRange(fragment.getStartOffset2(), fragment.getEndOffset2());
        this.affectedFragments.add(fragment);
    }

    private void markDirtyRange(int start, int end) {
        if (this.dirtyEnd == -1) {
            this.dirtyStart = start;
            this.dirtyEnd = end;
        } else {
            this.dirtyEnd = Math.max(this.dirtyEnd, end);
        }
    }

    private void flush(int nextLine) {
        if (this.dirtyEnd != -1 && this.dirtyEnd < nextLine) {
            TextDiffType type = this.affectedFragments.stream().map(DiffUtil::getDiffType).distinct().findFirst().orElse(TextDiffType.MODIFIED);
            this.highlighters.addAll(new InlineHighlighterBuilder(this.editor, this.dirtyStart, this.dirtyEnd, type).withLayerPriority(1).done());
            this.dirtyStart = -1;
            this.dirtyEnd = -1;
            this.affectedFragments.clear();
        }
    }
}

